/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.UUID;
import org.codefilarete.stalactite.sql.statement.binder.DateBinder;
import org.codefilarete.stalactite.sql.statement.binder.LocalDateBinder;
import org.codefilarete.stalactite.sql.statement.binder.LocalDateTimeBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.PathBinder;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.UUIDParameterBinder;

public final class DefaultResultSetReaders {
    public static final ResultSetReader<Long> LONG_PRIMITIVE_READER = ResultSetReader.ofMethodReference(ResultSet::getLong);
    public static final ResultSetReader<Long> LONG_READER = new NullAwareResultSetReader<Long>(LONG_PRIMITIVE_READER);
    public static final ResultSetReader<Integer> INTEGER_PRIMITIVE_READER = ResultSetReader.ofMethodReference(ResultSet::getInt);
    public static final ResultSetReader<Integer> INTEGER_READER = new NullAwareResultSetReader<Integer>(INTEGER_PRIMITIVE_READER);
    public static final ResultSetReader<Byte> BYTE_PRIMITIVE_READER = ResultSetReader.ofMethodReference(ResultSet::getByte);
    public static final ResultSetReader<Byte> BYTE_READER = new NullAwareResultSetReader<Byte>(BYTE_PRIMITIVE_READER);
    public static final ResultSetReader<byte[]> BYTES_READER = ResultSetReader.ofMethodReference(ResultSet::getBytes);
    public static final ResultSetReader<Double> DOUBLE_PRIMITIVE_READER = ResultSetReader.ofMethodReference(ResultSet::getDouble);
    public static final ResultSetReader<Double> DOUBLE_READER = new NullAwareResultSetReader<Double>(DOUBLE_PRIMITIVE_READER);
    public static final ResultSetReader<Float> FLOAT_PRIMITIVE_READER = ResultSetReader.ofMethodReference(ResultSet::getFloat);
    public static final ResultSetReader<Float> FLOAT_READER = new NullAwareResultSetReader<Float>(FLOAT_PRIMITIVE_READER);
    public static final ResultSetReader<BigDecimal> BIGDECIMAL_READER = new NullAwareResultSetReader<BigDecimal>(ResultSet::getBigDecimal);
    public static final ResultSetReader<Boolean> BOOLEAN_PRIMITIVE_READER = ResultSetReader.ofMethodReference(ResultSet::getBoolean);
    public static final ResultSetReader<Boolean> BOOLEAN_READER = new NullAwareResultSetReader<Boolean>(BOOLEAN_PRIMITIVE_READER);
    public static final ResultSetReader<Date> DATE_SQL_READER = ResultSetReader.ofMethodReference(ResultSet::getDate);
    public static final ResultSetReader<Timestamp> TIMESTAMP_READER = ResultSetReader.ofMethodReference(ResultSet::getTimestamp);
    public static final ResultSetReader<String> STRING_READER = ResultSetReader.ofMethodReference(ResultSet::getString);
    public static final ResultSetReader<InputStream> BINARYSTREAM_READER = ResultSetReader.ofMethodReference(ResultSet::getBinaryStream);
    public static final ResultSetReader<Blob> BLOB_READER = ResultSetReader.ofMethodReference(ResultSet::getBlob);
    public static final NullAwareResultSetReader<java.util.Date> DATE_READER = new NullAwareResultSetReader<java.util.Date>(new DateBinder());
    public static final NullAwareResultSetReader<LocalDate> LOCALDATE_READER = new NullAwareResultSetReader<LocalDate>(new LocalDateBinder());
    public static final NullAwareResultSetReader<LocalDateTime> LOCALDATETIME_READER = new NullAwareResultSetReader<LocalDateTime>(new LocalDateTimeBinder());
    public static final ResultSetReader<Object> OBJECT_READER = ResultSetReader.ofMethodReference(ResultSet::getObject);
    public static final NullAwareResultSetReader<UUID> UUID_READER = new NullAwareResultSetReader<UUID>(new UUIDParameterBinder());
    public static final NullAwareResultSetReader<Path> PATH_READER = new NullAwareResultSetReader<Path>(new PathBinder());
    public static final ResultSetReader<Number> NUMBER_READER = ResultSetReader.ofMethodReference(ResultSet::getDouble);

    private DefaultResultSetReaders() {
    }
}

