/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.codefilarete.stalactite.sql.ddl.FixedPoint;
import org.codefilarete.stalactite.sql.ddl.Length;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.collection.Iterables;

public class JavaTypeToSqlTypeMapping {
    private final Map<Class, SQLTypeHolder> javaTypeToSQLType = new HashMap<Class, SQLTypeHolder>(50);

    public void put(Class clazz, String sqlType) {
        this.put(clazz, sqlType, null);
    }

    public void put(Class clazz, String sqlType, Size size) {
        this.javaTypeToSQLType.computeIfAbsent(clazz, k -> new SQLTypeHolder()).setType(sqlType, size);
    }

    public JavaTypeToSqlTypeMapping with(Class clazz, String sqlType) {
        this.put(clazz, sqlType);
        return this;
    }

    public JavaTypeToSqlTypeMapping with(Class clazz, Size size, String sqlType) {
        this.put(clazz, sqlType, size);
        return this;
    }

    public String getTypeName(Class javaType) {
        return this.getTypeName(javaType, null);
    }

    public String getTypeName(Class javaType, @javax.annotation.Nullable Size size) {
        SQLTypeHolder type = this.javaTypeToSQLType.get(javaType);
        if (type == null) {
            if (javaType.isEnum()) {
                type = this.javaTypeToSQLType.get(Enum.class);
            } else {
                InterfaceIterator interfaceIterator = new InterfaceIterator(javaType);
                Stream<SQLTypeHolder> stream = Iterables.stream((Iterator)interfaceIterator).map(this.javaTypeToSQLType::get);
                type = stream.filter(Objects::nonNull).findFirst().orElse(null);
            }
        }
        return (String)Nullable.nullable((Object)type).map(dataType -> dataType.getType(size)).getOr((Object)null);
    }

    private static class SQLTypeHolder {
        private final SortedMap<Size, String> availableSizes = new TreeMap(Comparator.nullsLast((size1, size2) -> {
            if (size1 == size2) {
                return 0;
            }
            if (size1 == null) {
                return -1;
            }
            if (size2 == null) {
                return 1;
            }
            if (size1 instanceof Length && size2 instanceof Length) {
                return Integer.compare(((Length)size1).getValue(), ((Length)size2).getValue());
            }
            if (size1 instanceof FixedPoint && size2 instanceof FixedPoint) {
                return -1;
            }
            return size1.getClass().getName().compareTo(size2.getClass().getName());
        }));

        private SQLTypeHolder() {
        }

        public String getType(@javax.annotation.Nullable Size size) {
            if (size == null) {
                return this.getTypeForLength(null);
            }
            return this.getTypeForLength(size);
        }

        public void setType(String sqlTypeName, @javax.annotation.Nullable Size size) {
            this.availableSizes.put(size, sqlTypeName);
        }

        private String getTypeForLength(@javax.annotation.Nullable Size size) {
            String typeName;
            if (size == null && this.availableSizes.size() == 1) {
                Map.Entry lonelyEntry = Iterables.first(this.availableSizes);
                typeName = (String)lonelyEntry.getValue();
                size = (Size)lonelyEntry.getKey();
            } else {
                SortedMap<Size, String> typeNames = this.availableSizes.tailMap(size);
                typeName = (String)Iterables.firstValue(typeNames);
            }
            if (typeName != null) {
                if (size instanceof Length) {
                    typeName = typeName.replace("$l", String.valueOf(((Length)size).getValue()));
                } else if (size instanceof FixedPoint) {
                    typeName = typeName.replace("$p", String.valueOf(((FixedPoint)size).getPrecision()));
                    typeName = typeName.replace("$s", String.valueOf(((FixedPoint)size).getScale()));
                }
            }
            return typeName;
        }
    }
}

