/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.sqlite.statement.binder;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.sqlite.statement.binder.SQLiteParameterBinderRegistry;
import org.codefilarete.stalactite.sql.sqlite.statement.binder.SQLiteTypeMapping;
import org.codefilarete.stalactite.sql.sqlite.test.SQLiteInMemoryDataSource;
import org.codefilarete.stalactite.sql.statement.binder.AbstractParameterBindersITTest;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SQLiteParameterBindersTest
extends AbstractParameterBindersITTest {
    public DataSource giveDataSource() {
        return new SQLiteInMemoryDataSource();
    }

    @BeforeEach
    protected void createParameterBinderRegistry() {
        this.parameterBinderRegistry = new SQLiteParameterBinderRegistry();
    }

    @BeforeEach
    protected void createJavaTypeToSqlTypeMapping() {
        this.javaTypeToSqlTypeMapping = new SQLiteTypeMapping();
    }

    @Test
    protected void localDateTimeBinder() throws SQLException {
        LocalDateTime initialTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123456789);
        LocalDateTime comparisonTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123000000);
        Set databaseContent = this.insertAndSelect(LocalDateTime.class, Arrays.asSet((Object[])new LocalDateTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalDateTime[]{null, comparisonTime}));
    }

    @Test
    protected void localTimeBinder() throws SQLException {
        LocalTime initialTime = LocalTime.of(4, 23, 35, 123456789);
        LocalTime comparisonTime = LocalTime.of(4, 23, 35, 123000000);
        Set databaseContent = this.insertAndSelect(LocalTime.class, Arrays.asSet((Object[])new LocalTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalTime[]{null, comparisonTime}));
    }
}

