/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codefilarete.stalactite.sql.statement.SQLParameterParser;
import org.codefilarete.tool.Strings;

public class ExpandableSQL {
    private final Map<String, ExpandableParameter> expandableParameters;
    private final SQLParameterParser.ParsedSQL parsedSQL;
    private String preparedSQL;

    public static Map<String, Integer> sizes(Map<String, Object> values) {
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            toReturn.put(entry.getKey(), entry.getValue() instanceof Collection ? ((Collection)entry.getValue()).size() : 1);
        }
        return toReturn;
    }

    public ExpandableSQL(SQLParameterParser.ParsedSQL parsedSQL, Map<String, Integer> parameterValuesSize) {
        this.parsedSQL = parsedSQL;
        this.expandableParameters = new HashMap<String, ExpandableParameter>(this.parsedSQL.getSqlSnippets().size() / 2);
        this.convertParsedParametersToExpandableParameters(parameterValuesSize);
    }

    private void convertParsedParametersToExpandableParameters(Map<String, Integer> parameterValuesSize) {
        StringBuilder preparedSQLBuilder = new StringBuilder();
        int markIndex = 1;
        for (Object sqlSnippet : this.parsedSQL.getSqlSnippets()) {
            if (sqlSnippet instanceof SQLParameterParser.Parameter) {
                String parameterName = ((SQLParameterParser.Parameter)sqlSnippet).getName();
                Integer valueSize = parameterValuesSize.get(parameterName);
                if (valueSize == null) {
                    throw new IllegalArgumentException("Size is not given for parameter " + parameterName + " hence expansion is not possible");
                }
                this.buildParameter(parameterName, valueSize, markIndex, preparedSQLBuilder);
                markIndex += valueSize.intValue();
                continue;
            }
            preparedSQLBuilder.append(sqlSnippet);
        }
        this.preparedSQL = preparedSQLBuilder.toString();
    }

    private void buildParameter(String parameterName, int valueSize, int firstIndex, StringBuilder preparedSQLBuilder) {
        ExpandableParameter expandableParameter = this.expandableParameters.get(parameterName);
        if (expandableParameter == null) {
            expandableParameter = new ExpandableParameter(parameterName, valueSize);
            this.expandableParameters.put(parameterName, expandableParameter);
        }
        expandableParameter.buildMarkIndexes(firstIndex);
        expandableParameter.catParameterMarks(preparedSQLBuilder);
    }

    public Map<String, ExpandableParameter> getExpandableParameters() {
        return this.expandableParameters;
    }

    public String getPreparedSQL() {
        return this.preparedSQL;
    }

    public static class ExpandableParameter {
        public static final String SQL_PARAMETER_MARK = "?";
        public static final String SQL_PARAMETER_SEPARATOR = ", ";
        public static final String SQL_PARAMETER_MARK_1 = "?, ";
        public static final String SQL_PARAMETER_MARK_10 = "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ";
        public static final String SQL_PARAMETER_MARK_100 = "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ";
        private final String parameterName;
        private final int markCount;
        private int[] indexes;

        private ExpandableParameter(String parameterName, int markCount) {
            this.parameterName = parameterName;
            this.markCount = markCount;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public int[] getMarkIndexes() {
            return this.indexes;
        }

        private void buildMarkIndexes(int startIndex) {
            int offset;
            if (this.indexes == null) {
                offset = 0;
                this.indexes = new int[this.markCount];
            } else {
                offset = this.indexes.length;
                int[] newIndexes = new int[offset + this.markCount];
                System.arraycopy(this.indexes, 0, newIndexes, 0, offset);
                this.indexes = newIndexes;
            }
            for (int i = 0; i < this.markCount; ++i) {
                this.indexes[i + offset] = startIndex++;
            }
        }

        private StringBuilder catParameterMarks(StringBuilder stringBuilder) {
            if (this.markCount > 1) {
                return this.expandParameters(stringBuilder);
            }
            return stringBuilder.append(SQL_PARAMETER_MARK);
        }

        protected StringBuilder expandParameters(StringBuilder stringBuilder) {
            StringBuilder sqlParameters = Strings.repeat((StringBuilder)stringBuilder, (int)this.markCount, (CharSequence)SQL_PARAMETER_MARK_1, (CharSequence[])new CharSequence[]{SQL_PARAMETER_MARK_100, SQL_PARAMETER_MARK_10});
            sqlParameters.setLength(sqlParameters.length() - 2);
            return sqlParameters;
        }
    }
}

