/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Reflections;

public abstract class AbstractTransformer<C>
implements RowTransformer<C> {
    protected final Function<Function<Column<?, ?>, Object>, C> beanFactory;
    private final ColumnedRow columnedRow;
    private final Collection<RowTransformer.TransformerListener<C>> rowTransformerListeners = new ArrayList<RowTransformer.TransformerListener<C>>();

    public AbstractTransformer(Class<C> clazz) {
        this(row -> Reflections.newInstance((Class)clazz), new ColumnedRow());
    }

    public AbstractTransformer(Function<? extends Function<Column<?, ?>, Object>, C> beanFactory, ColumnedRow columnedRow) {
        this(beanFactory, columnedRow, Collections.emptyList());
    }

    protected AbstractTransformer(Function<? extends Function<Column<?, ?>, Object>, C> beanFactory, ColumnedRow columnedRow, Collection<RowTransformer.TransformerListener<C>> rowTransformerListeners) {
        this.beanFactory = beanFactory;
        this.columnedRow = columnedRow;
        this.rowTransformerListeners.addAll(rowTransformerListeners);
    }

    public ColumnedRow getColumnedRow() {
        return this.columnedRow;
    }

    public Collection<RowTransformer.TransformerListener<C>> getRowTransformerListeners() {
        return this.rowTransformerListeners;
    }

    @Override
    public void addTransformerListener(RowTransformer.TransformerListener<? extends C> listener) {
        this.rowTransformerListeners.add(listener);
    }

    @Override
    public C transform(Row row) {
        C bean = this.newBeanInstance(row);
        this.applyRowToBean(row, bean);
        this.rowTransformerListeners.forEach(listener -> listener.onTransform(bean, c -> this.getColumnedRow().getValue(c, row)));
        return bean;
    }

    protected C newBeanInstance(Row row) {
        return this.beanFactory.apply(c -> this.columnedRow.getValue(c, row));
    }
}

