/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.mapping.AbstractTransformer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EmbeddedBeanMapping;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.ToBeanRowTransformer;
import org.codefilarete.stalactite.mapping.id.assembly.SimpleIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Converter;

public class ClassMapping<C, I, T extends Table<T>>
implements EntityMapping<C, I, T> {
    private final EmbeddedClassMapping<C, T> mainMapping;
    private final Set<Column<T, Object>> insertableColumns = new KeepOrderSet();
    private final Set<Column<T, Object>> updatableColumns = new KeepOrderSet();
    private final Set<Column<T, Object>> selectableColumns = new KeepOrderSet();
    private final Map<ReversibleAccessor<C, Object>, EmbeddedBeanMapping<Object, T>> embeddedMappings = new KeepOrderMap();
    private final IdMapping<C, I> idMapping;
    private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> versioningMapping = new KeepOrderMap();
    private final boolean identifierSetByBeanFactory;

    public ClassMapping(Class<C> classToPersist, T targetTable, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> propertyToColumn, ReversibleAccessor<C, I> identifierProperty, IdentifierInsertionManager<C, I> identifierInsertionManager) {
        if (identifierProperty == null) {
            throw new UnsupportedOperationException("No identifier property for " + Reflections.toString(classToPersist));
        }
        if (((Table)targetTable).getPrimaryKey() == null) {
            throw new UnsupportedOperationException("No primary key column defined for " + ((Table)targetTable).getAbsoluteName());
        }
        this.mainMapping = new EmbeddedClassMapping<C, T>(classToPersist, targetTable, propertyToColumn);
        Column<T, Object> identifierColumn = propertyToColumn.get(identifierProperty);
        if (identifierColumn == null) {
            throw new IllegalArgumentException("Bean identifier '" + AccessorDefinition.toString(identifierProperty) + "' must have its matching column in the mapping");
        }
        if (!identifierColumn.isPrimaryKey()) {
            throw new UnsupportedOperationException("Accessor '" + AccessorDefinition.toString(identifierProperty) + "' is declared as identifier but mapped column " + identifierColumn + " is not the primary key of table");
        }
        this.idMapping = new SimpleIdMapping<C, I>(identifierProperty, identifierInsertionManager, new SimpleIdentifierAssembler<Object, T>(identifierColumn));
        this.identifierSetByBeanFactory = false;
        this.fillInsertableColumns();
        this.fillUpdatableColumns();
        this.fillSelectableColumns();
    }

    public ClassMapping(Class<C> classToPersist, T targetTable, Map<? extends ReversibleAccessor<C, Object>, Column<T, Object>> propertyToColumn, IdMapping<C, I> idMapping) {
        this(new EmbeddedClassMapping<C, T>(classToPersist, targetTable, propertyToColumn), idMapping, false);
    }

    public ClassMapping(Class<C> classToPersist, T targetTable, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> propertyToColumn, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> readonlyColumns, IdMapping<C, I> idMapping, Function<Function<Column<?, ?>, Object>, C> entityFactory, boolean identifierSetByBeanFactory) {
        this(new EmbeddedClassMapping<C, T>(classToPersist, targetTable, propertyToColumn, readonlyColumns, entityFactory), idMapping, identifierSetByBeanFactory);
    }

    private ClassMapping(EmbeddedClassMapping<C, T> mainMapping, IdMapping<C, I> idMapping, boolean identifierSetByBeanFactory) {
        if (idMapping.getIdAccessor() == null) {
            throw new UnsupportedOperationException("No identifier property defined for " + Reflections.toString(mainMapping.getClassToPersist()));
        }
        if (((Table)mainMapping.getTargetTable()).getPrimaryKey() == null) {
            throw new UnsupportedOperationException("No primary key column defined for " + ((Table)mainMapping.getTargetTable()).getAbsoluteName());
        }
        this.mainMapping = mainMapping;
        this.idMapping = idMapping;
        this.identifierSetByBeanFactory = identifierSetByBeanFactory;
        this.fillInsertableColumns();
        this.fillUpdatableColumns();
        this.fillSelectableColumns();
    }

    @Override
    public Class<C> getClassToPersist() {
        return this.mainMapping.getClassToPersist();
    }

    @Override
    public T getTargetTable() {
        return this.mainMapping.getTargetTable();
    }

    public EmbeddedClassMapping<C, T> getMainMapping() {
        return this.mainMapping;
    }

    @Override
    public Map<ReversibleAccessor<C, Object>, EmbeddedBeanMapping<Object, T>> getEmbeddedBeanStrategies() {
        return this.embeddedMappings;
    }

    @Override
    public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getPropertyToColumn() {
        KeepOrderMap result = new KeepOrderMap();
        result.putAll(this.getMainMapping().getPropertyToColumn());
        for (Map.Entry<ReversibleAccessor<C, Object>, EmbeddedBeanMapping<Object, T>> value : this.embeddedMappings.entrySet()) {
            value.getValue().getPropertyToColumn().forEach((arg_0, arg_1) -> ClassMapping.lambda$getPropertyToColumn$0((Map)result, value, arg_0, arg_1));
        }
        return result;
    }

    @Override
    public Map<ReversibleAccessor<C, Object>, Column<T, Object>> getReadonlyPropertyToColumn() {
        KeepOrderMap result = new KeepOrderMap();
        result.putAll(this.getMainMapping().getReadonlyPropertyToColumn());
        for (Map.Entry<ReversibleAccessor<C, Object>, EmbeddedBeanMapping<Object, T>> value : this.embeddedMappings.entrySet()) {
            value.getValue().getReadonlyPropertyToColumn().forEach((arg_0, arg_1) -> ClassMapping.lambda$getReadonlyPropertyToColumn$1((Map)result, value, arg_0, arg_1));
        }
        return result;
    }

    @Override
    public ValueAccessPointMap<C, Converter<Object, Object>> getReadConverters() {
        return this.mainMapping.getReadConverters();
    }

    @Override
    public ValueAccessPointMap<C, Converter<Object, Object>> getWriteConverters() {
        return this.mainMapping.getWriteConverters();
    }

    @Override
    public Set<Column<T, Object>> getInsertableColumns() {
        return Collections.unmodifiableSet(this.insertableColumns);
    }

    @Override
    public Set<Column<T, Object>> getUpdatableColumns() {
        return Collections.unmodifiableSet(this.updatableColumns);
    }

    @Override
    public Set<Column<T, Object>> getSelectableColumns() {
        return Collections.unmodifiableSet(this.selectableColumns);
    }

    @Override
    public IdMapping<C, I> getIdMapping() {
        return this.idMapping;
    }

    public Collection<Mapping.ShadowColumnValueProvider<C, T>> getShadowColumnsForInsert() {
        return Collections.unmodifiableCollection(this.mainMapping.getShadowColumnsForInsert());
    }

    public Collection<Mapping.ShadowColumnValueProvider<C, T>> getShadowColumnsForUpdate() {
        return Collections.unmodifiableCollection(this.mainMapping.getShadowColumnsForUpdate());
    }

    public void addShadowColumns(ClassMapping<C, I, T> classMappingStrategy) {
        classMappingStrategy.mainMapping.getShadowColumnsForInsert().forEach(this::addShadowColumnInsert);
        classMappingStrategy.mainMapping.getShadowColumnsForUpdate().forEach(this::addShadowColumnUpdate);
    }

    public void addVersionedColumn(ReversibleAccessor propertyAccessor, Column<T, Object> column) {
        this.versioningMapping.put(propertyAccessor, column);
    }

    @Override
    public void addShadowColumnInsert(Mapping.ShadowColumnValueProvider<C, T> valueProvider) {
        this.mainMapping.addShadowColumnInsert(valueProvider);
        this.insertableColumns.addAll(valueProvider.getColumns());
    }

    @Override
    public void addShadowColumnUpdate(Mapping.ShadowColumnValueProvider<C, T> valueProvider) {
        this.mainMapping.addShadowColumnUpdate(valueProvider);
        this.updatableColumns.addAll(valueProvider.getColumns());
    }

    @Override
    public void addPropertySetByConstructor(ValueAccessPoint<C> accessor) {
        this.mainMapping.addPropertySetByConstructor(accessor);
    }

    @Override
    public <O> void addShadowColumnSelect(Column<T, O> column) {
        this.mainMapping.addShadowColumnSelect(column);
        this.fillSelectableColumns();
    }

    public <O> void put(ReversibleAccessor<C, O> property, EmbeddedBeanMapping<O, T> mappingStrategy) {
        this.embeddedMappings.put(property, mappingStrategy);
        this.addInsertableColumns(mappingStrategy);
        this.addUpdatableColumns(mappingStrategy);
        this.addSelectableColumns(mappingStrategy);
    }

    @Override
    public Map<Column<T, Object>, Object> getInsertValues(C c) {
        Map insertValues = this.mainMapping.getInsertValues(c);
        this.getVersionedKeyValues(c).entrySet().stream().filter(entry -> !((Column)entry.getKey()).isAutoGenerated()).forEach(entry -> insertValues.put((Column)entry.getKey(), entry.getValue()));
        for (Map.Entry<ReversibleAccessor<C, Object>, EmbeddedBeanMapping<Object, T>> fieldStrategyEntry : this.embeddedMappings.entrySet()) {
            Object fieldValue = fieldStrategyEntry.getKey().get(c);
            Map fieldInsertValues = fieldStrategyEntry.getValue().getInsertValues(fieldValue);
            insertValues.putAll(fieldInsertValues);
        }
        return insertValues;
    }

    @Override
    public Map<Mapping.UpwhereColumn<T>, Object> getUpdateValues(C modified, C unmodified, boolean allColumns) {
        Map<Mapping.UpwhereColumn<T>, Object> toReturn;
        if (modified != null && unmodified != null && !this.getId(modified).equals(this.getId(unmodified))) {
            toReturn = new HashMap<Mapping.UpwhereColumn<T>, Object>();
        } else {
            toReturn = this.mainMapping.getUpdateValues(modified, unmodified, allColumns);
            for (Map.Entry<ReversibleAccessor<C, Object>, EmbeddedBeanMapping<Object, T>> fieldStrategyEntry : this.embeddedMappings.entrySet()) {
                ReversibleAccessor<C, Object> reversibleAccessor = fieldStrategyEntry.getKey();
                Object modifiedValue = reversibleAccessor.get(modified);
                Object unmodifiedValue = unmodified == null ? null : reversibleAccessor.get(unmodified);
                Map fieldUpdateValues = fieldStrategyEntry.getValue().getUpdateValues(modifiedValue, unmodifiedValue, allColumns);
                for (Map.Entry fieldUpdateValue : fieldUpdateValues.entrySet()) {
                    toReturn.put(fieldUpdateValue.getKey(), fieldUpdateValue.getValue());
                }
            }
            if (!toReturn.isEmpty()) {
                if (allColumns) {
                    HashSet<Column<T, Object>> missingColumns = new HashSet<Column<T, Object>>(this.getUpdatableColumns());
                    missingColumns.removeAll(Mapping.UpwhereColumn.getUpdateColumns(toReturn).keySet());
                    for (Column column : missingColumns) {
                        toReturn.put(new Mapping.UpwhereColumn(column, true), null);
                    }
                }
                C whereSource = unmodified != null ? unmodified : modified;
                for (Map.Entry<Column<T, Object>, Object> entry : this.getVersionedKeyValues(whereSource).entrySet()) {
                    toReturn.put(new Mapping.UpwhereColumn<T>(entry.getKey(), false), entry.getValue());
                }
            }
        }
        return toReturn;
    }

    private void fillInsertableColumns() {
        this.insertableColumns.clear();
        this.addInsertableColumns(this.mainMapping);
        this.insertableColumns.addAll(this.getIdMapping().getIdentifierAssembler().getColumns());
        this.embeddedMappings.values().forEach(this::addInsertableColumns);
        this.insertableColumns.addAll(this.versioningMapping.values());
    }

    private void addInsertableColumns(EmbeddedBeanMapping<?, T> embeddedBeanMapping) {
        this.insertableColumns.addAll(embeddedBeanMapping.getWritableColumns());
    }

    private void fillUpdatableColumns() {
        this.updatableColumns.clear();
        this.addUpdatableColumns(this.mainMapping);
        this.embeddedMappings.values().forEach(this::addUpdatableColumns);
        this.updatableColumns.addAll(this.versioningMapping.values());
        this.updatableColumns.removeAll((Collection<?>)((Table)this.getTargetTable()).getPrimaryKey().getColumns());
        this.updatableColumns.removeIf(Column::isAutoGenerated);
    }

    private void addUpdatableColumns(EmbeddedBeanMapping<?, T> embeddedBeanMapping) {
        this.updatableColumns.addAll(embeddedBeanMapping.getWritableColumns());
    }

    private void fillSelectableColumns() {
        this.selectableColumns.clear();
        this.addSelectableColumns(this.mainMapping);
        this.selectableColumns.addAll(this.getIdMapping().getIdentifierAssembler().getColumns());
        this.selectableColumns.addAll(this.versioningMapping.values());
        this.embeddedMappings.values().forEach(this::addSelectableColumns);
    }

    private void addSelectableColumns(EmbeddedBeanMapping<?, T> embeddedBeanMapping) {
        this.selectableColumns.addAll(embeddedBeanMapping.getColumns());
    }

    @Override
    public Map<Column<T, Object>, Object> getVersionedKeyValues(C c) {
        HashMap<Column<T, Object>, Object> toReturn = new HashMap<Column<T, Object>, Object>();
        toReturn.putAll(this.getIdMapping().getIdentifierAssembler().getColumnValues(this.getId(c)));
        toReturn.putAll(this.getVersionedColumnsValues(c));
        return toReturn;
    }

    private Map<Column<T, Object>, Object> getVersionedColumnsValues(C c) {
        HashMap<Column<T, Object>, Object> toReturn = new HashMap<Column<T, Object>, Object>();
        for (Map.Entry<ReversibleAccessor<C, Object>, Column<T, Object>> columnEntry : this.versioningMapping.entrySet()) {
            toReturn.put(columnEntry.getValue(), columnEntry.getKey().get(c));
        }
        return toReturn;
    }

    @Override
    public Iterable<Column<T, Object>> getVersionedKeys() {
        HashSet<Column<T, Object>> columns = new HashSet<Column<T, Object>>(this.versioningMapping.values());
        columns.addAll((Collection<Column<T, Object>>)((Table)this.getTargetTable()).getPrimaryKey().getColumns());
        return Collections.unmodifiableSet(columns);
    }

    @Override
    public I getId(C c) {
        return this.getIdMapping().getIdAccessor().getId(c);
    }

    @Override
    public void setId(C c, I identifier) {
        this.getIdMapping().getIdAccessor().setId(c, identifier);
    }

    @Override
    public boolean isNew(C c) {
        return this.getIdMapping().isNew(c);
    }

    @Override
    public C transform(Row row) {
        Object toReturn = this.getRowTransformer().transform(row);
        ColumnedRow columnedRow = new ColumnedRow();
        if (!this.identifierSetByBeanFactory) {
            this.setId(toReturn, this.getIdMapping().getIdentifierAssembler().assemble(row, columnedRow));
        }
        for (Map.Entry<ReversibleAccessor<C, Object>, EmbeddedBeanMapping<Object, T>> mappingStrategyEntry : this.embeddedMappings.entrySet()) {
            mappingStrategyEntry.getKey().toMutator().set(toReturn, mappingStrategyEntry.getValue().transform(row));
        }
        return toReturn;
    }

    @Override
    public RowTransformer<C> copyTransformerWithAliases(ColumnedRow columnedRow) {
        AbstractTransformer mainRowTransformer = this.getRowTransformer().copyWithAliases(columnedRow);
        return new RowTransformer<C>((ToBeanRowTransformer)mainRowTransformer, columnedRow){
            final /* synthetic */ ToBeanRowTransformer val$mainRowTransformer;
            final /* synthetic */ ColumnedRow val$columnedRow;
            {
                this.val$mainRowTransformer = toBeanRowTransformer;
                this.val$columnedRow = columnedRow;
            }

            @Override
            public C transform(Row row) {
                Object result = this.val$mainRowTransformer.transform(row);
                if (!ClassMapping.this.identifierSetByBeanFactory) {
                    ClassMapping.this.setId(result, ClassMapping.this.getIdMapping().getIdentifierAssembler().assemble(row, this.val$columnedRow));
                }
                return result;
            }

            @Override
            public void applyRowToBean(Row row, C bean) {
                this.val$mainRowTransformer.applyRowToBean(row, bean);
            }

            @Override
            public AbstractTransformer<C> copyWithAliases(ColumnedRow columnedRow) {
                throw new IllegalStateException("copyWithAliases(..) is not expected to be called twice");
            }

            @Override
            public void addTransformerListener(RowTransformer.TransformerListener<? extends C> listener) {
                this.val$mainRowTransformer.addTransformerListener(listener);
            }
        };
    }

    public ToBeanRowTransformer<C> getRowTransformer() {
        return this.mainMapping.getRowTransformer();
    }

    @Override
    public void addTransformerListener(RowTransformer.TransformerListener<C> listener) {
        this.getRowTransformer().addTransformerListener(listener);
    }

    private static /* synthetic */ void lambda$getReadonlyPropertyToColumn$1(Map result, Map.Entry value, ReversibleAccessor k, Column v) {
        if (!(k instanceof ReversibleMutator)) {
            throw new UnsupportedOperationException("Given accessor " + AccessorDefinition.toString((ValueAccessPoint)k) + " can't be converted to an Accessor to make it last element of Accessor chain");
        }
        Accessor kAsAccessor = ((ReversibleMutator)k).toAccessor();
        result.put(new AccessorChain(new Accessor[]{(Accessor)value.getKey(), kAsAccessor}).toMutator(), v);
    }

    private static /* synthetic */ void lambda$getPropertyToColumn$0(Map result, Map.Entry value, ReversibleAccessor k, Column v) {
        result.put(new AccessorChain(new Accessor[]{(Accessor)value.getKey(), k}), v);
    }
}

