/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.nativ;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.spring.repository.query.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteProjection;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;

public class TupleNativeQueryExecutor
extends AbstractQueryExecutor<List<Map<String, Object>>, Map<String, Object>> {
    private final IdentityHashMap<JoinLink<?, ?>, String> expectedAliasesInNativeQuery;
    private final IdentityHashMap<JoinLink<?, ?>, AccessorChain<?, ?>> columnToProperties;
    private final Supplier<Limit> limitSupplier;
    private final String sql;
    private final ConnectionProvider connectionProvider;

    public TupleNativeQueryExecutor(StalactiteQueryMethod method, String sql, Dialect dialect, ConnectionProvider connectionProvider, IdentityHashMap<? extends JoinLink<?, ?>, String> expectedAliasesInNativeQuery, IdentityHashMap<? extends JoinLink<?, ?>, ? extends AccessorChain<?, ?>> columnToProperties, Supplier<Limit> limitSupplier) {
        super(method, dialect);
        this.sql = sql;
        this.connectionProvider = connectionProvider;
        this.expectedAliasesInNativeQuery = expectedAliasesInNativeQuery;
        this.columnToProperties = columnToProperties;
        this.limitSupplier = limitSupplier;
    }

    @Override
    public Supplier<List<Map<String, Object>>> buildQueryExecutor(Object[] parameters) {
        return () -> {
            Limit limit;
            StalactiteQueryMethodInvocationParameters accessor = new StalactiteQueryMethodInvocationParameters(this.method, parameters);
            Map<String, Object> values = accessor.getNamedValues();
            Map<String, PreparedStatementWriter<?>> parameterBinders = accessor.bindParameters(this.dialect);
            String sqlToExecute = this.sql;
            if (accessor.getParameters().hasPageableParameter() && (limit = this.limitSupplier.get()) != null) {
                sqlToExecute = sqlToExecute + " limit :limit";
                values.put("limit", limit.getCount());
                parameterBinders.put("limit", (PreparedStatementWriter<?>)DefaultParameterBinders.INTEGER_BINDER);
                if (limit.getOffset() != null) {
                    sqlToExecute = sqlToExecute + " offset :offset";
                    values.put("offset", limit.getOffset());
                    parameterBinders.put("offset", (PreparedStatementWriter<?>)DefaultParameterBinders.INTEGER_BINDER);
                }
            }
            StringParamedSQL statement = new StringParamedSQL(sqlToExecute, parameterBinders);
            statement.setValues(values);
            try (ReadOperation readOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)statement, this.connectionProvider);){
                readOperation.setValues(statement.getValues());
                ResultSet resultSet = readOperation.execute();
                HashMap columnReaders = new HashMap();
                this.expectedAliasesInNativeQuery.forEach((selectable, alias) -> {
                    if (selectable instanceof Column) {
                        columnReaders.put(selectable, this.dialect.getColumnBinderRegistry().getBinder((Object)((Column)selectable)));
                    } else {
                        columnReaders.put(selectable, this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
                    }
                });
                ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, columnReaders, this.expectedAliasesInNativeQuery);
                Accumulator<ColumnedRow, List<Map<String, Object>>, List<Map<String, Object>>> accumulator = new Accumulator<ColumnedRow, List<Map<String, Object>>, List<Map<String, Object>>>(){

                    public Supplier<List<Map<String, Object>>> supplier() {
                        return LinkedList::new;
                    }

                    public BiConsumer<List<Map<String, Object>>, ColumnedRow> aggregator() {
                        return (finalResult, databaseRowDataProvider) -> {
                            HashMap<String, Object> row = new HashMap<String, Object>();
                            finalResult.add(row);
                            for (Map.Entry entry : TupleNativeQueryExecutor.this.columnToProperties.entrySet()) {
                                PartTreeStalactiteProjection.buildHierarchicMap((AccessorChain)entry.getValue(), databaseRowDataProvider.get((Selectable)entry.getKey()), row);
                            }
                        };
                    }

                    public Function<List<Map<String, Object>>, List<Map<String, Object>>> finisher() {
                        return Function.identity();
                    }
                };
                List list = (List)accumulator.collect(() -> rowIterator);
                return list;
            }
            catch (RuntimeException e) {
                throw new SQLExecutionException(statement.getSQL(), (Throwable)e);
            }
        };
    }
}

