/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.bean;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.spring.repository.StalactiteRepository;
import org.codefilarete.stalactite.spring.repository.query.BeanQuery;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.bean.BeanRepositoryQuery;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Predicates;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class BeanQueryLookupStrategy<C>
implements QueryLookupStrategy {
    private final ListableBeanFactory beanFactory;
    private final Dialect dialect;

    public BeanQueryLookupStrategy(ListableBeanFactory beanFactory, Dialect dialect) {
        this.beanFactory = beanFactory;
        this.dialect = dialect;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        BeanQueryMetadata beanQueryMetadata = this.findBeanQueryMetadata(method);
        if (beanQueryMetadata != null) {
            StalactiteQueryMethod queryMethod = new StalactiteQueryMethod(method, metadata, factory);
            return new BeanRepositoryQuery(queryMethod, beanQueryMetadata.getBean(), beanQueryMetadata.getCounterBean(), this.dialect);
        }
        return null;
    }

    @javax.annotation.Nullable
    @VisibleForTesting
    BeanQueryMetadata findBeanQueryMetadata(Method method) {
        Set<BeanQueryMetadata> queryMetadataSet = this.collectBeanQueryMetadata(method);
        switch (queryMetadataSet.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (BeanQueryMetadata)Iterables.first(queryMetadataSet);
            }
        }
        Set defaultBeans = queryMetadataSet.stream().filter(BeanQueryMetadata::isDefault).collect(Collectors.toSet());
        Set dedicatedBeans = queryMetadataSet.stream().filter(metadata -> metadata.isFor(method.getDeclaringClass())).collect(Collectors.toSet());
        if (dedicatedBeans.size() == 1) {
            return (BeanQueryMetadata)Iterables.first(dedicatedBeans);
        }
        if (defaultBeans.size() == 1) {
            return (BeanQueryMetadata)Iterables.first(defaultBeans);
        }
        throw new UnsupportedOperationException("Multiple beans found matching method " + Reflections.toString((Method)method) + ": " + Iterables.collect(queryMetadataSet, metadata -> ((BeanQueryMetadata)metadata).beanName, HashSet::new) + ", but none for repository type " + Reflections.toString(method.getDeclaringClass()) + ": " + Iterables.collect(queryMetadataSet, metadata -> Reflections.toString(((BeanQueryMetadata)metadata).queryAnnotation.repositoryClass()), ArrayList::new));
    }

    private Set<BeanQueryMetadata> collectBeanQueryMetadata(Method method) {
        Map beansWithAnnotation = this.beanFactory.getBeansWithAnnotation(BeanQuery.class);
        Set<BeanQueryMetadata> queryMetadataSet = beansWithAnnotation.entrySet().stream().map(entry -> {
            BeanQuery beanQueryAnnotation = (BeanQuery)this.beanFactory.findAnnotationOnBean((String)entry.getKey(), BeanQuery.class);
            Nullable counterBean = Nullable.nullable((Object)beanQueryAnnotation).map(BeanQuery::counterBean).filter(Predicates.not(String::isEmpty)).map(counterBeanName -> (EntityPersister.ExecutableProjectionQuery)this.beanFactory.getBean(counterBeanName, EntityPersister.ExecutableProjectionQuery.class));
            return new BeanQueryMetadata((String)entry.getKey(), (EntityPersister.ExecutableEntityQuery)entry.getValue(), (EntityPersister.ExecutableProjectionQuery)counterBean.get(), beanQueryAnnotation);
        }).filter(metadata -> ((BeanQueryMetadata)metadata).beanName.equals(method.getName()) || Arrays.asList((Object[])((BeanQueryMetadata)metadata).queryAnnotation.name()).contains(method.getName()) || ((BeanQueryMetadata)metadata).queryAnnotation.method().equals(method.getName())).collect(Collectors.toSet());
        return queryMetadataSet;
    }

    @VisibleForTesting
    static class BeanQueryMetadata {
        private final String beanName;
        private final EntityPersister.ExecutableEntityQuery bean;
        private final EntityPersister.ExecutableProjectionQuery counterBean;
        private final BeanQuery queryAnnotation;

        private BeanQueryMetadata(String beanName, EntityPersister.ExecutableEntityQuery bean, EntityPersister.ExecutableProjectionQuery counterBean, BeanQuery queryAnnotation) {
            this.beanName = beanName;
            this.bean = bean;
            this.counterBean = counterBean;
            this.queryAnnotation = queryAnnotation;
        }

        public EntityPersister.ExecutableEntityQuery getBean() {
            return this.bean;
        }

        public EntityPersister.ExecutableProjectionQuery getCounterBean() {
            return this.counterBean;
        }

        boolean isDefault() {
            return this.isFor(StalactiteRepository.class);
        }

        boolean isFor(Class<? extends StalactiteRepository> repositoryClass) {
            return this.queryAnnotation.repositoryClass().equals(repositoryClass);
        }
    }
}

