/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.IdentityHashMap;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.query.AggregateAccessPointToColumnMapping;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;

public class ProjectionMappingFinder<C> {
    private final AggregateAccessPointToColumnMapping<C> aggregateColumnMapping;
    private final EntityProjectionIntrospector entityProjectionIntrospector;
    private final Class<C> aggregateType;

    public ProjectionMappingFinder(ProjectionFactory factory, AdvancedEntityPersister<C, ?> entityPersister) {
        EntityProjectionIntrospector.ProjectionPredicate isProjectionTest = (returnType, domainType) -> !returnType.isAssignableFrom(domainType);
        RelationalMappingContext mappingContext = new RelationalMappingContext();
        this.entityProjectionIntrospector = EntityProjectionIntrospector.create((ProjectionFactory)factory, (EntityProjectionIntrospector.ProjectionPredicate)isProjectionTest, (MappingContext)mappingContext);
        this.aggregateColumnMapping = entityPersister.getEntityFinder().newCriteriaSupport().getEntityCriteriaSupport().getAggregateColumnMapping();
        this.aggregateType = entityPersister.getClassToPersist();
    }

    public IdentityHashMap<JoinLink<?, ?>, AccessorChain<C, ?>> lookup(Class<?> projectionTypeToIntrospect) {
        IdentityHashMap result = new IdentityHashMap();
        EntityProjection projectionTypeIntrospection = this.entityProjectionIntrospector.introspect(projectionTypeToIntrospect, this.aggregateType);
        projectionTypeIntrospection.forEachRecursive(projectionProperty -> {
            AccessorChain<?, ?> accessorChain = this.convertToAccessorChain(projectionProperty.getPropertyPath());
            try {
                JoinLink selectable = this.aggregateColumnMapping.giveColumn(accessorChain.getAccessors());
                result.put(selectable, accessorChain);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        });
        return result;
    }

    private AccessorChain<?, ?> convertToAccessorChain(PropertyPath propertyPath2) {
        AccessorChain result = new AccessorChain();
        propertyPath2.forEach(propertyPath -> result.add((Accessor)Accessors.accessor((Class)propertyPath.getOwningType().getType(), (String)propertyPath.getSegment(), (Class)propertyPath.getType())));
        return result;
    }
}

