/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.Count;
import org.codefilarete.stalactite.spring.repository.query.AbstractDerivedQuery;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.trace.MutableLong;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeStalactiteCountProjection<C>
implements RepositoryQuery {
    private final Count count;
    private final QueryMethod method;
    private final Accumulator<Function<Selectable<Long>, Long>, MutableLong, Long> accumulator;
    private final DerivedQuery query;
    private final Consumer<Select> selectConsumer;

    public PartTreeStalactiteCountProjection(QueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree tree) {
        this.method = method;
        Set columns = entityPersister.getMapping().getIdMapping().getIdentifierAssembler().getColumns();
        this.count = Operators.count((Iterable)columns);
        if (tree.isDistinct()) {
            this.count.distinct();
        }
        this.selectConsumer = select -> {
            select.clear();
            select.add((Selectable)this.count, "row_count");
        };
        this.accumulator = new Accumulator<Function<Selectable<Long>, Long>, MutableLong, Long>(){

            public Supplier<MutableLong> supplier() {
                return MutableLong::new;
            }

            public BiConsumer<MutableLong, Function<Selectable<Long>, Long>> aggregator() {
                return (modifiableLong, selectableObjectFunction) -> {
                    Long countValue = (Long)selectableObjectFunction.apply(PartTreeStalactiteCountProjection.this.count);
                    modifiableLong.reset(countValue.longValue());
                };
            }

            public Function<MutableLong, Long> finisher() {
                return MutableLong::getValue;
            }
        };
        this.query = new DerivedQuery(entityPersister, tree);
    }

    public Long execute(Object[] parameters) {
        this.query.criteriaChain.consume(parameters);
        return (Long)this.query.executableProjectionQuery.wrapIntoExecutable().execute(this.accumulator);
    }

    public QueryMethod getQueryMethod() {
        return this.method;
    }

    class DerivedQuery
    extends AbstractDerivedQuery<C> {
        protected final ProjectionQueryCriteriaSupport<C, ?> executableProjectionQuery;
        private EntityCriteriaSupport<C> currentSupport;

        DerivedQuery(AdvancedEntityPersister<C, ?> entityPersister, PartTree tree) {
            this.executableProjectionQuery = entityPersister.newProjectionCriteriaSupport(PartTreeStalactiteCountProjection.this.selectConsumer);
            tree.forEach(this::append);
        }

        private void append(PartTree.OrPart part) {
            Iterator iterator;
            this.currentSupport = this.executableProjectionQuery.getEntityCriteriaSupport();
            boolean nested = false;
            if (part.stream().count() > 1L) {
                nested = true;
                this.currentSupport = this.currentSupport.beginNested();
            }
            if ((iterator = part.iterator()).hasNext()) {
                this.append((Part)iterator.next(), LogicalOperator.OR);
            }
            iterator.forEachRemaining(p -> this.append((Part)p, LogicalOperator.AND));
            if (nested) {
                this.currentSupport = this.currentSupport.endNested();
            }
        }

        private void append(Part part, LogicalOperator orOrAnd) {
            AccessorChain getter = this.convertToAccessorChain(part.getProperty());
            AbstractDerivedQuery.Criterion criterion = this.convertToCriterion(part.getType(), part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER);
            this.currentSupport.add(orOrAnd, getter.getAccessors(), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }
}

