/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.cascade;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.cascade.AbstractCascaderTest;
import org.codefilarete.stalactite.engine.cascade.AfterUpdateCollectionCascader;
import org.codefilarete.stalactite.engine.runtime.BeanPersister;
import org.codefilarete.stalactite.engine.runtime.UpdateExecutor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AfterUpdateCollectionCascaderTest
extends AbstractCascaderTest {
    @Test
    public <T extends Table<T>> void testAfterUpdate() {
        Table tataTable = new Table("Tata");
        Column primaryKey = tataTable.addColumn("id", Long.class).primaryKey();
        Column nameColumn = tataTable.addColumn("name", String.class);
        AccessorByField identifier = Accessors.accessorByField(AbstractCascaderTest.Tata.class, (String)"id");
        AccessorByField propName = Accessors.accessorByField(AbstractCascaderTest.Tata.class, (String)"name");
        Maps.ChainingMap mapping = Maps.asMap((Object)identifier, (Object)primaryKey).add((Object)propName, (Object)nameColumn);
        ClassMapping mappingStrategyMock = new ClassMapping(AbstractCascaderTest.Tata.class, tataTable, (Map)mapping, (ReversibleAccessor)identifier, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Long.class, c -> {}, c -> false));
        BeanPersister persisterStub = new BeanPersister<AbstractCascaderTest.Tata, Long, T>((EntityMapping)mappingStrategyMock, (Dialect)Mockito.mock(Dialect.class), (ConnectionConfiguration)Mockito.mock(ConnectionConfiguration.class)){

            protected UpdateExecutor<AbstractCascaderTest.Tata, Long, T> newUpdateExecutor(EntityMapping<AbstractCascaderTest.Tata, Long, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, WriteOperationFactory writeOperationFactory, int inOperatorMaxSize) {
                return new UpdateExecutor<AbstractCascaderTest.Tata, Long, T>(mappingStrategy, connectionConfiguration, dmlGenerator, new WriteOperationFactory(), inOperatorMaxSize){

                    public void update(Iterable<? extends Duo<AbstractCascaderTest.Tata, AbstractCascaderTest.Tata>> differencesIterable, boolean allColumnsStatement) {
                    }
                };
            }
        };
        final ArrayList actions = new ArrayList();
        final ArrayList triggeredTarget = new ArrayList();
        AfterUpdateCollectionCascader<AbstractCascaderTest.Toto, AbstractCascaderTest.Tata> testInstance = new AfterUpdateCollectionCascader<AbstractCascaderTest.Toto, AbstractCascaderTest.Tata>((EntityPersister)persisterStub){

            protected void postTargetUpdate(Iterable<? extends Duo<? extends AbstractCascaderTest.Tata, ? extends AbstractCascaderTest.Tata>> entities) {
                actions.add("postTargetUpdate");
                triggeredTarget.addAll(Iterables.collectToList(entities, Function.identity()));
            }

            protected Collection<Duo<AbstractCascaderTest.Tata, AbstractCascaderTest.Tata>> getTargets(AbstractCascaderTest.Toto modifiedTrigger, AbstractCascaderTest.Toto unmodifiedTrigger) {
                actions.add("getTargets");
                return Arrays.asList((Object[])new Duo[]{new Duo((Object)modifiedTrigger.tata, (Object)unmodifiedTrigger.tata)});
            }
        };
        int tataId = 42;
        AbstractCascaderTest.Toto triggeringInstance1 = new AbstractCascaderTest.Toto(new AbstractCascaderTest.Tata().setId(tataId));
        AbstractCascaderTest.Toto triggeringInstance1_modified = new AbstractCascaderTest.Toto(new AbstractCascaderTest.Tata().setId(tataId));
        AbstractCascaderTest.Toto triggeringInstance2 = new AbstractCascaderTest.Toto(new AbstractCascaderTest.Tata().setName("x").setId(tataId));
        AbstractCascaderTest.Toto triggeringInstance2_modified = new AbstractCascaderTest.Toto(new AbstractCascaderTest.Tata().setName("y").setId(tataId));
        testInstance.afterUpdate((Iterable)Arrays.asList((Object[])new Duo[]{new Duo((Object)triggeringInstance1_modified, (Object)triggeringInstance1), new Duo((Object)triggeringInstance2_modified, (Object)triggeringInstance2)}), true);
        Assertions.assertThat(actions).isEqualTo((Object)Arrays.asList((Object[])new String[]{"getTargets", "getTargets", "postTargetUpdate"}));
        Assertions.assertThat(triggeredTarget).isEqualTo((Object)Arrays.asList((Object[])new Duo[]{new Duo((Object)triggeringInstance1_modified.tata, (Object)triggeringInstance1.tata), new Duo((Object)triggeringInstance2_modified.tata, (Object)triggeringInstance2.tata)}));
    }
}

