/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.reduce;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.StalactiteRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.reduce.LimitHandler;
import org.springframework.data.domain.Pageable;

public abstract class QueryResultWindower<C, R, P> {
    private final StalactiteRepositoryQuery<C, ?> delegate;
    protected final LimitHandler limitHandler;
    private final BiFunction<StalactiteQueryMethodInvocationParameters, List<P>, R> queryResultSlicer;
    private final Supplier<List<P>> resultSupplier;

    public QueryResultWindower(StalactiteRepositoryQuery<C, ?> delegate, LimitHandler limitHandler, BiFunction<StalactiteQueryMethodInvocationParameters, List<P>, R> queryResultSlicer, Supplier<List<P>> resultSupplier) {
        this.delegate = delegate;
        this.limitHandler = limitHandler;
        this.queryResultSlicer = queryResultSlicer;
        this.resultSupplier = resultSupplier;
    }

    public R adaptExecution(Object[] parameters) {
        StalactiteQueryMethodInvocationParameters invocationParameters = new StalactiteQueryMethodInvocationParameters(this.delegate.getQueryMethod(), parameters);
        this.adaptLimit(invocationParameters);
        List<P> delegateResult = this.resultSupplier.get();
        return this.queryResultSlicer.apply(invocationParameters, delegateResult);
    }

    protected void adaptLimit(StalactiteQueryMethodInvocationParameters invocationParameters) {
        Pageable pageable = invocationParameters.getPageable();
        this.limitHandler.limit(pageable.getPageSize(), (int)pageable.getOffset());
    }
}

