/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.spring.repository.query.AbstractDerivedQuery;
import org.codefilarete.stalactite.spring.repository.query.PartTreeStalactiteCountProjection;
import org.codefilarete.stalactite.spring.repository.query.ProjectionTypeInformationExtractor;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.StalactiteRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.reduce.LimitHandler;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultCollectioner;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultPager;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultReducer;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultSingler;
import org.codefilarete.stalactite.spring.repository.query.reduce.QueryResultSlicer;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Hanger;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeStalactiteProjection<C, R>
implements StalactiteRepositoryQuery<C, R> {
    private final StalactiteQueryMethod method;
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final PartTree tree;
    private final Accumulator<Function<Selectable<Object>, Object>, List<Map<String, Object>>, List<Map<String, Object>>> accumulator;
    private final DerivedQuery<C> query;
    private final Consumer<Select> selectConsumer;

    @VisibleForTesting
    public static void buildHierarchicMap(String dottedProperty, Object value, Map<String, Object> root) {
        String[] parts = dottedProperty.split("\\.");
        Map current = root;
        int lengthMinus1 = parts.length - 1;
        for (int i = 0; i < lengthMinus1; ++i) {
            current = (Map)current.computeIfAbsent((String)parts[i], k -> new HashMap());
        }
        current.putIfAbsent((String)parts[lengthMinus1], (Object)value);
    }

    public PartTreeStalactiteProjection(StalactiteQueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree tree, ProjectionFactory factory) {
        this.method = method;
        this.entityPersister = entityPersister;
        this.tree = tree;
        final ProjectionTypeInformationExtractor projectionTypeInformationExtractor = new ProjectionTypeInformationExtractor(factory, entityPersister);
        projectionTypeInformationExtractor.extract(method.getReturnedObjectType());
        final Hanger.Holder selectHolder = new Hanger.Holder();
        this.selectConsumer = select -> {
            select.clear();
            selectHolder.set(select);
            projectionTypeInformationExtractor.getColumnToProperties().keySet().forEach(selectable -> select.add(selectable, projectionTypeInformationExtractor.getAliases().get(selectable)));
        };
        this.accumulator = new Accumulator<Function<Selectable<Object>, Object>, List<Map<String, Object>>, List<Map<String, Object>>>(){

            public Supplier<List<Map<String, Object>>> supplier() {
                return LinkedList::new;
            }

            public BiConsumer<List<Map<String, Object>>, Function<Selectable<Object>, Object>> aggregator() {
                return (finalResult, databaseRowDataProvider) -> {
                    Select selectables = (Select)selectHolder.get();
                    KeepOrderSet columns = selectables.getColumns();
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    finalResult.add(row);
                    for (Selectable selectable : columns) {
                        PartTreeStalactiteProjection.buildHierarchicMap(projectionTypeInformationExtractor.getColumnToProperties().get(selectable).toDotPath(), databaseRowDataProvider.apply(selectable), row);
                    }
                };
            }

            public Function<List<Map<String, Object>>, List<Map<String, Object>>> finisher() {
                return Function.identity();
            }
        };
        try {
            this.query = new DerivedQuery(entityPersister, tree);
            if (tree.getSort().isSorted()) {
                tree.getSort().iterator().forEachRemaining(order -> {
                    PropertyPath propertyPath = PropertyPath.from((String)order.getProperty(), (Class)entityPersister.getClassToPersist());
                    AccessorChain orderProperty = this.query.convertToAccessorChain(propertyPath);
                    this.query.executableProjectionQuery.getQueryPageSupport().orderBy(orderProperty, order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
                });
            }
            Nullable.nullable((Object)tree.getMaxResults()).invoke(arg_0 -> ((ProjectionQueryCriteriaSupport.ProjectionQueryPageSupport)this.query.executableProjectionQuery.getQueryPageSupport()).limit(arg_0));
        }
        catch (RuntimeException o_O) {
            throw new IllegalArgumentException(String.format("Failed to create query for method %s! %s", new Object[]{method, o_O.getMessage()}), o_O);
        }
    }

    public DerivedQuery<C> getQuery() {
        return this.query;
    }

    @Override
    public R execute(Object[] parameters) {
        this.query.criteriaChain.consume(parameters);
        Supplier resultSupplier = this.buildQueryExecutor(parameters);
        R adaptation = this.buildResultWindower().adapt(resultSupplier).apply(parameters);
        if (this.method.getParameters().hasDynamicProjection()) {
            return (R)this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)new ParametersParameterAccessor((Parameters)this.method.getParameters(), parameters)).processResult(adaptation);
        }
        return (R)this.method.getResultProcessor().processResult(adaptation);
    }

    private QueryResultReducer<R, Map<String, Object>> buildResultWindower() {
        QueryResultReducer result = this.method.isPageQuery() ? new QueryResultPager(this, new LimitHandler(){

            @Override
            public void limit(int count) {
                ((PartTreeStalactiteProjection)PartTreeStalactiteProjection.this).query.executableProjectionQuery.getQueryPageSupport().limit(count);
            }

            @Override
            public void limit(int count, Integer offset) {
                ((PartTreeStalactiteProjection)PartTreeStalactiteProjection.this).query.executableProjectionQuery.getQueryPageSupport().limit(count, offset);
            }
        }, new PartTreeStalactiteCountProjection<C>(this.method, this.entityPersister, this.tree)) : (this.method.isSliceQuery() ? new QueryResultSlicer(this, new LimitHandler(){

            @Override
            public void limit(int count) {
                ((PartTreeStalactiteProjection)PartTreeStalactiteProjection.this).query.executableProjectionQuery.getQueryPageSupport().limit(count);
            }

            @Override
            public void limit(int count, Integer offset) {
                ((PartTreeStalactiteProjection)PartTreeStalactiteProjection.this).query.executableProjectionQuery.getQueryPageSupport().limit(count, offset);
            }
        }) : (this.method.isCollectionQuery() ? new QueryResultCollectioner() : new QueryResultSingler()));
        return result;
    }

    protected Supplier<List<Map<String, Object>>> buildQueryExecutor(Object[] parameters) {
        return () -> (List)this.handleDynamicSort(parameters).wrapIntoExecutable().execute(this.accumulator);
    }

    private ProjectionQueryCriteriaSupport<C, ?> handleDynamicSort(Object[] parameters) {
        ProjectionQueryCriteriaSupport derivedQueryToUse;
        ParametersParameterAccessor parameterHelper = new ParametersParameterAccessor((Parameters)this.getQueryMethod().getParameters(), parameters);
        if (parameterHelper.getSort().isSorted()) {
            DerivedQuery derivedQuery = new DerivedQuery(this.query.executableProjectionQuery);
            Class declaringClass = this.getQueryMethod().getEntityInformation().getJavaType();
            parameterHelper.getSort().stream().forEachOrdered(order -> {
                AccessorByMember accessor = Accessors.accessor((Class)declaringClass, (String)order.getProperty());
                derivedQuery.dynamicSortSupport.orderBy(new AccessorChain(new Accessor[]{accessor}), order.getDirection() == Sort.Direction.ASC ? EntityPersister.OrderByChain.Order.ASC : EntityPersister.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
            derivedQueryToUse = derivedQuery.executableProjectionQuery.copyFor(derivedQuery.dynamicSortSupport);
        } else {
            derivedQueryToUse = this.query.executableProjectionQuery;
        }
        return derivedQueryToUse;
    }

    @Override
    public StalactiteQueryMethod getQueryMethod() {
        return this.method;
    }

    private class DerivedQuery<T>
    extends AbstractDerivedQuery<T> {
        protected final ProjectionQueryCriteriaSupport<T, ?> executableProjectionQuery;
        protected final ProjectionQueryCriteriaSupport.ProjectionQueryPageSupport<T> dynamicSortSupport = new ProjectionQueryCriteriaSupport.ProjectionQueryPageSupport();
        private EntityCriteriaSupport<T> currentSupport;

        private DerivedQuery(AdvancedEntityPersister<T, ?> entityPersister, PartTree tree) {
            this.executableProjectionQuery = entityPersister.newProjectionCriteriaSupport(PartTreeStalactiteProjection.this.selectConsumer);
            tree.forEach(this::append);
        }

        private DerivedQuery(ProjectionQueryCriteriaSupport<T, ?> executableProjectionQuery) {
            this.executableProjectionQuery = executableProjectionQuery;
        }

        private void append(PartTree.OrPart part) {
            Iterator iterator;
            this.currentSupport = this.executableProjectionQuery.getEntityCriteriaSupport();
            boolean nested = false;
            if (part.stream().count() > 1L) {
                nested = true;
                this.currentSupport = this.currentSupport.beginNested();
            }
            if ((iterator = part.iterator()).hasNext()) {
                this.append((Part)iterator.next(), LogicalOperator.OR);
            }
            iterator.forEachRemaining(p -> this.append((Part)p, LogicalOperator.AND));
            if (nested) {
                this.currentSupport = this.currentSupport.endNested();
            }
        }

        private void append(Part part, LogicalOperator orOrAnd) {
            AccessorChain getter = this.convertToAccessorChain(part.getProperty());
            AbstractDerivedQuery.Criterion criterion = this.convertToCriterion(part.getType(), part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER);
            this.currentSupport.add(orOrAnd, getter.getAccessors(), criterion.operator);
            this.criteriaChain.criteria.add(criterion);
        }
    }
}

