/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.lang.reflect.Method;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.Lazy;

public class StalactiteQueryMethod
extends QueryMethod {
    private final Method method;
    private final Lazy<QueryMethodReturnType> queryMethodReturnType;

    public StalactiteQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
        this.queryMethodReturnType = Lazy.of(() -> {
            if (this.isCollectionQuery()) {
                return QueryMethodReturnType.COLLECTION;
            }
            if (this.isPageQuery()) {
                return QueryMethodReturnType.PAGE;
            }
            if (this.isSliceQuery()) {
                return QueryMethodReturnType.SLICE;
            }
            if (this.isQueryForEntity()) {
                return QueryMethodReturnType.SINGLE_ENTITY;
            }
            return QueryMethodReturnType.SINGLE_PROJECTION;
        });
    }

    protected RelationalParameters createParameters(Method method) {
        return new RelationalParameters(method);
    }

    public RelationalParameters getParameters() {
        return (RelationalParameters)super.getParameters();
    }

    public QueryMethodReturnType getQueryMethodReturnType() {
        return (QueryMethodReturnType)((Object)this.queryMethodReturnType.get());
    }

    public Method getMethod() {
        return this.method;
    }

    public static enum QueryMethodReturnType {
        COLLECTION,
        PAGE,
        SLICE,
        SINGLE_ENTITY,
        SINGLE_PROJECTION;

    }
}

