/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Connection;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Index;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

public class DDLTableGeneratorTest {
    @Test
    void generateCreateTable() {
        DDLTableGenerator testInstance = new DDLTableGenerator(null, DMLNameProvider::new){

            protected String getSqlType(Column column) {
                return "type";
            }
        };
        Table t = new Table(null, "Toto");
        t.addColumn("A", String.class);
        String generatedCreateTable = testInstance.generateCreateTable(t);
        Assertions.assertThat((String)generatedCreateTable).isEqualTo("create table Toto(A type)");
        t.addColumn("B", String.class);
        generatedCreateTable = testInstance.generateCreateTable(t);
        Assertions.assertThat((String)generatedCreateTable).isEqualTo("create table Toto(A type, B type)");
        final Column primaryKey = t.addColumn("C", String.class);
        primaryKey.setPrimaryKey(true);
        generatedCreateTable = testInstance.generateCreateTable(t);
        Assertions.assertThat((String)generatedCreateTable).isEqualTo("create table Toto(A type, B type, C type, primary key (C))");
        t.addColumn("D", Integer.TYPE);
        generatedCreateTable = testInstance.generateCreateTable(t);
        Assertions.assertThat((String)generatedCreateTable).isEqualTo("create table Toto(A type, B type, C type, D type not null, primary key (C))");
        DMLNameProviderFactory dmlNameProvider = tableAliaser -> new DMLNameProvider(tableAliaser){

            public String getSimpleName(Selectable<?> column) {
                if (column == primaryKey) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        t.addColumn("D", Integer.TYPE);
        testInstance = new DDLTableGenerator(null, dmlNameProvider){

            protected String getSqlType(Column column) {
                return "type";
            }
        };
        generatedCreateTable = testInstance.generateCreateTable(t);
        Assertions.assertThat((String)generatedCreateTable).isEqualTo("create table Toto(A type, B type, 'key' type, D type not null, primary key ('key'))");
    }

    @Test
    void columnSizeIsTakenIntoAccount() {
        DefaultTypeMapping typeMapping = new DefaultTypeMapping();
        DDLTableGenerator testInstance = new DDLTableGenerator(new SqlTypeRegistry((JavaTypeToSqlTypeMapping)typeMapping), DMLNameProvider::new);
        Table t = new Table(null, "Toto");
        t.addColumn("A", Path.class, (Size)Size.length((int)100));
        String generatedCreateTable = testInstance.generateCreateTable(t);
        Assertions.assertThat((String)generatedCreateTable).isEqualTo("create table Toto(A varchar(100))");
        t.addColumn("B", BigDecimal.class, (Size)Size.fixedPoint((int)9, (Integer)4));
        generatedCreateTable = testInstance.generateCreateTable(t);
        Assertions.assertThat((String)generatedCreateTable).isEqualTo("create table Toto(A varchar(100), B decimal(9, 4))");
    }

    @Test
    void generateDropTable() {
        DDLTableGenerator testInstance = new DDLTableGenerator(null, DMLNameProvider::new);
        final Table toto = new Table(null, "Toto");
        String generateDropTable = testInstance.generateDropTable(toto);
        Assertions.assertThat((String)generateDropTable).isEqualTo("drop table Toto");
        DMLNameProviderFactory dmlNameProvider = tableAliaser -> new DMLNameProvider(tableAliaser){

            public String getName(Fromable table) {
                if (table == toto) {
                    return "'user'";
                }
                return super.getName((Fromable)toto);
            }
        };
        testInstance = new DDLTableGenerator(null, dmlNameProvider);
        generateDropTable = testInstance.generateDropTable(toto);
        Assertions.assertThat((String)generateDropTable).isEqualTo("drop table 'user'");
    }

    @Test
    void generateDropTableIfExists() {
        DDLTableGenerator testInstance = new DDLTableGenerator(null, DMLNameProvider::new);
        final Table toto = new Table(null, "Toto");
        String generateDropTable = testInstance.generateDropTableIfExists(toto);
        Assertions.assertThat((String)generateDropTable).isEqualTo("drop table if exists Toto");
        DMLNameProviderFactory dmlNameProvider = tableAliaser -> new DMLNameProvider(tableAliaser){

            public String getName(Fromable table) {
                if (table == toto) {
                    return "'user'";
                }
                return super.getName((Fromable)toto);
            }
        };
        testInstance = new DDLTableGenerator(null, dmlNameProvider);
        generateDropTable = testInstance.generateDropTableIfExists(toto);
        Assertions.assertThat((String)generateDropTable).isEqualTo("drop table if exists 'user'");
    }

    @Test
    void generateAddColumn() {
        DDLTableGenerator testInstance = new DDLTableGenerator(null, DMLNameProvider::new){

            protected String getSqlType(Column column) {
                return "type";
            }
        };
        Table t = new Table(null, "Toto");
        final Column newColumn = t.addColumn("A", String.class);
        String generateAddColumn = testInstance.generateAddColumn(newColumn);
        Assertions.assertThat((String)generateAddColumn).isEqualTo("alter table Toto add column A type");
        DMLNameProviderFactory dmlNameProvider = tableAliaser -> new DMLNameProvider(tableAliaser){

            public String getSimpleName(Selectable<?> column) {
                if (column == newColumn) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        testInstance = new DDLTableGenerator(null, dmlNameProvider){

            protected String getSqlType(Column column) {
                return "type";
            }
        };
        generateAddColumn = testInstance.generateAddColumn(newColumn);
        Assertions.assertThat((String)generateAddColumn).isEqualTo("alter table Toto add column 'key' type");
    }

    @Test
    void generateDropColumn() {
        DDLTableGenerator testInstance = new DDLTableGenerator(null, DMLNameProvider::new){

            protected String getSqlType(Column column) {
                return "type";
            }
        };
        Table t = new Table(null, "Toto");
        final Column newColumn = t.addColumn("A", String.class);
        String generateDropColumn = testInstance.generateDropColumn(newColumn);
        Assertions.assertThat((String)generateDropColumn).isEqualTo("alter table Toto drop column A");
        DMLNameProviderFactory dmlNameProvider = tableAliaser -> new DMLNameProvider(tableAliaser){

            public String getSimpleName(Selectable<?> column) {
                if (column == newColumn) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        testInstance = new DDLTableGenerator(null, dmlNameProvider){

            protected String getSqlType(Column column) {
                return "type";
            }
        };
        generateDropColumn = testInstance.generateDropColumn(newColumn);
        Assertions.assertThat((String)generateDropColumn).isEqualTo("alter table Toto drop column 'key'");
    }

    @Test
    void generateCreateIndex() {
        DDLTableGenerator testInstance = new DDLTableGenerator(null, DMLNameProvider::new);
        Table t = new Table(null, "Toto");
        final Column colA = t.addColumn("A", String.class);
        Column colB = t.addColumn("B", String.class);
        Index idx1 = t.addIndex("Idx1", colA, new Column[0]);
        String generatedCreateIndex = testInstance.generateCreateIndex(idx1);
        Assertions.assertThat((String)generatedCreateIndex).isEqualTo("create index Idx1 on Toto(A)");
        Index idx2 = t.addIndex("Idx2", colA, new Column[]{colB});
        generatedCreateIndex = testInstance.generateCreateIndex(idx2);
        Assertions.assertThat((String)generatedCreateIndex).isEqualTo("create index Idx2 on Toto(A, B)");
        DMLNameProviderFactory dmlNameProvider = tableAliaser -> new DMLNameProvider(tableAliaser){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        t.addColumn("D", Integer.TYPE);
        testInstance = new DDLTableGenerator(null, dmlNameProvider);
        generatedCreateIndex = testInstance.generateCreateIndex(idx2);
        Assertions.assertThat((String)generatedCreateIndex).isEqualTo("create index Idx2 on Toto('key', B)");
    }

    @Test
    void generateDropIndex() {
        DDLTableGenerator testInstance = new DDLTableGenerator(null, DMLNameProvider::new);
        Table t = new Table(null, "Toto");
        final Column colA = t.addColumn("A", String.class);
        Index idx = t.addIndex("idx1", colA, new Column[0]);
        String generateDropIndex = testInstance.generateDropIndex(idx);
        Assertions.assertThat((String)generateDropIndex).isEqualTo("drop index idx1");
        DMLNameProviderFactory dmlNameProvider = tableAliaser -> new DMLNameProvider(tableAliaser){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        testInstance = new DDLTableGenerator(null, dmlNameProvider){

            protected String getSqlType(Column column) {
                return "type";
            }
        };
        generateDropIndex = testInstance.generateDropIndex(idx);
        Assertions.assertThat((String)generateDropIndex).isEqualTo("drop index idx1");
    }

    @Test
    void generateCreateForeignKey() {
        DDLTableGenerator testInstance = new DDLTableGenerator(null, DMLNameProvider::new);
        Table toto = new Table(null, "Toto");
        final Column colA = toto.addColumn("A", String.class);
        Column colB = toto.addColumn("B", String.class);
        Table titi = new Table(null, "Titi");
        final Column colA2 = titi.addColumn("A", String.class);
        Column colB2 = titi.addColumn("B", String.class);
        ForeignKey foreignKey = toto.addForeignKey("FK1", colA, colA2);
        String generatedCreateIndex = testInstance.generateCreateForeignKey(foreignKey);
        Assertions.assertThat((String)generatedCreateIndex).isEqualTo("alter table Toto add constraint FK1 foreign key(A) references Titi(A)");
        foreignKey = toto.addForeignKey("FK2", Arrays.asList((Object[])new Column[]{colA, colB}), Arrays.asList((Object[])new Column[]{colA2, colB2}));
        generatedCreateIndex = testInstance.generateCreateForeignKey(foreignKey);
        Assertions.assertThat((String)generatedCreateIndex).isEqualTo("alter table Toto add constraint FK2 foreign key(A, B) references Titi(A, B)");
        DMLNameProviderFactory dmlNameProvider = tableAliaser -> new DMLNameProvider(tableAliaser){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA || column == colA2) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        testInstance = new DDLTableGenerator(null, dmlNameProvider);
        generatedCreateIndex = testInstance.generateCreateForeignKey(foreignKey);
        Assertions.assertThat((String)generatedCreateIndex).isEqualTo("alter table Toto add constraint FK2 foreign key('key', B) references Titi('key', B)");
    }

    @Test
    void generateDropForeignKey() {
        DDLTableGenerator testInstance = new DDLTableGenerator(null, DMLNameProvider::new);
        Table toto = new Table(null, "Toto");
        final Column colA = toto.addColumn("A", String.class);
        Table titi = new Table(null, "Titi");
        Column colA2 = titi.addColumn("A", String.class);
        ForeignKey foreignKey = toto.addForeignKey("FK1", colA, colA2);
        String generateDropForeignKey = testInstance.generateDropForeignKey(foreignKey);
        Assertions.assertThat((String)generateDropForeignKey).isEqualTo("alter table Toto drop constraint FK1");
        DMLNameProviderFactory dmlNameProvider = tableAliaser -> new DMLNameProvider(tableAliaser){

            public String getSimpleName(Selectable<?> column) {
                if (column == colA) {
                    return "'key'";
                }
                return super.getSimpleName(column);
            }
        };
        testInstance = new DDLTableGenerator(null, dmlNameProvider){

            protected String getSqlType(Column column) {
                return "type";
            }
        };
        generateDropForeignKey = testInstance.generateDropForeignKey(foreignKey);
        Assertions.assertThat((String)generateDropForeignKey).isEqualTo("alter table Toto drop constraint FK1");
    }

    static abstract class IntegrationTest {
        protected final Table table1 = new Table("dummyTable1");
        protected final Table table2 = new Table("dummyTable2");

        public IntegrationTest() {
            this.defineSchema();
        }

        protected void defineSchema() {
            this.table1.addColumn("id", Integer.TYPE).primaryKey().autoGenerated();
            Column nameColumn = this.table1.addColumn("name", String.class);
            this.table1.addIndex("dummyIDX_1", nameColumn, new Column[0]);
            this.table1.addUniqueConstraint("dummy_UK", nameColumn, new Column[0]);
            Column nameColumn2 = this.table2.addColumn("name", String.class);
            this.table2.addForeignKey("dummyTable2_FK", nameColumn2, nameColumn);
        }

        void assertGeneratedSQL_runOnAliveDatabase_doesNotThrowException(DDLTableGenerator testInstance, Connection connection) {
            DDLDeployer ddlDeployer = new DDLDeployer(testInstance, new DDLSequenceGenerator(testInstance.dmlNameProvider), (ConnectionProvider)new SimpleConnectionProvider(connection));
            ddlDeployer.getDdlGenerator().addTables(this.table1, new Table[]{this.table2});
            Assertions.assertThatCode(() -> ((DDLDeployer)ddlDeployer).deployDDL()).doesNotThrowAnyException();
        }
    }
}

