/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualLinkedHashBidiMap;
import org.apache.commons.collections4.bidimap.UnmodifiableBidiMap;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.PassiveJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.TablePerClassPolymorphicRelationJoinNode;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Randomizer;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.ReadOnlyList;

public class EntityJoinTree<C, I> {
    public static final String ROOT_JOIN_NAME = "ROOT";
    private final JoinRoot<C, I, ?> root;
    private final BidiMap<String, JoinNode<?, ?>> joinIndex = new DualLinkedHashBidiMap();
    private final NodeKeyGenerator indexKeyGenerator = new NodeKeyGenerator();
    private final Set<Table<?>> tablesToExcludeFromDDL = new TreeSet(Table.COMPARATOR_ON_SCHEMA_AND_NAME);
    private final Set<Table<?>> tablesToIncludeToDDL = new TreeSet(Table.COMPARATOR_ON_SCHEMA_AND_NAME);

    public EntityJoinTree(EntityMapping<C, I, ?> entityMapping) {
        this(new EntityInflater.EntityMappingAdapter(entityMapping), (Fromable)entityMapping.getTargetTable());
    }

    public EntityJoinTree(EntityInflater<C, I> rootEntityInflater, Fromable table) {
        this.root = new JoinRoot<C, I, Fromable>(this, rootEntityInflater, table);
        this.joinIndex.put((Object)ROOT_JOIN_NAME, this.root);
    }

    public EntityJoinTree(Function<EntityJoinTree<C, I>, JoinRoot<C, I, ?>> joinRootCreator) {
        this.root = joinRootCreator.apply(this);
        this.joinIndex.put((Object)ROOT_JOIN_NAME, this.root);
    }

    public JoinRoot<C, I, ?> getRoot() {
        return this.root;
    }

    @VisibleForTesting
    public BidiMap<String, JoinNode> getJoinIndex() {
        return UnmodifiableBidiMap.unmodifiableBidiMap(this.joinIndex);
    }

    public void addTableToIncludeToDDL(Table<?> table) {
        this.tablesToIncludeToDDL.add(table);
    }

    public <U, T1 extends Table<T1>, T2 extends Table<T2>, ID> String addRelationJoin(String leftStrategyName, EntityInflater<U, ID> inflater, Accessor<?, ?> propertyAccessor, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn, String rightTableAlias, JoinType joinType, BeanRelationFixer<C, U> beanRelationFixer, Set<? extends Column<T2, ?>> additionalSelectableColumns) {
        return this.addRelationJoin(leftStrategyName, inflater, propertyAccessor, leftJoinColumn, rightJoinColumn, rightTableAlias, joinType, beanRelationFixer, additionalSelectableColumns, null);
    }

    public <U, T1 extends Table<T1>, T2 extends Table<T2>, ID, JOINTYPE> String addRelationJoin(String leftStrategyName, EntityInflater<U, ID> inflater, Accessor<?, ?> propertyAccessor, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, @Nullable String rightTableAlias, JoinType joinType, BeanRelationFixer<?, U> beanRelationFixer, Set<? extends Column<T2, ?>> additionalSelectableColumns, @Nullable Function<ColumnedRow, Object> relationIdentifierProvider) {
        return this.addJoin(leftStrategyName, parent -> {
            Duo<Fromable, IdentityHashMap<Selectable<?>, Selectable<?>>> tableClone = EntityJoinTree.cloneTable(rightJoinColumn.getTable());
            Key.KeyBuilder rightJoinLinkBuilder = Key.from((Fromable)((Fromable)tableClone.getLeft()));
            KeepOrderSet columns = rightJoinColumn.getColumns();
            for (JoinLink column : columns) {
                JoinLink clonedColumn = (JoinLink)((IdentityHashMap)tableClone.getRight()).get(column);
                rightJoinLinkBuilder.addColumn(clonedColumn);
            }
            IdentityHashMap originalColumnsToClones = (IdentityHashMap)tableClone.getRight();
            return new RelationJoinNode(parent, propertyAccessor, leftJoinColumn, rightJoinLinkBuilder.build(), joinType, (Set<? extends Selectable<?>>)((Set<Selectable<?>>)new KeepOrderSet((Collection)Collections.cat((Collection[])new Collection[]{inflater.getSelectableColumns(), additionalSelectableColumns}))), rightTableAlias, inflater, beanRelationFixer, relationIdentifierProvider, originalColumnsToClones);
        });
    }

    public <U, T1 extends Fromable, T2 extends Fromable, ID> String addMergeJoin(String leftStrategyName, EntityMerger<U> inflater, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn) {
        return this.addJoin(leftStrategyName, parent -> new MergeJoinNode(parent, leftJoinColumn, rightJoinColumn, JoinType.INNER, null, inflater));
    }

    public <U, T1 extends Fromable, T2 extends Fromable, ID> String addMergeJoin(String leftStrategyName, EntityMerger<U> entityMerger, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn, JoinType joinType) {
        return this.addJoin(leftStrategyName, parent -> new MergeJoinNode(parent, leftJoinColumn, rightJoinColumn, joinType, null, entityMerger));
    }

    public <U, T1 extends Fromable, T2 extends Fromable, ID> String addMergeJoin(String leftStrategyName, EntityMerger<U> entityMerger, Key<T1, ID> leftJoinColumn, Key<T2, ID> rightJoinColumn, JoinType joinType, final Function<JoinNode<U, T2>, MergeJoinNode.MergeJoinRowConsumer<U>> columnedRowConsumer) {
        return this.addJoin(leftStrategyName, parent -> new MergeJoinNode<U, T1, T2, ID>((JoinNode)parent, leftJoinColumn, rightJoinColumn, joinType, null, entityMerger){

            @Override
            public MergeJoinNode.MergeJoinRowConsumer<U> toConsumer(JoinNode<U, T2> joinNode) {
                return (MergeJoinNode.MergeJoinRowConsumer)columnedRowConsumer.apply(joinNode);
            }
        });
    }

    public <T1 extends Table<T1>, T2 extends Table<T2>, JOINTYPE> String addPassiveJoin(String leftStrategyName, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, JoinType joinType, Set<? extends JoinLink<T2, ?>> columnsToSelect) {
        return this.addJoin(leftStrategyName, parent -> new PassiveJoinNode(parent, leftJoinColumn, rightJoinColumn, joinType, (Set<? extends Selectable<?>>)((Set<Selectable<?>>)columnsToSelect), null));
    }

    public <T1 extends Table<T1>, T2 extends Table<T2>, JOINTYPE> String addPassiveJoin(String leftStrategyName, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, EntityTreeJoinNodeConsumptionListener<C> consumptionListener) {
        return this.addJoin(leftStrategyName, parent -> new PassiveJoinNode(parent, leftJoinColumn, rightJoinColumn, joinType, (Set<? extends Selectable<?>>)((Set<Selectable<?>>)columnsToSelect), null).setConsumptionListener(consumptionListener));
    }

    public <T1 extends Table<T1>, T2 extends Table<T2>, JOINTYPE> String addPassiveJoin(String leftStrategyName, Key<T1, JOINTYPE> leftJoinColumn, Key<T2, JOINTYPE> rightJoinColumn, String tableAlias, JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, EntityTreeJoinNodeConsumptionListener<C> consumptionListener, boolean rightTableParticipatesToDDL) {
        if (!rightTableParticipatesToDDL) {
            this.tablesToExcludeFromDDL.add((Table<?>)rightJoinColumn.getTable());
        }
        return this.addJoin(leftStrategyName, parent -> new PassiveJoinNode(parent, leftJoinColumn, rightJoinColumn, joinType, (Set<? extends Selectable<?>>)((Set<Selectable<?>>)columnsToSelect), tableAlias).setConsumptionListener(consumptionListener));
    }

    public String addJoin(String leftStrategyName, Function<? super JoinNode<?, Fromable>, ? extends AbstractJoinNode<?, ?, ?, ?>> joinNodeSupplier) {
        JoinNode<?, Fromable> owningJoin = this.getJoin(leftStrategyName);
        if (owningJoin == null) {
            throw new IllegalArgumentException("No join named " + leftStrategyName + " exists to add a new join on");
        }
        AbstractJoinNode<?, ?, ?, ?> joinNode = joinNodeSupplier.apply(owningJoin);
        String joinName = this.indexKeyGenerator.generateKey(joinNode);
        this.joinIndex.put((Object)joinName, joinNode);
        return joinName;
    }

    @Nullable
    public JoinNode<?, Fromable> getJoin(String leftStrategyName) {
        return (JoinNode)this.joinIndex.get((Object)leftStrategyName);
    }

    public Set<Table<?>> giveTables() {
        TreeSet result = new TreeSet(Table.COMPARATOR_ON_SCHEMA_AND_NAME);
        this.extractTable(this.getRoot(), result);
        this.foreachJoin(node -> {
            if (!(node instanceof TablePerClassPolymorphicRelationJoinNode)) {
                this.extractTable((JoinNode<?, ?>)node, result);
            }
        });
        this.tablesToIncludeToDDL.forEach(result::add);
        return result;
    }

    private void extractTable(JoinNode<?, ?> node, Set<Table<?>> result) {
        node.getOriginalColumnsToLocalOnes().keySet().forEach(column -> {
            Table table;
            if (column instanceof Column && !this.tablesToExcludeFromDDL.contains(table = ((Column)column).getTable())) {
                result.add(table);
            }
        });
    }

    @VisibleForTesting
    Set<Table<?>> lookupTable(QueryStatement.PseudoTable pseudoTable) {
        Object queries;
        HashSet result = new HashSet();
        if (pseudoTable.getQueryStatement() instanceof Query) {
            queries = Arrays.asSet((Object[])new Query[]{(Query)pseudoTable.getQueryStatement()});
        } else if (pseudoTable.getQueryStatement() instanceof Union) {
            queries = ((Union)pseudoTable.getQueryStatement()).getQueries();
        } else {
            throw new IllegalArgumentException("Pseudo table type is not supported: " + Reflections.toString(pseudoTable.getClass()));
        }
        queries.forEach(query -> {
            Fromable rightTable = query.getFromDelegate().getRoot();
            if (rightTable instanceof Table) {
                result.add((Table)rightTable);
            } else if (rightTable instanceof QueryStatement.PseudoTable) {
                result.addAll(this.lookupTable((QueryStatement.PseudoTable)rightTable));
            }
        });
        queries.forEach(query -> query.getFromDelegate().getJoins().forEach(join -> {
            Fromable rightTable = join.getRightTable();
            if (rightTable instanceof Table) {
                result.add((Table)rightTable);
            } else if (rightTable instanceof QueryStatement.PseudoTable) {
                result.addAll(this.lookupTable((QueryStatement.PseudoTable)rightTable));
            }
        }));
        return result;
    }

    public void foreachJoin(Consumer<AbstractJoinNode<?, ?, ?, ?>> consumer) {
        this.joinIterator().forEachRemaining(consumer);
    }

    public <E, ID> void projectTo(EntityJoinTree<E, ID> target, String joinNodeName) {
        this.projectTo(target.getJoin(joinNodeName));
    }

    public void projectTo(JoinNode<?, Fromable> joinNode) {
        EntityJoinTree tree = joinNode.getTree();
        this.foreachJoinWithDepth(joinNode, (targetOwner, currentNode) -> {
            currentNode.getLeftJoinLink().getColumns().forEach(leftColumn -> {
                Selectable projectedLeftColumn = targetOwner.getTable().findColumn(leftColumn.getExpression());
                if (projectedLeftColumn == null) {
                    throw new IllegalArgumentException("Expected column " + leftColumn.getExpression() + " to exist in target table " + targetOwner.getTable().getName() + " but couldn't be found among " + Iterables.collect((Iterable)targetOwner.getTable().getColumns(), Selectable::getExpression, ArrayList::new));
                }
            });
            AbstractJoinNode nodeClone = EntityJoinTree.cloneNodeForParent(currentNode, targetOwner, currentNode.getLeftJoinLink());
            Set set = this.joinIndex.entrySet();
            Map.Entry nodeName = (Map.Entry)Iterables.find((Iterable)set, entry -> entry.getValue() == currentNode);
            tree.joinIndex.put(nodeName.getKey(), nodeClone);
            return nodeClone;
        });
    }

    public Iterator<AbstractJoinNode<?, ?, ?, ?>> joinIterator() {
        return new NodeIterator();
    }

    <S> void foreachJoinWithDepth(S initialNode, BiFunction<S, AbstractJoinNode<?, ?, ?, ?>, S> consumer) {
        ArrayDeque<S> targetPath = new ArrayDeque<S>();
        targetPath.add(initialNode);
        NodeIteratorWithDepth nodeIterator = new NodeIteratorWithDepth(targetPath, consumer);
        while (nodeIterator.hasNext()) {
            nodeIterator.next();
        }
    }

    static <T extends Fromable> Duo<T, IdentityHashMap<Selectable<?>, Selectable<?>>> cloneTable(T fromable) {
        if (fromable instanceof Table) {
            Table table = (Table)fromable;
            Table tableClone = new Table(fromable.getName());
            IdentityHashMap columnClones = new IdentityHashMap(tableClone.getColumns().size());
            ((Table)fromable).getColumns().forEach(column -> {
                Column clone = tableClone.addColumn(column.getName(), column.getJavaType(), column.getSize());
                columnClones.put(column, clone);
            });
            if (table.getPrimaryKey() != null) {
                PrimaryKey primaryKey = table.getPrimaryKey();
                primaryKey.getColumns().forEach(column -> {
                    Column clonedColumn = (Column)columnClones.get(column);
                    clonedColumn.primaryKey();
                });
            }
            return new Duo((Object)tableClone, columnClones);
        }
        if (fromable instanceof QueryStatement.PseudoTable) {
            QueryStatement.PseudoTable pseudoTable = new QueryStatement.PseudoTable(((QueryStatement.PseudoTable)fromable).getQueryStatement(), fromable.getName());
            IdentityHashMap columnClones = new IdentityHashMap(pseudoTable.getColumns().size());
            ((QueryStatement.PseudoTable)fromable).getColumns().forEach(column -> {
                QueryStatement.PseudoColumn clone = ((Union)pseudoTable.getQueryStatement()).registerColumn(column.getExpression(), column.getJavaType());
                columnClones.put(column, clone);
            });
            return new Duo((Object)pseudoTable, columnClones);
        }
        throw new UnsupportedOperationException("Cloning " + Reflections.toString(fromable.getClass()) + " is not implemented");
    }

    static <T extends Fromable> Key.KeyBuilder<T, ?> mimicKey(Key<?, ?> leftJoinColumn, T fromable) {
        if (fromable instanceof Table) {
            Table table = (Table)fromable;
            Key.KeyBuilder leftKeyBuilder = Key.from((Fromable)table);
            leftJoinColumn.getColumns().forEach(column -> {
                Column column1 = table.addColumn(column.getExpression(), column.getJavaType());
                leftKeyBuilder.addColumn((JoinLink)column1);
            });
            return leftKeyBuilder;
        }
        if (fromable instanceof QueryStatement.PseudoTable) {
            QueryStatement.PseudoTable union = (QueryStatement.PseudoTable)fromable;
            Key.KeyBuilder leftKeyBuilder = Key.from((Fromable)union);
            leftJoinColumn.getColumns().forEach(column -> {
                Selectable column1 = union.findColumn(column.getExpression());
                leftKeyBuilder.addColumn((JoinLink)column1);
            });
            return leftKeyBuilder;
        }
        throw new UnsupportedOperationException("Cloning " + Reflections.toString(fromable.getClass()) + " is not implemented");
    }

    public static AbstractJoinNode<?, ?, ?, ?> cloneNodeForParent(AbstractJoinNode<?, ?, ?, ?> node, JoinNode parent, Key<?, ?> leftJoinColumn) {
        AbstractJoinNode nodeCopy;
        Duo<?, IdentityHashMap<Selectable<?>, Selectable<?>>> tableClone = EntityJoinTree.cloneTable(node.getTable());
        Key.KeyBuilder rightJoinLinkBuilder = Key.from((Fromable)((Fromable)tableClone.getLeft()));
        KeepOrderSet columns = node.getRightJoinLink().getColumns();
        for (JoinLink column : columns) {
            JoinLink clonedColumn = (JoinLink)((IdentityHashMap)tableClone.getRight()).get(column);
            rightJoinLinkBuilder.addColumn(clonedColumn);
        }
        IdentityHashMap originalColumnsToClones = (IdentityHashMap)Maps.innerJoinOnValuesAndKeys(node.getOriginalColumnsToLocalOnes(), (Map)((Map)tableClone.getRight()), IdentityHashMap::new);
        Key.KeyBuilder leftJoinLinkBuilder = EntityJoinTree.mimicKey(leftJoinColumn, parent.getTable());
        if (node instanceof RelationJoinNode) {
            nodeCopy = new RelationJoinNode(parent, ((RelationJoinNode)node).getPropertyAccessor(), leftJoinLinkBuilder.build(), rightJoinLinkBuilder.build(), node.getJoinType(), node.getColumnsToSelect(), node.getTableAlias(), ((RelationJoinNode)node).getEntityInflater(), ((RelationJoinNode)node).getBeanRelationFixer(), ((RelationJoinNode)node).getRelationIdentifierProvider(), originalColumnsToClones);
        } else if (node instanceof MergeJoinNode) {
            nodeCopy = new MergeJoinNode(parent, leftJoinLinkBuilder.build(), rightJoinLinkBuilder.build(), node.getJoinType(), node.getTableAlias(), ((MergeJoinNode)node).getMerger(), node.getColumnsToSelect(), originalColumnsToClones);
        } else if (node instanceof PassiveJoinNode) {
            nodeCopy = new PassiveJoinNode(parent, leftJoinLinkBuilder.build(), rightJoinLinkBuilder.build(), node.getJoinType(), (Set<? extends Selectable<?>>)node.getColumnsToSelect(), node.getTableAlias(), (IdentityHashMap<Selectable<?>, Selectable<?>>)originalColumnsToClones);
        } else {
            throw new UnsupportedOperationException("Unexpected type of join : some algorithm has changed, please implement it here or fix it : " + Reflections.toString(node.getClass()));
        }
        nodeCopy.setConsumptionListener((EntityTreeJoinNodeConsumptionListener)node.getConsumptionListener());
        return nodeCopy;
    }

    public static enum JoinType {
        INNER,
        OUTER;

    }

    private class NodeKeyGenerator {
        private final Randomizer keyGenerator = new Randomizer((Randomizer.IRandomGenerator)new Randomizer.LinearRandomGenerator(new Random()));

        private NodeKeyGenerator() {
        }

        private String generateKey(JoinNode node) {
            return node.getTable().getAbsoluteName() + "-" + Integer.toHexString(System.identityHashCode(EntityJoinTree.this)) + "-" + this.keyGenerator.randomHexString(6);
        }
    }

    private class NodeIteratorWithDepth<S>
    extends NodeIterator {
        private final Queue<S> targetPath;
        private final BiFunction<S, AbstractJoinNode<Object, Fromable, Fromable, Object>, S> consumer;

        public NodeIteratorWithDepth(Queue<S> targetPath, BiFunction<S, AbstractJoinNode<?, ?, ?, ?>, S> consumer) {
            this.targetPath = targetPath;
            this.consumer = consumer;
        }

        @Override
        public AbstractJoinNode next() {
            AbstractJoinNode nextIterationNode;
            super.next();
            S targetOwner = this.targetPath.peek();
            S nodeClone = this.consumer.apply(targetOwner, this.currentNode);
            if (this.nextDepth) {
                this.targetPath.add(nodeClone);
            }
            if ((nextIterationNode = (AbstractJoinNode)this.joinStack.peek()) != null && nextIterationNode.getParent() != this.currentNode.getParent()) {
                this.targetPath.remove();
            }
            return this.currentNode;
        }

        @Override
        public void forEachRemaining(Consumer<? super AbstractJoinNode<?, ?, ?, ?>> action) {
            throw new UnsupportedOperationException();
        }
    }

    private class NodeIterator
    implements Iterator<AbstractJoinNode<?, ?, ?, ?>> {
        protected final Queue<AbstractJoinNode> joinStack;
        protected AbstractJoinNode currentNode;
        protected boolean nextDepth = false;

        public NodeIterator() {
            this.joinStack = new ArrayDeque((Collection<AbstractJoinNode<?, ?, ?, ?>>)EntityJoinTree.this.root.getJoins());
        }

        @Override
        public boolean hasNext() {
            return !this.joinStack.isEmpty();
        }

        @Override
        public AbstractJoinNode next() {
            this.currentNode = this.joinStack.remove();
            ReadOnlyList<AbstractJoinNode<?, ?, ?, ?>> nextJoins = this.currentNode.getJoins();
            this.joinStack.addAll((Collection<AbstractJoinNode>)nextJoins);
            this.nextDepth = !nextJoins.isEmpty();
            return this.currentNode;
        }
    }
}

