/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.Strings;

public interface MapEntryTableNamingStrategy {
    public static final MapEntryTableNamingStrategy DEFAULT = new DefaultMapEntryTableNamingStrategy();

    public String giveTableName(AccessorDefinition var1, Class<?> var2, Class<?> var3);

    public <RIGHTTABLE extends Table<RIGHTTABLE>, RIGHTID> Map<Column<RIGHTTABLE, ?>, String> giveMapKeyColumnNames(AccessorDefinition var1, Class var2, PrimaryKey<RIGHTTABLE, RIGHTID> var3, Set<String> var4);

    public static class DefaultMapEntryTableNamingStrategy
    implements MapEntryTableNamingStrategy {
        @Override
        public String giveTableName(AccessorDefinition accessorDefinition, Class<?> keyType, Class<?> valueType) {
            String suffix = (String)Reflections.onJavaBeanPropertyWrapperNameGeneric((String)accessorDefinition.getName(), (Object)accessorDefinition.getName(), Reflections.GET_SET_PREFIX_REMOVER.andThen(Strings::uncapitalize), Reflections.GET_SET_PREFIX_REMOVER.andThen(Strings::uncapitalize), Reflections.IS_PREFIX_REMOVER.andThen(Strings::uncapitalize), methodName -> methodName);
            return accessorDefinition.getDeclaringClass().getSimpleName() + "_" + suffix;
        }

        @Override
        public <RIGHTTABLE extends Table<RIGHTTABLE>, RIGHTID> Map<Column<RIGHTTABLE, ?>, String> giveMapKeyColumnNames(AccessorDefinition accessorDefinition, Class entityType, PrimaryKey<RIGHTTABLE, RIGHTID> rightPrimaryKey, Set<String> existingColumnNames) {
            HashMap result = new HashMap();
            TreeSet<String> existingColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            existingColumns.addAll(existingColumnNames);
            String rightSideColumnNamePrefix = entityType.getSimpleName();
            rightPrimaryKey.getColumns().forEach(column -> {
                String rightColumnName = Strings.uncapitalize((CharSequence)(rightSideColumnNamePrefix + "_" + column.getName()));
                if (existingColumns.contains(rightColumnName)) {
                    throw new MappingConfigurationException("Identical column names in association table of collection " + accessorDefinition + " : " + rightColumnName);
                }
                result.put((Column)column, rightColumnName);
            });
            return result;
        }
    }
}

