/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.reflection.AbstractReflector;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableProjection;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.EntityFinder;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.LowerCase;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class ProjectionQueryCriteriaSupport<C, I> {
    private final EntityFinder<C, I> entityFinder;
    private final EntityCriteriaSupport<C> entityCriteriaSupport;
    private final ProjectionQueryPageSupport<C> queryPageSupport;
    private final Consumer<Select> selectAdapter;

    public ProjectionQueryCriteriaSupport(EntityFinder<C, I> entityFinder, Consumer<Select> selectAdapter) {
        this(entityFinder, entityFinder.newCriteriaSupport().getEntityCriteriaSupport(), new ProjectionQueryPageSupport(), selectAdapter);
    }

    public ProjectionQueryCriteriaSupport(EntityFinder<C, I> entityFinder, EntityCriteriaSupport<C> entityCriteriaSupport, Consumer<Select> selectAdapter) {
        this(entityFinder, entityCriteriaSupport, new ProjectionQueryPageSupport(), selectAdapter);
    }

    public ProjectionQueryCriteriaSupport(EntityFinder<C, I> entityFinder, EntityCriteriaSupport<C> entityCriteriaSupport, ProjectionQueryPageSupport<C> queryPageSupport, Consumer<Select> selectAdapter) {
        this.entityFinder = entityFinder;
        this.entityCriteriaSupport = entityCriteriaSupport;
        this.queryPageSupport = queryPageSupport;
        this.selectAdapter = selectAdapter;
    }

    public ProjectionQueryCriteriaSupport<C, I> copyFor(ProjectionQueryPageSupport<C> otherPageSupport) {
        return new ProjectionQueryCriteriaSupport<C, I>(this.entityFinder, this.entityCriteriaSupport, ((ProjectionQueryPageSupport)this.queryPageSupport).merge((ProjectionQueryPageSupport)otherPageSupport), this.selectAdapter);
    }

    public EntityCriteriaSupport<C> getEntityCriteriaSupport() {
        return this.entityCriteriaSupport;
    }

    public ProjectionQueryPageSupport<C> getQueryPageSupport() {
        return this.queryPageSupport;
    }

    public EntityPersister.ExecutableProjectionQuery<C, ?> wrapIntoExecutable() {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        return (EntityPersister.ExecutableProjectionQuery)methodDispatcher.redirect(ExecutableProjection::execute, this.wrapProjectionLoad(this.selectAdapter, this.entityCriteriaSupport)).redirect(EntityPersister.OrderByChain.class, this.queryPageSupport).redirect(EntityPersister.LimitAware.class, this.queryPageSupport).redirect(ExecutableProjection::distinct, this.queryPageSupport::distinct).redirect(EntityPersister.EntityCriteria.class, this.entityCriteriaSupport, true).build(EntityPersister.ExecutableProjectionQuery.class);
    }

    private <R> Function<Accumulator<? super Function<? extends Selectable, Object>, Object, R>, R> wrapProjectionLoad(Consumer<Select> selectAdapter, EntityCriteriaSupport<C> localCriteriaSupport) {
        return accumulator -> {
            OrderBy orderBy = new OrderBy();
            this.queryPageSupport.getOrderBy().forEach(duo -> {
                LowerCase column = this.entityCriteriaSupport.getAggregateColumnMapping().giveColumn(duo.getProperty());
                orderBy.add((Selectable)(duo.isIgnoreCase() ? Operators.lowerCase(column) : column), duo.getDirection() == EntityPersister.OrderByChain.Order.ASC ? OrderByChain.Order.ASC : OrderByChain.Order.DESC);
            });
            return this.entityFinder.selectProjection(selectAdapter, accumulator, localCriteriaSupport, this.queryPageSupport.isDistinct(), orderBy, this.queryPageSupport.getLimit());
        };
    }

    public static class ProjectionQueryPageSupport<C>
    implements EntityPersister.OrderByChain<C, ProjectionQueryPageSupport<C>>,
    EntityPersister.LimitAware<ProjectionQueryPageSupport<C>> {
        private boolean distinct;
        private Limit limit;
        private final KeepOrderSet<OrderByItem> orderBy = new KeepOrderSet();

        public boolean isDistinct() {
            return this.distinct;
        }

        void distinct() {
            this.distinct = true;
        }

        public Limit getLimit() {
            return this.limit;
        }

        public KeepOrderSet<OrderByItem> getOrderBy() {
            return this.orderBy;
        }

        public ProjectionQueryPageSupport<C> limit(int count) {
            this.limit = new Limit(Integer.valueOf(count));
            return this;
        }

        public ProjectionQueryPageSupport<C> limit(int count, Integer offset) {
            this.limit = new Limit(Integer.valueOf(count), offset);
            return this;
        }

        public ProjectionQueryPageSupport<C> orderBy(SerializableFunction<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new OrderByItem(Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), order, false));
            return this;
        }

        public ProjectionQueryPageSupport<C> orderBy(SerializableBiConsumer<C, ?> setter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new OrderByItem(Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), order, false));
            return this;
        }

        public ProjectionQueryPageSupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order) {
            this.orderBy.add((Object)new OrderByItem(getter.getAccessors(), order, false));
            return this;
        }

        public ProjectionQueryPageSupport<C> orderBy(AccessorChain<C, ?> getter, EntityPersister.OrderByChain.Order order, boolean ignoreCase) {
            this.orderBy.add((Object)new OrderByItem(getter.getAccessors(), order, ignoreCase));
            getter.getAccessors().forEach(accessor -> this.assertAccessorIsNotIterable((ValueAccessPoint)accessor, AccessorDefinition.giveDefinition((ValueAccessPoint)accessor).getMemberType()));
            return this;
        }

        private void assertAccessorIsNotIterable(ValueAccessPoint valueAccessPoint, Class memberType) {
            if (Iterable.class.isAssignableFrom(memberType)) {
                throw new IllegalArgumentException("OrderBy clause on a Collection property is unsupported due to eventual inconsistency with Collection nature : " + (valueAccessPoint instanceof AbstractReflector ? ((AbstractReflector)valueAccessPoint).getDescription() : AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint)).toString());
            }
        }

        private ProjectionQueryPageSupport<C> merge(ProjectionQueryPageSupport<C> other) {
            ProjectionQueryPageSupport<C> duplicate = new ProjectionQueryPageSupport<C>();
            if (this.getLimit() != null) {
                duplicate.limit(this.getLimit().getCount(), this.getLimit().getOffset());
            }
            duplicate.orderBy.addAll(this.orderBy);
            if (other.getLimit() != null) {
                duplicate.limit(other.getLimit().getCount(), other.getLimit().getOffset());
            }
            duplicate.orderBy.addAll(other.orderBy);
            return duplicate;
        }

        public static class OrderByItem {
            private final List<? extends ValueAccessPoint<?>> property;
            private final EntityPersister.OrderByChain.Order direction;
            private final boolean ignoreCase;

            public OrderByItem(List<? extends ValueAccessPoint<?>> property, EntityPersister.OrderByChain.Order direction, boolean ignoreCase) {
                this.property = property;
                this.direction = direction;
                this.ignoreCase = ignoreCase;
            }

            public List<? extends ValueAccessPoint<?>> getProperty() {
                return this.property;
            }

            public EntityPersister.OrderByChain.Order getDirection() {
                return this.direction;
            }

            public boolean isIgnoreCase() {
                return this.ignoreCase;
            }
        }
    }
}

