/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.tableperclass;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphicEntityFinder;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.TablePerClassRootJoinNode;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.GroupBy;
import org.codefilarete.stalactite.query.model.Having;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.KeepOrderMap;

public class TablePerClassPolymorphismEntityFinder<C, I, T extends Table<T>>
extends AbstractPolymorphicEntityFinder<C, I, T> {
    @VisibleForTesting
    static final String DISCRIMINATOR_ALIAS = "DISCRIMINATOR";
    private static final Selectable.SimpleSelectable<String> DISCRIMINATOR_COLUMN = new Selectable.SimpleSelectable("DISCRIMINATOR", String.class);
    private final ConfiguredRelationalPersister<C, I> mainPersister;
    private final IdentifierAssembler<I, T> identifierAssembler;
    private final T mainTable;
    private final Map<String, Class> discriminatorValues;
    private final SingleLoadEntityJoinTree<C, I> singleLoadEntityJoinTree;
    private final EntityCriteriaSupport<C> criteriaSupport;
    private Query query;
    private EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery;

    public TablePerClassPolymorphismEntityFinder(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, ConnectionProvider connectionProvider, Dialect dialect) {
        super(mainPersister, persisterPerSubclass, connectionProvider, dialect);
        this.mainPersister = mainPersister;
        this.identifierAssembler = mainPersister.getMapping().getIdMapping().getIdentifierAssembler();
        this.mainTable = mainPersister.getMainTable();
        this.discriminatorValues = new HashMap<String, Class>();
        persisterPerSubclass.forEach((subEntityType, subEntityTable) -> this.discriminatorValues.put(subEntityType.getSimpleName(), (Class)subEntityType));
        this.singleLoadEntityJoinTree = this.buildSingleLoadEntityJoinTree();
        this.criteriaSupport = new EntityCriteriaSupport<C>(this.singleLoadEntityJoinTree);
        PersisterBuilderContext.CURRENT.get().addBuildLifeCycleListener(new PersisterBuilderImpl.BuildLifeCycleListener(){

            @Override
            public void afterBuild() {
            }

            @Override
            public void afterAllBuild() {
                TablePerClassPolymorphismEntityFinder.this.buildQuery();
            }
        });
    }

    private void buildQuery() {
        this.entityTreeQuery = new EntityTreeQueryBuilder<C>(this.singleLoadEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        this.query = this.entityTreeQuery.getQuery();
    }

    @Override
    protected EntityTreeQueryBuilder.EntityTreeQuery<C> getAggregateQueryTemplate() {
        return this.entityTreeQuery;
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.singleLoadEntityJoinTree;
    }

    @Override
    public EntityQueryCriteriaSupport<C, I> newCriteriaSupport() {
        return new EntityQueryCriteriaSupport(this, this.criteriaSupport.copy());
    }

    private SingleLoadEntityJoinTree<C, I> buildSingleLoadEntityJoinTree() {
        Union union = new Union(new Query[0]);
        Set allColumnsInHierarchy = this.mainPersister.getMainTable().getColumns();
        HashMap discriminatorPerSubPersister = new HashMap();
        this.persisterPerSubclass.forEach((subEntityType, subEntityPersister) -> {
            String discriminatorValue = subEntityType.getSimpleName();
            subEntityPersister.getMainTable().getColumns();
            KeepOrderMap subQueryColumns = new KeepOrderMap();
            allColumnsInHierarchy.forEach(arg_0 -> TablePerClassPolymorphismEntityFinder.lambda$null$1(subEntityPersister, (Map)subQueryColumns, arg_0));
            subQueryColumns.put(new Selectable.SimpleSelectable("'" + discriminatorValue + "'", String.class), DISCRIMINATOR_ALIAS);
            Query subQuery = (Query)QueryEase.select((Map)subQueryColumns).from(subEntityPersister.getMainTable()).getQuery();
            union.getQueries().add((Object)subQuery);
            discriminatorPerSubPersister.put(discriminatorValue, subEntityPersister);
        });
        allColumnsInHierarchy.forEach(column -> union.registerColumn(column.getExpression(), column.getJavaType(), column.getName()));
        union.registerColumn(DISCRIMINATOR_COLUMN.getExpression(), String.class, DISCRIMINATOR_ALIAS);
        QueryStatement.PseudoTable pseudoTable = union.asPseudoTable(this.mainTable.getName());
        SingleLoadEntityJoinTree<C, I> result = new SingleLoadEntityJoinTree<C, I>(this.mainPersister, discriminatorPerSubPersister, pseudoTable, DISCRIMINATOR_COLUMN);
        this.mainEntityJoinTree.projectTo(result, "ROOT");
        this.addTablePerClassPolymorphicSubPersistersJoins(result, discriminatorPerSubPersister);
        return result;
    }

    private <V extends C, T1 extends Table<T1>, T2 extends Table<T2>> void addTablePerClassPolymorphicSubPersistersJoins(SingleLoadEntityJoinTree<C, I> entityJoinTree, Map<String, ConfiguredRelationalPersister<C, I>> discriminatorPerSubPersister) {
        discriminatorPerSubPersister.forEach((discriminatorValue, subPersister) -> {
            ConfiguredRelationalPersister localSubPersister = subPersister;
            String mergeJoinName = entityJoinTree.addMergeJoin("ROOT", new EntityMerger.EntityMergerAdapter(localSubPersister.getMapping()), this.mainPersister.getMainTable().getPrimaryKey(), subPersister.getMainTable().getPrimaryKey(), EntityJoinTree.JoinType.OUTER, joinNode -> {
                MergeJoinNode.MergeJoinRowConsumer joinRowConsumer = new MergeJoinNode.MergeJoinRowConsumer((MergeJoinNode)joinNode, localSubPersister.getMapping().getRowTransformer());
                ((TablePerClassRootJoinNode)entityJoinTree.getRoot()).addSubPersister(subPersister, joinRowConsumer, (String)discriminatorValue);
                return joinRowConsumer;
            });
            subPersister.getEntityJoinTree().projectTo(entityJoinTree, mergeJoinName);
        });
    }

    @Override
    public Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, OrderBy orderBy, Limit limit) {
        this.LOGGER.debug("Finding entities in a single query with criteria {}", (Object)where);
        if (this.hasSubPolymorphicPersister) {
            this.LOGGER.debug("Single query was asked but due to sub-polymorphism the query is made in 2 phases");
            return this.selectIn2Phases(where, orderBy, limit);
        }
        return this.localSelectWithSingleQuery(where, orderBy, limit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<C> localSelectWithSingleQuery(ConfiguredEntityCriteria where, OrderBy orderBy, Limit limit) {
        Query queryClone = new Query(this.query.getSelectDelegate(), this.query.getFromDelegate(), new Where(where.getCriteria()), new GroupBy(), new Having(), orderBy, limit);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone);
        EntityTreeInflater<C> inflater = this.entityTreeQuery.getInflater();
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        try (ReadOperation readOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, this.entityTreeQuery.getSelectParameterBinders(), this.entityTreeQuery.getColumnAliases());
            Set<C> set = inflater.transform(() -> TablePerClassPolymorphismEntityFinder.lambda$localSelectWithSingleQuery$6((Iterator)rowIterator), 50);
            return set;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public Set<C> selectIn2Phases(ConfiguredEntityCriteria where, OrderBy orderBy, Limit limit) {
        this.LOGGER.debug("Finding entities in 2-phases query with criteria {}", (Object)where);
        Query queryClone = new Query(new Select(), this.query.getFromDelegate(), new Where(where.getCriteria()), new GroupBy(), new Having(), orderBy, limit);
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone);
        this.mainTable.getPrimaryKey().getColumns().forEach(pkColumn -> {
            Selectable column = this.mainEntityJoinTree.getRoot().getTable().findColumn(pkColumn.getName());
            queryClone.select(column, pkColumn.getName());
        });
        queryClone.select(DISCRIMINATOR_COLUMN, DISCRIMINATOR_ALIAS);
        HashMap columnReaders = new HashMap();
        queryClone.getColumns().forEach(selectable -> {
            ResultSetReader reader = selectable instanceof Column ? this.dialect.getColumnBinderRegistry().getReader((Object)((Column)selectable)) : this.dialect.getColumnBinderRegistry().getReader(selectable.getJavaType());
            columnReaders.put((Selectable<?>)selectable, (ResultSetReader<?>)reader);
        });
        columnReaders.put((Selectable<?>)DISCRIMINATOR_COLUMN, (ResultSetReader<?>)this.dialect.getColumnBinderRegistry().getBinder(DISCRIMINATOR_COLUMN.getJavaType()));
        Map<Class, Set<I>> idsPerSubtype = this.readIds(sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap()), columnReaders, queryClone.getAliases());
        Set ids = idsPerSubtype.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (this.hasSubPolymorphicPersister) {
            this.LOGGER.debug("Asking sub-polymorphic persisters to load the entities");
            HashSet result = new HashSet();
            idsPerSubtype.forEach((k, v) -> result.addAll(((ConfiguredRelationalPersister)this.persisterPerSubclass.get(k)).select((Iterable)v)));
            return result;
        }
        return this.selectWithSingleQueryWhereIdIn(ids);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<Selectable<?>, ResultSetReader<?>> columnReaders, Map<Selectable<?>, String> aliases) {
        try (ReadOperation closeableOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = closeableOperation.execute();
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, columnReaders, aliases);
            KeepOrderMap idsPerSubclass = new KeepOrderMap();
            rowIterator.forEachRemaining(arg_0 -> this.lambda$readIds$11((Map)idsPerSubclass, arg_0));
            KeepOrderMap keepOrderMap = idsPerSubclass;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$readIds$11(Map idsPerSubclass, ColumnedRow row) {
        String discriminatorValue = (String)row.get(DISCRIMINATOR_COLUMN);
        Class entitySubclass = this.discriminatorValues.get(discriminatorValue.trim());
        idsPerSubclass.computeIfAbsent(entitySubclass, k -> new HashSet()).add(this.identifierAssembler.assemble(row));
    }

    private static /* synthetic */ Iterator lambda$localSelectWithSingleQuery$6(Iterator rowIterator) {
        return rowIterator;
    }

    private static /* synthetic */ void lambda$null$1(ConfiguredRelationalPersister subEntityPersister, Map subQueryColumns, Column pseudoColumn) {
        Column column = subEntityPersister.getMainTable().findColumn(pseudoColumn.getExpression());
        if (column != null) {
            subQueryColumns.put(column, column.getName());
        } else {
            subQueryColumns.put(Operators.cast((String)null, (Class)pseudoColumn.getJavaType()), pseudoColumn.getExpression());
        }
    }

    static class SingleLoadEntityJoinTree<C, I>
    extends EntityJoinTree<C, I> {
        private final IdentityHashMap<Column<?, ?>, Selectable<?>> mainColumnToPseudoColumn = new IdentityHashMap();

        public <T extends Table<T>> SingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Map<String, ConfiguredRelationalPersister<C, I>> subPersisterPerDiscriminator, QueryStatement.PseudoTable pseudoTable, Selectable.SimpleSelectable<String> discriminatorColumn) {
            super((EntityJoinTree<C, I> self) -> new TablePerClassRootJoinNode(self, mainPersister, subPersisterPerDiscriminator, pseudoTable, discriminatorColumn));
            pseudoTable.getColumns().forEach(pseudoColumn -> {
                Column column = mainPersister.getMainTable().findColumn(pseudoColumn.getExpression());
                if (column != null) {
                    this.mainColumnToPseudoColumn.put((Column<?, ?>)column, (Selectable<?>)pseudoColumn);
                }
            });
        }

        public TablePerClassRootJoinNode<C, I> getRoot() {
            return (TablePerClassRootJoinNode)super.getRoot();
        }

        public IdentityHashMap<Column<?, ?>, Selectable<?>> getMainColumnToPseudoColumn() {
            return this.mainColumnToPseudoColumn;
        }
    }
}

