/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.tool.collection.Arrays;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public abstract class AbstractRepositoryQuery
implements RepositoryQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    protected final QueryMethod queryMethod;

    public AbstractRepositoryQuery(QueryMethod queryMethod) {
        this.queryMethod = queryMethod;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected Map<String, Object> getValues(ParametersParameterAccessor accessor) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Parameter bindableParameter : this.queryMethod.getParameters().getBindableParameters()) {
            String parameterName = (String)bindableParameter.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            Object value = accessor.getBindableValue(bindableParameter.getIndex());
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                value = values.length == 1 ? values[0] : Arrays.asList((Object[])values);
            }
            result.put(parameterName, value);
        }
        return result;
    }
}

