/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.model.compositekey;

import java.util.Objects;
import org.codefilarete.stalactite.engine.model.compositekey.Person;

public class Pet {
    private PetId id;
    private Person owner;

    public Pet(PetId id) {
        this.id = id;
    }

    public PetId getId() {
        return this.id;
    }

    public Person getOwner() {
        return this.owner;
    }

    public String toString() {
        return "Pet{id=" + this.id + '}';
    }

    public static enum CatBreed {
        Persian,
        Siamese,
        Maine_Coon;

    }

    public static class Cat
    extends Pet {
        private CatBreed catBreed;

        public Cat(PetId id) {
            super(id);
        }

        public CatBreed getCatBreed() {
            return this.catBreed;
        }

        public Cat setCatBreed(CatBreed catBreed) {
            this.catBreed = catBreed;
            return this;
        }
    }

    public static enum DogBreed {
        Labrador,
        Australian_Shepherd,
        Golden_Retriever;

    }

    public static class Dog
    extends Pet {
        private DogBreed dogBreed;

        public Dog(PetId id) {
            super(id);
        }

        public DogBreed getDogBreed() {
            return this.dogBreed;
        }
    }

    public static class PetId {
        private String name;
        private String race;
        private int age;

        public PetId() {
        }

        public PetId(String name, String race, int age) {
            this.name = name;
            this.race = race;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public String getRace() {
            return this.race;
        }

        public int getAge() {
            return this.age;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PetId petId = (PetId)o;
            return this.age == petId.age && Objects.equals(this.name, petId.name) && Objects.equals(this.race, petId.race);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.race, this.age);
        }

        public String toString() {
            return "PetId{name='" + this.name + '\'' + ", race='" + this.race + '\'' + ", age=" + this.age + '}';
        }
    }
}

