/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetoone;

import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneCycleConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneOwnedBySourceConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneOwnedByTargetConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Iterables;

public class OneToOneRelationConfigurer<C, I> {
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final ConfiguredRelationalPersister<C, I> sourcePersister;
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;

    public OneToOneRelationConfigurer(Dialect dialect, ConnectionConfiguration connectionConfiguration, ConfiguredRelationalPersister<C, I> sourcePersister, JoinColumnNamingStrategy joinColumnNamingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy) {
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.sourcePersister = sourcePersister;
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
    }

    public <TRGT, TRGTID> void configure(OneToOneRelation<C, TRGT, TRGTID> oneToOneRelation) {
        PersisterBuilderContext currentBuilderContext = PersisterBuilderContext.CURRENT.get();
        OneToOneConfigurerTemplate configurer = oneToOneRelation.isRelationOwnedByTarget() ? new OneToOneOwnedByTargetConfigurer(this.sourcePersister, oneToOneRelation, this.joinColumnNamingStrategy, this.foreignKeyNamingStrategy, this.dialect, this.connectionConfiguration) : new OneToOneOwnedBySourceConfigurer(this.sourcePersister, oneToOneRelation, this.joinColumnNamingStrategy, this.foreignKeyNamingStrategy);
        String relationName = AccessorDefinition.giveDefinition(oneToOneRelation.getTargetProvider()).getName();
        EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration = oneToOneRelation.getTargetMappingConfiguration();
        if (currentBuilderContext.isCycling(targetMappingConfiguration)) {
            Class targetEntityType = targetMappingConfiguration.getEntityType();
            OneToOneCycleConfigurer cycleSolver = (OneToOneCycleConfigurer)Iterables.find(currentBuilderContext.getBuildLifeCycleListeners(), p -> p instanceof OneToOneCycleConfigurer && ((OneToOneCycleConfigurer)p).getEntityType() == targetEntityType);
            if (cycleSolver == null) {
                cycleSolver = new OneToOneCycleConfigurer(targetEntityType);
                currentBuilderContext.addBuildLifeCycleListener(cycleSolver);
            }
            cycleSolver.addCycleSolver(relationName, configurer);
        } else {
            Table targetTable = (Table)Nullable.nullable((Object)oneToOneRelation.getTargetTable()).getOr(Nullable.nullable(oneToOneRelation.getReverseColumn()).map(Column::getTable).get());
            ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = new PersisterBuilderImpl<TRGT, TRGTID>(targetMappingConfiguration).build(this.dialect, this.connectionConfiguration, targetTable);
            configurer.configure(relationName, targetPersister, oneToOneRelation.isFetchSeparately());
        }
    }
}

