/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.InMemoryCounterIdentifierGenerator;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.BeanPersister;
import org.codefilarete.stalactite.engine.runtime.RawQuery;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.BeforeInsertIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.Count;
import org.codefilarete.stalactite.query.model.operator.Equals;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.stalactite.test.PairSetList;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.function.Sequence;
import org.codefilarete.tool.trace.MutableInt;
import org.codefilarete.tool.trace.MutableLong;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.hsqldb.jdbc.JDBCArrayBasic;
import org.hsqldb.types.Type;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

class SimpleRelationalEntityPersisterTest {
    private SimpleRelationalEntityPersister<Toto, Identifier<Integer>, ?> testInstance;
    private PreparedStatement preparedStatement;
    private ArgumentCaptor<Integer> valueCaptor;
    private ArgumentCaptor<Integer> indexCaptor;
    private ArgumentCaptor<String> statementArgCaptor;
    private InMemoryCounterIdentifierGenerator identifierGenerator;
    private ClassMapping<Toto, Identifier<Integer>, ?> totoClassMappingStrategy_ontoTable1;
    private DefaultDialect dialect;
    private Key<Table, Identifier<Integer>> leftJoinColumn;
    private Key<Table, Identifier<Integer>> rightJoinColumn;
    private final EffectiveBatchedRowCount effectiveBatchedRowCount = new EffectiveBatchedRowCount();
    private final Hanger.Holder<Long> expectedRowCountForUpdate = new Hanger.Holder();
    private Connection connection;

    SimpleRelationalEntityPersisterTest() {
    }

    protected void initMapping() {
        Field fieldId = Reflections.getField(Toto.class, (String)"id");
        Field fieldA = Reflections.getField(Toto.class, (String)"a");
        Field fieldB = Reflections.getField(Toto.class, (String)"b");
        Field fieldQ = Reflections.getField(Toto.class, (String)"q");
        Table totoClassTable = new Table("Toto");
        this.leftJoinColumn = Key.ofSingleColumn((JoinLink)totoClassTable.addColumn("id", fieldId.getType()));
        totoClassTable.addColumn("a", fieldA.getType());
        totoClassTable.addColumn("b", fieldB.getType());
        totoClassTable.addColumn("q", fieldQ.getType());
        Map columnMap = totoClassTable.mapColumnsOnName();
        ((Column)columnMap.get("id")).setPrimaryKey(true);
        PropertyAccessor identifierAccessor = Accessors.propertyAccessor((Field)fieldId);
        Maps.ChainingMap totoClassMapping = Maps.asMap((Object)identifierAccessor, (Object)((Column)columnMap.get("id"))).add((Object)Accessors.propertyAccessor((Field)fieldA), columnMap.get("a")).add((Object)Accessors.propertyAccessor((Field)fieldB), columnMap.get("b")).add((Object)Accessors.propertyAccessor((Field)fieldQ), columnMap.get("q"));
        this.identifierGenerator = new InMemoryCounterIdentifierGenerator();
        BeforeInsertIdentifierManager beforeInsertIdentifierManager = new BeforeInsertIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor((ReversibleAccessor)identifierAccessor), () -> new PersistableIdentifier<Integer>(this.identifierGenerator.next()), Identifier.class);
        this.totoClassMappingStrategy_ontoTable1 = new ClassMapping(Toto.class, totoClassTable, (Map)totoClassMapping, (ReversibleAccessor)identifierAccessor, (IdentifierInsertionManager)beforeInsertIdentifierManager);
        JavaTypeToSqlTypeMapping simpleTypeMapping = new JavaTypeToSqlTypeMapping();
        simpleTypeMapping.put(Identifier.class, "int");
        this.dialect = new DefaultDialect(simpleTypeMapping);
        this.dialect.setInOperatorMaxSize(3);
        this.dialect.getColumnBinderRegistry().register(Identifier.class, (ParameterBinder)new ParameterBinder<Identifier>(){

            public Class<Identifier> getType() {
                return Identifier.class;
            }

            public Identifier doGet(ResultSet resultSet, String columnName) throws SQLException {
                return new PersistedIdentifier<Object>(resultSet.getObject(columnName));
            }

            public void set(PreparedStatement statement, int valueIndex, Identifier value) throws SQLException {
                statement.setInt(valueIndex, (Integer)value.getDelegate());
            }
        });
        this.dialect.getColumnBinderRegistry().register(Set.class, (ParameterBinder)new ParameterBinder<Set<Integer>>(){

            public void set(PreparedStatement preparedStatement, int valueIndex, Set<Integer> value) throws SQLException {
                if (value != null) {
                    preparedStatement.setArray(valueIndex, (Array)new JDBCArrayBasic((Object[])value.toArray(new Integer[0]), (Type)Type.SQL_INTEGER));
                } else {
                    preparedStatement.setArray(valueIndex, null);
                }
            }

            public Set<Integer> doGet(ResultSet resultSet, String columnName) throws SQLException {
                Array array = resultSet.getArray(columnName);
                return array == null ? null : new KeepOrderSet((Object[])((Integer[])array.getArray()));
            }

            public Class<Set<Integer>> getType() {
                return Set.class;
            }
        });
    }

    protected void initTest() throws SQLException {
        this.identifierGenerator.reset();
        this.preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)this.preparedStatement.executeLargeBatch()).thenAnswer(invocation -> this.effectiveBatchedRowCount.next());
        Mockito.when((Object)this.preparedStatement.executeLargeUpdate()).thenAnswer(invocation -> (Long)this.expectedRowCountForUpdate.get());
        this.connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.preparedStatement.getConnection()).thenReturn((Object)this.connection);
        this.statementArgCaptor = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)this.connection.prepareStatement((String)this.statementArgCaptor.capture())).thenReturn((Object)this.preparedStatement);
        Mockito.when((Object)this.connection.prepareStatement((String)this.statementArgCaptor.capture(), Mockito.anyInt())).thenReturn((Object)this.preparedStatement);
        this.valueCaptor = ArgumentCaptor.forClass(Integer.class);
        this.indexCaptor = ArgumentCaptor.forClass(Integer.class);
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)this.connection);
        this.testInstance = new SimpleRelationalEntityPersister(this.totoClassMappingStrategy_ontoTable1, (Dialect)this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new CurrentThreadConnectionProvider(dataSource), 3));
    }

    void assertCapturedPairsEqual(PairSetList<Integer, Integer> expectedPairs) {
        List obtainedPairs = PairSetList.toPairs((Iterable)this.indexCaptor.getAllValues(), (Iterable)this.valueCaptor.getAllValues());
        ArrayList obtained = new ArrayList();
        int startIndex = 0;
        for (Set expectedPair : expectedPairs.asList()) {
            obtained.add(new HashSet(obtainedPairs.subList(startIndex, startIndex += expectedPair.size())));
        }
        Assertions.assertThat(obtained).isEqualTo((Object)expectedPairs.asList());
    }

    private static class Tata {
        private Integer id;
        private String prop1;

        private Tata() {
        }

        public Integer getId() {
            return this.id;
        }

        public String getProp1() {
            return this.prop1;
        }
    }

    private static class Toto
    implements Identified<Integer> {
        private Identifier<Integer> id;
        private Integer a;
        private Integer b;
        private Integer x;
        private Integer y;
        private Integer z;
        private Set<Integer> q;
        private Tata tata;

        public Toto() {
        }

        public Toto(int id, Integer a, Integer b) {
            this(id, a, b, null, null, null);
        }

        public Toto(int id, Integer a, Integer b, Integer x, Integer y, Integer z) {
            this.id = new PersistableIdentifier<Integer>(id);
            this.a = a;
            this.b = b;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Toto(Integer a, Integer b, Integer x, Integer y, Integer z) {
            this.a = a;
            this.b = b;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public Identifier<Integer> getId() {
            return this.id;
        }

        public Integer getA() {
            return this.a;
        }

        public void setQ(Set<Integer> q) {
            this.q = q;
        }

        public Set<Integer> getQ() {
            return this.q;
        }

        void merge(Toto another) {
            this.x = another.x;
            this.y = another.y;
            this.z = another.z;
        }

        public Tata getTata() {
            return this.tata;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + Maps.asMap((Object)"id", this.id.getDelegate()).add((Object)"a", (Object)this.a).add((Object)"b", (Object)this.b).add((Object)"x", (Object)this.x).add((Object)"y", (Object)this.y).add((Object)"z", (Object)this.z) + "]";
        }
    }

    @Nested
    class CRUD_WithListener {
        private ClassMapping<Toto, Identifier<Integer>, ?> totoClassMappingStrategy;
        private BeanPersister<Toto, Identifier<Integer>, ?> persister;

        CRUD_WithListener() {
        }

        @BeforeEach
        void setUp() throws SQLException {
            PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class)));
            this.initMapping();
            this.initTest();
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(PersisterBuilderImpl.BuildLifeCycleListener::afterBuild);
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(PersisterBuilderImpl.BuildLifeCycleListener::afterAllBuild);
        }

        @AfterEach
        void removeEntityCandidates() {
            PersisterBuilderContext.CURRENT.remove();
        }

        void initMapping() {
            SimpleRelationalEntityPersisterTest.this.initMapping();
            Field fieldId = Reflections.getField(Toto.class, (String)"id");
            Field fieldX = Reflections.getField(Toto.class, (String)"x");
            Field fieldY = Reflections.getField(Toto.class, (String)"y");
            Field fieldZ = Reflections.getField(Toto.class, (String)"z");
            Table totoClassTable = new Table("Toto2");
            SimpleRelationalEntityPersisterTest.this.rightJoinColumn = Key.ofSingleColumn((JoinLink)totoClassTable.addColumn("id", fieldId.getType()));
            totoClassTable.addColumn("x", fieldX.getType());
            totoClassTable.addColumn("y", fieldY.getType());
            totoClassTable.addColumn("z", fieldZ.getType());
            Map columnMap2 = totoClassTable.mapColumnsOnName();
            ((Column)columnMap2.get("id")).setPrimaryKey(true);
            PropertyAccessor identifierAccessor = Accessors.propertyAccessor((Field)fieldId);
            Maps.ChainingMap totoClassMapping2 = Maps.asMap((Object)identifierAccessor, (Object)((Column)columnMap2.get("id"))).add((Object)Accessors.propertyAccessor((Field)fieldX), columnMap2.get("x")).add((Object)Accessors.propertyAccessor((Field)fieldY), columnMap2.get("y")).add((Object)Accessors.propertyAccessor((Field)fieldZ), columnMap2.get("z"));
            AlreadyAssignedIdentifierManager identifierManager = new AlreadyAssignedIdentifierManager(Identifier.class, c -> c.getId().setPersisted(), c -> c.getId().isPersisted());
            this.totoClassMappingStrategy = new ClassMapping(Toto.class, totoClassTable, (Map)totoClassMapping2, (ReversibleAccessor)identifierAccessor, (IdentifierInsertionManager)identifierManager);
        }

        protected void initTest() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.initTest();
            this.persister = new BeanPersister(this.totoClassMappingStrategy, (Dialect)SimpleRelationalEntityPersisterTest.this.dialect, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(() -> SimpleRelationalEntityPersisterTest.this.connection, 3));
            SimpleRelationalEntityPersisterTest.this.testInstance.getEntityJoinTree().addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter(this.persister.getMapping()), (Accessor)Accessors.accessorByMethodReference(Toto::getId), SimpleRelationalEntityPersisterTest.this.leftJoinColumn, SimpleRelationalEntityPersisterTest.this.rightJoinColumn, null, EntityJoinTree.JoinType.INNER, Toto::merge, Collections.emptySet());
            SimpleRelationalEntityPersisterTest.this.testInstance.getPersisterListener().addInsertListener((InsertListener)new InsertListener<Toto>(){

                public void afterInsert(Iterable<? extends Toto> entities) {
                    CRUD_WithListener.this.persister.insert(entities);
                }
            });
            SimpleRelationalEntityPersisterTest.this.testInstance.getPersisterListener().addUpdateListener((UpdateListener)new UpdateListener<Toto>(){

                public void afterUpdate(Iterable<? extends Duo<Toto, Toto>> entities, boolean allColumnsStatement) {
                    CRUD_WithListener.this.persister.update(entities, allColumnsStatement);
                }
            });
            SimpleRelationalEntityPersisterTest.this.testInstance.getPersisterListener().addUpdateByIdListener((UpdateByIdListener)new UpdateByIdListener<Toto>(){

                public void afterUpdateById(Iterable<? extends Toto> entities) {
                    CRUD_WithListener.this.persister.updateById(entities);
                }
            });
            SimpleRelationalEntityPersisterTest.this.testInstance.getPersisterListener().addDeleteListener((DeleteListener)new DeleteListener<Toto>(){

                public void beforeDelete(Iterable<? extends Toto> entities) {
                    CRUD_WithListener.this.persister.delete(entities);
                }
            });
            SimpleRelationalEntityPersisterTest.this.testInstance.getPersisterListener().addDeleteByIdListener((DeleteByIdListener)new DeleteByIdListener<Toto>(){

                public void beforeDeleteById(Iterable<? extends Toto> entities) {
                    CRUD_WithListener.this.persister.deleteById(entities);
                }
            });
        }

        @Test
        void insert() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{1L, 1L, 1L}, {1L}, {1L, 1L, 1L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.insert((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(17, 23, 117, 123, -117), new Toto(29, 31, 129, 131, -129), new Toto(37, 41, 137, 141, -137), new Toto(43, 53, 143, 153, -143)}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)28))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"insert into Toto(id, a, b, q) values (?, ?, ?, ?)", "insert into Toto2(id, x, y, z) values (?, ?, ?, ?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)17).add((Object)3, (Object)23).newRow((Object)1, (Object)2).add((Object)2, (Object)29).add((Object)3, (Object)31).newRow((Object)1, (Object)3).add((Object)2, (Object)37).add((Object)3, (Object)41).newRow((Object)1, (Object)4).add((Object)2, (Object)43).add((Object)3, (Object)53).newRow((Object)1, (Object)1).add((Object)2, (Object)117).add((Object)3, (Object)123).add((Object)4, (Object)-117).newRow((Object)1, (Object)2).add((Object)2, (Object)129).add((Object)3, (Object)131).add((Object)4, (Object)-129).newRow((Object)1, (Object)3).add((Object)2, (Object)137).add((Object)3, (Object)141).add((Object)4, (Object)-137).newRow((Object)1, (Object)4).add((Object)2, (Object)143).add((Object)3, (Object)153).add((Object)4, (Object)-143);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void update() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoQAlias = "Toto_q";
            String toto2IdAlias = "Toto2_id";
            String toto2XAlias = "Toto2_x";
            String toto2YAlias = "Toto2_y";
            String toto2ZAlias = "Toto2_z";
            InMemoryResultSet resultSetMock = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)7).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)toto2IdAlias, (Object)3).add((Object)toto2XAlias, (Object)4).add((Object)toto2YAlias, (Object)5).add((Object)toto2ZAlias, (Object)6), Maps.asMap((Object)totoIdAlias, (Object)13).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)toto2IdAlias, (Object)3).add((Object)toto2XAlias, (Object)4).add((Object)toto2YAlias, (Object)5).add((Object)toto2ZAlias, (Object)6), Maps.asMap((Object)totoIdAlias, (Object)17).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)toto2IdAlias, (Object)3).add((Object)toto2XAlias, (Object)4).add((Object)toto2YAlias, (Object)5).add((Object)toto2ZAlias, (Object)6), Maps.asMap((Object)totoIdAlias, (Object)23).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)toto2IdAlias, (Object)3).add((Object)toto2XAlias, (Object)4).add((Object)toto2YAlias, (Object)5).add((Object)toto2ZAlias, (Object)6)}));
            Mockito.when((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}, {1L}, {3L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.update((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(7, 17, 23, 117, 123, -117), new Toto(13, 29, 31, 129, 131, -129), new Toto(17, 37, 41, 137, 141, -137), new Toto(23, 43, 53, 143, 153, -143)}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)32))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).executeLargeBatch();
            Assertions.assertThat(new RawQuery((String)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues().get(0)).getColumns()).containsExactlyInAnyOrder((Object[])new String[]{"Toto.id as " + totoIdAlias, "Toto.a as " + totoAAlias, "Toto.b as " + totoBAlias, "Toto.q as " + totoQAlias, "Toto2.z as " + toto2ZAlias, "Toto2.x as " + toto2XAlias, "Toto2.y as " + toto2YAlias, "Toto2.id as " + toto2IdAlias});
            Assertions.assertThat((String)new RawQuery((String)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues().get(0)).getFrom()).isEqualTo("Toto inner join Toto2 as Toto2 on Toto.id = Toto2.id where Toto.id in (?, ?, ?)");
            Assertions.assertThat(new RawQuery((String)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues().get(1)).getColumns()).containsExactlyInAnyOrder((Object[])new String[]{"Toto.id as " + totoIdAlias, "Toto.a as " + totoAAlias, "Toto.b as " + totoBAlias, "Toto.q as " + totoQAlias, "Toto2.z as " + toto2ZAlias, "Toto2.x as " + toto2XAlias, "Toto2.y as " + toto2YAlias, "Toto2.id as " + toto2IdAlias});
            Assertions.assertThat((String)new RawQuery((String)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues().get(1)).getFrom()).isEqualTo("Toto inner join Toto2 as Toto2 on Toto.id = Toto2.id where Toto.id in (?)");
            Assertions.assertThat(SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues().subList(2, 4)).isEqualTo((Object)Arrays.asList((Object[])new String[]{"update Toto set a = ?, b = ?, q = ? where id = ?", "update Toto2 set x = ?, y = ?, z = ? where id = ?"}));
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).hasSize(4);
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7).add((Object)2, (Object)13).add((Object)3, (Object)17).add((Object)1, (Object)23);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void updateById() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}, {1L}, {3L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.updateById((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(1, 17, 23, 117, 123, -117), new Toto(2, 29, 31, 129, 131, -129), new Toto(3, 37, 41, 137, 141, -137), new Toto(4, 43, 53, 143, 153, -143)}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)28))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"update Toto set a = ?, b = ?, q = ? where id = ?", "update Toto2 set x = ?, y = ?, z = ? where id = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)17).add((Object)2, (Object)23).add((Object)4, (Object)1).newRow((Object)1, (Object)29).add((Object)2, (Object)31).add((Object)4, (Object)2).newRow((Object)1, (Object)37).add((Object)2, (Object)41).add((Object)4, (Object)3).newRow((Object)1, (Object)43).add((Object)2, (Object)53).add((Object)4, (Object)4).newRow((Object)1, (Object)117).add((Object)2, (Object)123).add((Object)3, (Object)-117).add((Object)4, (Object)1).newRow((Object)1, (Object)129).add((Object)2, (Object)131).add((Object)3, (Object)-129).add((Object)4, (Object)2).newRow((Object)1, (Object)137).add((Object)2, (Object)141).add((Object)3, (Object)-137).add((Object)4, (Object)3).newRow((Object)1, (Object)143).add((Object)2, (Object)153).add((Object)3, (Object)-143).add((Object)4, (Object)4);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void delete() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{1L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.delete((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(7, 17, 23, 117, 123, -117)}));
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto2 where id = ?", "delete from Toto where id = ?"}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7).newRow((Object)1, (Object)7);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void delete_multiple() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}, {1L}, {3L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.delete((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(1, 17, 23, 117, 123, -117), new Toto(2, 29, 31, 129, 131, -129), new Toto(3, 37, 41, 137, 141, -137), new Toto(4, 43, 53, 143, 153, -143)}));
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto2 where id = ?", "delete from Toto where id = ?"}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)1, (Object)2).add((Object)1, (Object)3).newRow((Object)1, (Object)4).newRow((Object)1, (Object)1).add((Object)1, (Object)2).add((Object)1, (Object)3).newRow((Object)1, (Object)4);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void deleteById() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.expectedRowCountForUpdate.set((Object)1L);
            SimpleRelationalEntityPersisterTest.this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(7, 17, 23, 117, 123, -117)}));
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto2 where id in (?)", "delete from Toto where id in (?)"}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void deleteById_multiple() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}, {3L}, {1L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.expectedRowCountForUpdate.set((Object)1L);
            SimpleRelationalEntityPersisterTest.this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(1, 17, 23, 117, 123, -117), new Toto(2, 29, 31, 129, 131, -129), new Toto(3, 37, 41, 137, 141, -137), new Toto(4, 43, 53, 143, 153, -143)}));
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto2 where id in (?, ?, ?)", "delete from Toto2 where id in (?)", "delete from Toto where id in (?, ?, ?)", "delete from Toto where id in (?)"}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)8))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)2).add((Object)3, (Object)3).newRow((Object)1, (Object)4).newRow((Object)1, (Object)1).add((Object)2, (Object)2).add((Object)3, (Object)3).newRow((Object)1, (Object)4);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void select() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoQAlias = "Toto_q";
            String toto2IdAlias = "Toto2_id";
            String toto2XAlias = "Toto2_x";
            String toto2YAlias = "Toto2_y";
            String toto2ZAlias = "Toto2_z";
            InMemoryResultSet resultSetMock = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)7).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)toto2IdAlias, (Object)3).add((Object)toto2XAlias, (Object)4).add((Object)toto2YAlias, (Object)5).add((Object)toto2ZAlias, (Object)6), Maps.asMap((Object)totoIdAlias, (Object)13).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)toto2IdAlias, (Object)3).add((Object)toto2XAlias, (Object)4).add((Object)toto2YAlias, (Object)5).add((Object)toto2ZAlias, (Object)6), Maps.asMap((Object)totoIdAlias, (Object)17).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)toto2IdAlias, (Object)3).add((Object)toto2XAlias, (Object)4).add((Object)toto2YAlias, (Object)5).add((Object)toto2ZAlias, (Object)6), Maps.asMap((Object)totoIdAlias, (Object)23).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2).add((Object)toto2IdAlias, (Object)3).add((Object)toto2XAlias, (Object)4).add((Object)toto2YAlias, (Object)5).add((Object)toto2ZAlias, (Object)6)}));
            Mockito.when((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
            Set select = SimpleRelationalEntityPersisterTest.this.testInstance.select((Iterable)Arrays.asList((Object[])new Identifier[]{new PersistableIdentifier<Integer>(7), new PersistableIdentifier<Integer>(13), new PersistableIdentifier<Integer>(17), new PersistableIdentifier<Integer>(23)}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat(new RawQuery((String)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues().get(0)).getColumns()).containsExactlyInAnyOrder((Object[])new String[]{"Toto.id as " + totoIdAlias, "Toto.a as " + totoAAlias, "Toto.b as " + totoBAlias, "Toto.q as " + totoQAlias, "Toto2.z as " + toto2ZAlias, "Toto2.x as " + toto2XAlias, "Toto2.y as " + toto2YAlias, "Toto2.id as " + toto2IdAlias});
            Assertions.assertThat((String)new RawQuery((String)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues().get(0)).getFrom()).isEqualTo("Toto inner join Toto2 as Toto2 on Toto.id = Toto2.id where Toto.id in (?, ?, ?)");
            Assertions.assertThat(new RawQuery((String)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues().get(1)).getColumns()).containsExactlyInAnyOrder((Object[])new String[]{"Toto.id as " + totoIdAlias, "Toto.a as " + totoAAlias, "Toto.b as " + totoBAlias, "Toto.q as " + totoQAlias, "Toto2.z as " + toto2ZAlias, "Toto2.x as " + toto2XAlias, "Toto2.y as " + toto2YAlias, "Toto2.id as " + toto2IdAlias});
            Assertions.assertThat((String)new RawQuery((String)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues().get(1)).getFrom()).isEqualTo("Toto inner join Toto2 as Toto2 on Toto.id = Toto2.id where Toto.id in (?)");
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).hasSize(2);
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7).add((Object)2, (Object)13).add((Object)3, (Object)17).add((Object)1, (Object)23);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            Comparator<Toto> totoComparator = Comparator.comparing(toto -> (Integer)toto.getId().getDelegate());
            Assertions.assertThat((String)Arrays.asTreeSet(totoComparator, (Collection)select).toString()).isEqualTo(Arrays.asTreeSet(totoComparator, (Object[])new Toto[]{new Toto(7, 1, 2, 4, 5, 6), new Toto(13, 1, 2, 4, 5, 6), new Toto(17, 1, 2, 4, 5, 6), new Toto(23, 1, 2, 4, 5, 6)}).toString());
        }
    }

    @Nested
    class LoadProjectionByEntityCriteria {
        LoadProjectionByEntityCriteria() {
        }

        @BeforeEach
        void setUp() throws SQLException {
            PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class)));
            SimpleRelationalEntityPersisterTest.this.initMapping();
            SimpleRelationalEntityPersisterTest.this.initTest();
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(PersisterBuilderImpl.BuildLifeCycleListener::afterBuild);
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(PersisterBuilderImpl.BuildLifeCycleListener::afterAllBuild);
        }

        @AfterEach
        void removeEntityCandidates() {
            PersisterBuilderContext.CURRENT.remove();
        }

        @Test
        void selectProjectionWhere() throws SQLException {
            InMemoryResultSet resultSet = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"count", (Object)42L)}));
            Mockito.when((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement.executeQuery()).thenAnswer(arg_0 -> LoadProjectionByEntityCriteria.lambda$selectProjectionWhere$0((ResultSet)resultSet, arg_0));
            final Count count = Operators.count((Selectable[])new Selectable[]{new Selectable.SimpleSelectable("id", Integer.class)});
            EntityPersister.ExecutableProjectionQuery totoRelationalExecutableEntityQuery = SimpleRelationalEntityPersisterTest.this.testInstance.selectProjectionWhere(select -> {
                select.clear();
                select.add((Selectable)count, "count");
            }, Toto::getA, (ConditionalOperator)Operators.eq((Object)77));
            long countValue = (Long)totoRelationalExecutableEntityQuery.execute((Accumulator)new Accumulator<Function<Selectable<Long>, Long>, MutableLong, Long>(){

                public Supplier<MutableLong> supplier() {
                    return MutableLong::new;
                }

                public BiConsumer<MutableLong, Function<Selectable<Long>, Long>> aggregator() {
                    return (modifiableInt, selectableObjectFunction) -> {
                        Long apply = (Long)selectableObjectFunction.apply(count);
                        modifiableInt.reset(apply.longValue());
                    };
                }

                public Function<MutableLong, Long> finisher() {
                    return MutableLong::getValue;
                }
            });
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select count(id) as count from Toto where Toto.a = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)77);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            Assertions.assertThat((long)countValue).isEqualTo(42L);
        }

        private static /* synthetic */ ResultSet lambda$selectProjectionWhere$0(ResultSet resultSet, InvocationOnMock invocation) throws Throwable {
            return resultSet;
        }
    }

    @Nested
    class LoadByEntityCriteria {
        LoadByEntityCriteria() {
        }

        @Test
        void checkSQLGeneration() throws SQLException {
            PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            Connection connection = (Connection)Mockito.mock(Connection.class);
            ArgumentCaptor sqlCaptor = ArgumentCaptor.forClass(String.class);
            ArgumentCaptor argCaptor = ArgumentCaptor.forClass(Integer.class);
            Mockito.when((Object)connection.prepareStatement((String)sqlCaptor.capture())).thenReturn((Object)preparedStatement);
            ((PreparedStatement)Mockito.doNothing().when((Object)preparedStatement)).setInt(Mockito.anyInt(), (Integer)argCaptor.capture());
            DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
            Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)connection);
            Mockito.when((Object)preparedStatement.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterator)new PairIterator.EmptyIterator()));
            PersistenceContext persistenceContext = new PersistenceContext(dataSource, HSQLDBDialectBuilder.defaultHSQLDBDialect());
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions mappingConfiguration = MappingEase.entityBuilder(Tata.class, Integer.class).mapKey(Tata::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(tata -> {}, tata -> false)).map(Tata::getProp1);
            EntityPersister totoPersister = MappingEase.entityBuilder(Toto.class, Integer.class).mapKey(Toto::getA, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(toto -> {}, toto -> false)).mapOneToOne(Toto::getTata, (EntityMappingConfigurationProvider)mappingConfiguration).build(persistenceContext);
            SerializableFunction & Serializable getTata = Toto::getTata;
            SerializableFunction & Serializable getProp1 = Tata::getProp1;
            Equals dummy = Operators.eq((Object)"dummy");
            EntityPersister.ExecutableEntityQuery totoRelationalExecutableEntityQuery = (EntityPersister.ExecutableEntityQuery)totoPersister.selectWhere(Toto::getA, (ConditionalOperator)Operators.eq((Object)42)).and((SerializableFunction)getTata, (SerializableFunction)getProp1, (ConditionalOperator)dummy);
            totoRelationalExecutableEntityQuery.execute(Accumulators.toSet());
            Assertions.assertThat((String)((String)sqlCaptor.getValue())).isEqualTo("select Toto.a as Toto_a, tata.prop1 as tata_prop1, tata.id as tata_id from Toto left outer join Tata as tata on Toto.tataId = tata.id where Toto.a = ? and tata.prop1 = ?");
            Assertions.assertThat((Integer)((Integer)argCaptor.getValue())).isEqualTo(42);
        }
    }

    @Nested
    class CRUD {
        CRUD() {
        }

        @BeforeEach
        void setUp() throws SQLException {
            PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class)));
            SimpleRelationalEntityPersisterTest.this.initMapping();
            SimpleRelationalEntityPersisterTest.this.initTest();
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(PersisterBuilderImpl.BuildLifeCycleListener::afterBuild);
            ((PersisterBuilderContext)PersisterBuilderContext.CURRENT.get()).getBuildLifeCycleListeners().forEach(PersisterBuilderImpl.BuildLifeCycleListener::afterAllBuild);
        }

        @AfterEach
        void removeEntityCandidates() {
            PersisterBuilderContext.CURRENT.remove();
        }

        @Test
        void insert() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{1L, 1L, 1L}, {1L}, {1L, 1L, 1L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.insert((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(17, 23, 117, 123, -117), new Toto(29, 31, 129, 131, -129), new Toto(37, 41, 137, 141, -137), new Toto(43, 53, 143, 153, -143)}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)12))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"insert into Toto(id, a, b, q) values (?, ?, ?, ?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)17).add((Object)3, (Object)23).newRow((Object)1, (Object)2).add((Object)2, (Object)29).add((Object)3, (Object)31).newRow((Object)1, (Object)3).add((Object)2, (Object)37).add((Object)3, (Object)41).newRow((Object)1, (Object)4).add((Object)2, (Object)43).add((Object)3, (Object)53);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void update() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoQAlias = "Toto_q";
            InMemoryResultSet resultSetMock = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)7).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2), Maps.asMap((Object)totoIdAlias, (Object)13).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2), Maps.asMap((Object)totoIdAlias, (Object)17).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2), Maps.asMap((Object)totoIdAlias, (Object)23).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2)}));
            Mockito.when((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.update((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(7, 17, 23), new Toto(13, 29, 31), new Toto(17, 37, 41), new Toto(23, 43, 53)}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)16))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.q as " + totoQAlias + " from Toto where Toto.id in (?, ?, ?)", "select Toto.id as " + totoIdAlias + ", Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.q as " + totoQAlias + " from Toto where Toto.id in (?)", "update Toto set a = ?, b = ?, q = ? where id = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7).add((Object)2, (Object)13).add((Object)3, (Object)17).add((Object)1, (Object)23);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void updateById() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}, {1L}, {3L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.updateById((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(1, 17, 23, 117, 123, -117), new Toto(2, 29, 31, 129, 131, -129), new Toto(3, 37, 41, 137, 141, -137), new Toto(4, 43, 53, 143, 153, -143)}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)12))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"update Toto set a = ?, b = ?, q = ? where id = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)17).add((Object)2, (Object)23).add((Object)4, (Object)1).newRow((Object)1, (Object)29).add((Object)2, (Object)31).add((Object)4, (Object)2).newRow((Object)1, (Object)37).add((Object)2, (Object)41).add((Object)4, (Object)3).newRow((Object)1, (Object)43).add((Object)2, (Object)53).add((Object)4, (Object)4);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void delete() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{1L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.delete((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(7, 17, 23, 117, 123, -117)}));
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where id = ?"}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void delete_multiple() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}, {1L}, {3L}, {1L}}));
            SimpleRelationalEntityPersisterTest.this.testInstance.delete((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(1, 17, 23, 117, 123, -117), new Toto(2, 29, 31, 129, 131, -129), new Toto(3, 37, 41, 137, 141, -137), new Toto(4, 43, 53, 143, 153, -143)}));
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where id = ?"}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)1, (Object)2).add((Object)1, (Object)3).newRow((Object)1, (Object)4);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void deleteById() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.expectedRowCountForUpdate.set((Object)1L);
            SimpleRelationalEntityPersisterTest.this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(7, 17, 23, 117, 123, -117)}));
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where id in (?)"}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void deleteById_multiple() throws SQLException {
            SimpleRelationalEntityPersisterTest.this.effectiveBatchedRowCount.setRowCounts(Arrays.asList((Object[])new long[][]{{3L}, {3L}}));
            SimpleRelationalEntityPersisterTest.this.expectedRowCountForUpdate.set((Object)1L);
            SimpleRelationalEntityPersisterTest.this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new Toto[]{new Toto(1, 17, 23, 117, 123, -117), new Toto(2, 29, 31, 129, 131, -129), new Toto(3, 37, 41, 137, 141, -137), new Toto(4, 43, 53, 143, 153, -143)}));
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where id in (?, ?, ?)", "delete from Toto where id in (?)"}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)1).add((Object)2, (Object)2).add((Object)3, (Object)3).newRow((Object)1, (Object)4);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
        }

        @Test
        void select() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoQAlias = "Toto_q";
            InMemoryResultSet resultSetMock = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)7).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2), Maps.asMap((Object)totoIdAlias, (Object)13).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2), Maps.asMap((Object)totoIdAlias, (Object)17).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2), Maps.asMap((Object)totoIdAlias, (Object)23).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2)}));
            Mockito.when((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)resultSetMock);
            Set select = SimpleRelationalEntityPersisterTest.this.testInstance.select((Iterable)Arrays.asList((Object[])new Identifier[]{new PersistableIdentifier<Integer>(7), new PersistableIdentifier<Integer>(13), new PersistableIdentifier<Integer>(17), new PersistableIdentifier<Integer>(23)}));
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.q as " + totoQAlias + " from Toto where Toto.id in (?, ?, ?)", "select Toto.id as " + totoIdAlias + ", Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.q as " + totoQAlias + " from Toto where Toto.id in (?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7).add((Object)2, (Object)13).add((Object)3, (Object)17).add((Object)1, (Object)23);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            Comparator<Toto> totoComparator = Comparator.comparing(toto -> (Integer)toto.getId().getDelegate());
            Assertions.assertThat((String)Arrays.asTreeSet(totoComparator, (Collection)select).toString()).isEqualTo(Arrays.asTreeSet(totoComparator, (Object[])new Toto[]{new Toto(7, 1, 2), new Toto(13, 1, 2), new Toto(17, 1, 2), new Toto(23, 1, 2)}).toString());
        }

        @Test
        void selectWhere() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoQAlias = "Toto_q";
            InMemoryResultSet resultSetForCriteria = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)7).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2)}));
            Mockito.when((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)resultSetForCriteria);
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = SimpleRelationalEntityPersisterTest.this.testInstance.selectWhere(Toto::getA, (ConditionalOperator)Operators.eq((Object)42));
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.q as " + totoQAlias + " from Toto where Toto.a = ?"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)42);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            Comparator<Toto> totoComparator = Comparator.comparing(toto -> (Integer)toto.getId().getDelegate());
            Assertions.assertThat((String)Arrays.asTreeSet(totoComparator, (Collection)select).toString()).isEqualTo(Arrays.asTreeSet(totoComparator, (Object[])new Toto[]{new Toto(7, 1, 2)}).toString());
        }

        @Test
        void selectWhere_namedParameter() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoQAlias = "Toto_q";
            InMemoryResultSet resultSetForCriteria = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)7).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2)}));
            Mockito.when((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)resultSetForCriteria);
            ConditionalOperator myArg = Operators.equalsArgNamed((String)"myArg", Integer.class);
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = (RelationalEntityPersister.ExecutableEntityQueryCriteria)SimpleRelationalEntityPersisterTest.this.testInstance.selectWhere(Toto::getA, myArg).and(Toto::getId, (ConditionalOperator)Operators.in((Object[])new Identifier[]{new PersistedIdentifier<Integer>(42)}));
            totoExecutableEntityQueryCriteria.set("myArg", (Object)12);
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.q as " + totoQAlias + " from Toto where Toto.a = ? and Toto.id in (?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)12).add((Object)2, (Object)42);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            Comparator<Toto> totoComparator = Comparator.comparing(toto -> (Integer)toto.getId().getDelegate());
            Assertions.assertThat((String)Arrays.asTreeSet(totoComparator, (Collection)select).toString()).isEqualTo(Arrays.asTreeSet(totoComparator, (Object[])new Toto[]{new Toto(7, 1, 2)}).toString());
        }

        @Test
        void selectWhere_orderByOnNonCollectionProperty_orderByIsAddedToSQL() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoQAlias = "Toto_q";
            InMemoryResultSet resultSetForCriteria = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)7).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2)}));
            Mockito.when((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement.executeQuery()).thenReturn((Object)resultSetForCriteria);
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = (RelationalEntityPersister.ExecutableEntityQueryCriteria)SimpleRelationalEntityPersisterTest.this.testInstance.selectWhere(Toto::getA, (ConditionalOperator)Operators.eq((Object)42)).orderBy(Toto::getA);
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as " + totoIdAlias + ", Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.q as " + totoQAlias + " from Toto where Toto.a = ? order by Toto.a asc"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)42);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            Comparator<Toto> totoComparator = Comparator.comparing(toto -> (Integer)toto.getId().getDelegate());
            Assertions.assertThat((String)Arrays.asTreeSet(totoComparator, (Collection)select).toString()).isEqualTo(Arrays.asTreeSet(totoComparator, (Object[])new Toto[]{new Toto(7, 1, 2)}).toString());
        }

        @Test
        void selectWhere_orderByOnCollectionProperty_throwsException() {
            Assertions.assertThatCode(() -> {
                RelationalEntityPersister.ExecutableEntityQueryCriteria cfr_ignored_0 = (RelationalEntityPersister.ExecutableEntityQueryCriteria)SimpleRelationalEntityPersisterTest.this.testInstance.selectWhere(Toto::getA, (ConditionalOperator)Operators.eq((Object)42)).orderBy(Toto::getQ);
            }).hasMessage("OrderBy clause on a Collection property is unsupported due to eventual inconsistency with Collection nature : o.c.s.e.r.SimpleRelationalEntityPersisterTest$Toto::getQ");
        }

        @Test
        void selectWhere_collectionCriteria() throws SQLException {
            String totoIdAlias = "Toto_id";
            String totoAAlias = "Toto_a";
            String totoBAlias = "Toto_b";
            String totoQAlias = "Toto_q";
            InMemoryResultSet resultSetForCriteria = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"rootId", (Object)7)}));
            InMemoryResultSet resultSetForFinalResult = new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)totoIdAlias, (Object)7).add((Object)totoAAlias, (Object)1).add((Object)totoBAlias, (Object)2)}));
            MutableInt queryCounter = new MutableInt();
            Mockito.when((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement.executeQuery()).thenAnswer(arg_0 -> CRUD.lambda$selectWhere_collectionCriteria$5(queryCounter, (ResultSet)resultSetForCriteria, (ResultSet)resultSetForFinalResult, arg_0));
            RelationalEntityPersister.ExecutableEntityQueryCriteria totoExecutableEntityQueryCriteria = SimpleRelationalEntityPersisterTest.this.testInstance.selectWhere(Toto::getQ, (ConditionalOperator)Operators.eq((Object)Arrays.asHashSet((Object[])new Integer[]{42})));
            Set select = (Set)totoExecutableEntityQueryCriteria.execute(Accumulators.toSet());
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeQuery();
            ((PreparedStatement)Mockito.verify((Object)SimpleRelationalEntityPersisterTest.this.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)SimpleRelationalEntityPersisterTest.this.indexCaptor.capture(), (Integer)SimpleRelationalEntityPersisterTest.this.valueCaptor.capture());
            Assertions.assertThat((List)SimpleRelationalEntityPersisterTest.this.statementArgCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"select Toto.id as rootId from Toto where Toto.q = ?", "select Toto.id as " + totoIdAlias + ", Toto.a as " + totoAAlias + ", Toto.b as " + totoBAlias + ", Toto.q as " + totoQAlias + " from Toto where Toto.id in (?)"}));
            PairSetList expectedPairs = new PairSetList().newRow((Object)1, (Object)7);
            SimpleRelationalEntityPersisterTest.this.assertCapturedPairsEqual((PairSetList<Integer, Integer>)expectedPairs);
            Comparator<Toto> totoComparator = Comparator.comparing(toto -> (Integer)toto.getId().getDelegate());
            Assertions.assertThat((String)Arrays.asTreeSet(totoComparator, (Collection)select).toString()).isEqualTo(Arrays.asTreeSet(totoComparator, (Object[])new Toto[]{new Toto(7, 1, 2)}).toString());
        }

        private static /* synthetic */ ResultSet lambda$selectWhere_collectionCriteria$5(MutableInt queryCounter, ResultSet resultSetForCriteria, ResultSet resultSetForFinalResult, InvocationOnMock invocation) throws Throwable {
            queryCounter.increment();
            switch (queryCounter.getValue()) {
                case 1: {
                    return resultSetForCriteria;
                }
                case 2: {
                    return resultSetForFinalResult;
                }
            }
            return null;
        }
    }

    private static class EffectiveBatchedRowCount
    implements Sequence<long[]> {
        private Iterator<long[]> rowCounts;

        private EffectiveBatchedRowCount() {
        }

        public void setRowCounts(List<long[]> rowCounts) {
            this.rowCounts = rowCounts.iterator();
        }

        public long[] next() {
            return this.rowCounts.next();
        }
    }
}

