/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.HashedMap;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementRecordMapping;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.TablePerClassRootJoinNode;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.SimpleIdentifierAssembler;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.AbstractCriterion;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.PairIterator;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class EntityCriteriaSupport<C>
implements RelationalEntityCriteria<C, EntityCriteriaSupport<C>>,
ConfiguredEntityCriteria {
    private final Criteria<?> criteria = new Criteria();
    private final EntityCriteriaSupport<C> parent;
    private final AggregateAccessPointToColumnMapping<C> aggregateColumnMapping;
    private boolean hasCollectionCriteria;

    public EntityCriteriaSupport(EntityJoinTree<C, ?> tree) {
        this(tree, false);
    }

    EntityCriteriaSupport(EntityJoinTree<C, ?> tree, boolean withImmediatePropertiesCollect) {
        this(new AggregateAccessPointToColumnMapping<C>(tree, withImmediatePropertiesCollect));
    }

    public EntityCriteriaSupport(EntityCriteriaSupport<C> source) {
        this(source.aggregateColumnMapping);
    }

    private EntityCriteriaSupport(AggregateAccessPointToColumnMapping<C> source) {
        this.aggregateColumnMapping = source;
        this.parent = null;
    }

    private EntityCriteriaSupport(AggregateAccessPointToColumnMapping<C> source, EntityCriteriaSupport<C> parent) {
        this.aggregateColumnMapping = source;
        this.parent = parent;
    }

    public AggregateAccessPointToColumnMapping<C> getAggregateColumnMapping() {
        return this.aggregateColumnMapping;
    }

    public <O> EntityCriteriaSupport<C> add(LogicalOperator logicalOperator, List<? extends ValueAccessPoint<?>> accessPointChain, ConditionalOperator<O, ?> condition) {
        this.appendAsCriterion(logicalOperator, accessPointChain, condition);
        this.computeCollectionCriteriaIndicator(accessPointChain);
        return this;
    }

    void appendAsCriterion(LogicalOperator logicalOperator, List<? extends ValueAccessPoint<?>> accessPointChain, ConditionalOperator<?, ?> condition) {
        Selectable<?> column = this.aggregateColumnMapping.giveColumn(accessPointChain);
        this.criteria.add((AbstractCriterion)new ColumnCriterion(logicalOperator, column, condition));
        if (this.criteria.getOperator() == null) {
            this.criteria.setOperator(logicalOperator);
        }
    }

    private void computeCollectionCriteriaIndicator(List<? extends ValueAccessPoint<?>> accessPointChain) {
        this.hasCollectionCriteria |= accessPointChain.stream().anyMatch(valueAccessPoint -> Collection.class.isAssignableFrom(AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint).getMemberType()));
    }

    public <O> EntityCriteriaSupport<C> and(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), operator);
    }

    public <O> EntityCriteriaSupport<C> and(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), operator);
    }

    public <O> EntityCriteriaSupport<C> or(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), operator);
    }

    public <O> EntityCriteriaSupport<C> or(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), operator);
    }

    public EntityCriteriaSupport<C> beginNested() {
        EntityCriteriaSupport<C> abstractCriteria = new EntityCriteriaSupport<C>(this.aggregateColumnMapping, this);
        this.criteria.add(abstractCriteria.criteria);
        return abstractCriteria;
    }

    public EntityCriteriaSupport<C> endNested() {
        return this.parent;
    }

    public <A, B> EntityCriteriaSupport<C> and(SerializableFunction<C, A> getter1, SerializableFunction<A, B> getter2, ConditionalOperator<B, ?> operator) {
        return this.and(AccessorChain.fromMethodReferences(getter1, getter2).getAccessors(), (ConditionalOperator)operator);
    }

    public <O> EntityCriteriaSupport<C> and(List<? extends ValueAccessPoint<?>> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, getter, operator);
    }

    public <O> EntityCriteriaSupport<C> or(List<? extends ValueAccessPoint<?>> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, getter, operator);
    }

    @Override
    public CriteriaChain<?> getCriteria() {
        return this.criteria;
    }

    @Override
    public boolean hasCollectionCriteria() {
        return this.hasCollectionCriteria;
    }

    public String toString() {
        return Reflections.toString(this.getClass()) + "criteria=" + this.criteria.getConditions() + ", hasCollectionCriteria=" + this.hasCollectionCriteria + ", parent=" + this.parent;
    }

    private static class AccessorToColumnMap
    extends HashedMap<List<? extends ValueAccessPoint<?>>, Selectable<?>> {
        private AccessorToColumnMap() {
        }

        protected int hash(Object key) {
            List accessors = (List)key;
            int result = 1;
            for (ValueAccessPoint accessor : accessors) {
                AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)accessor);
                result = 31 * result + 31 * accessorDefinition.getDeclaringClass().hashCode() + accessorDefinition.getName().hashCode();
            }
            return result;
        }

        protected boolean isEqualKey(Object key1, Object key2) {
            List accessors1 = (List)key1;
            List accessors2 = (List)key2;
            List accessorDefinitions1 = accessors1.stream().map(AccessorDefinition::giveDefinition).collect(Collectors.toList());
            List accessorDefinitions2 = accessors2.stream().map(AccessorDefinition::giveDefinition).collect(Collectors.toList());
            PairIterator pairIterator = new PairIterator(accessorDefinitions1, accessorDefinitions2);
            boolean result = false;
            while (!result && pairIterator.hasNext()) {
                Duo accessorsPair = pairIterator.next();
                result = ((AccessorDefinition)accessorsPair.getLeft()).getDeclaringClass().equals(((AccessorDefinition)accessorsPair.getRight()).getDeclaringClass()) && ((AccessorDefinition)accessorsPair.getLeft()).getName().equals(((AccessorDefinition)accessorsPair.getRight()).getName()) && ((AccessorDefinition)accessorsPair.getLeft()).getMemberType().equals(((AccessorDefinition)accessorsPair.getRight()).getMemberType());
            }
            return result;
        }
    }

    public static class AggregateAccessPointToColumnMapping<C> {
        private final Map<List<? extends ValueAccessPoint<?>>, Selectable<?>> propertyToColumn = new AccessorToColumnMap();
        private final EntityJoinTree<C, ?> tree;

        @VisibleForTesting
        AggregateAccessPointToColumnMapping(EntityJoinTree<C, ?> tree, boolean withImmediatePropertiesCollect) {
            this.tree = tree;
            if (withImmediatePropertiesCollect) {
                this.collectPropertiesMapping();
            } else {
                PersisterBuilderContext.CURRENT.get().addBuildLifeCycleListener(new PersisterBuilderImpl.BuildLifeCycleListener(){

                    @Override
                    public void afterBuild() {
                        this.collectPropertiesMapping();
                    }

                    @Override
                    public void afterAllBuild() {
                    }
                });
            }
        }

        private void collectPropertiesMapping() {
            ArrayDeque accessorPath = new ArrayDeque();
            this.propertyToColumn.putAll(this.collectPropertyMapping(this.tree.getRoot(), accessorPath));
            Queue<AbstractJoinNode<?, ?, ?, ?>> stack = Collections.asLifoQueue(new ArrayDeque());
            stack.addAll((Collection<AbstractJoinNode<?, ?, ?, ?>>)this.tree.getRoot().getJoins());
            while (!stack.isEmpty()) {
                AbstractJoinNode abstractJoinNode = (AbstractJoinNode)stack.poll();
                if (abstractJoinNode instanceof RelationJoinNode) {
                    RelationJoinNode relationJoinNode = (RelationJoinNode)abstractJoinNode;
                    accessorPath.add(relationJoinNode.getPropertyAccessor());
                    Map<List<ValueAccessPoint<?>>, Selectable<?>> m = this.collectPropertyMapping(relationJoinNode, accessorPath);
                    this.propertyToColumn.putAll(m);
                    if (abstractJoinNode.getJoins().isEmpty()) {
                        accessorPath.removeLast();
                    }
                }
                stack.addAll((Collection<AbstractJoinNode<?, ?, ?, ?>>)abstractJoinNode.getJoins());
            }
        }

        private <E> Map<List<ValueAccessPoint<?>>, Selectable<?>> collectPropertyMapping(JoinNode<E, ?> joinNode, Deque<Accessor<?, ?>> accessorPath) {
            EntityInflater entityInflater;
            if (joinNode instanceof RelationJoinNode) {
                entityInflater = ((RelationJoinNode)joinNode).getEntityInflater();
            } else {
                if (joinNode instanceof TablePerClassRootJoinNode) {
                    EntityInflater entityInflater2 = ((TablePerClassRootJoinNode)joinNode).getEntityInflater();
                    EntityMapping entityMapping = entityInflater2.getEntityMapping();
                    HashMap propertyToColumn = new HashMap();
                    QueryStatement.PseudoTable pseudoTable = (QueryStatement.PseudoTable)((TablePerClassRootJoinNode)joinNode).getTable();
                    Stream.concat(entityMapping.getPropertyToColumn().entrySet().stream(), entityMapping.getReadonlyPropertyToColumn().entrySet().stream()).forEach(entry -> {
                        ReversibleAccessor accessor = (ReversibleAccessor)entry.getKey();
                        List key = accessor instanceof AccessorChain ? new ArrayList(((AccessorChain)accessor).getAccessors()) : Arrays.asList((Object[])new ValueAccessPoint[]{accessor});
                        propertyToColumn.put(key, joinNode.getOriginalColumnsToLocalOnes().get(pseudoTable.findColumn(((Column)entry.getValue()).getExpression())));
                    });
                    IdentifierAssembler identifierAssembler = entityMapping.getIdMapping().getIdentifierAssembler();
                    if (identifierAssembler instanceof SimpleIdentifierAssembler) {
                        Column idColumn = ((SimpleIdentifierAssembler)identifierAssembler).getColumn();
                        ReversibleAccessor idAccessor = ((AccessorWrapperIdAccessor)entityMapping.getIdMapping().getIdAccessor()).getIdAccessor();
                        propertyToColumn.put(Arrays.asList((Object[])new ValueAccessPoint[]{idAccessor}), joinNode.getOriginalColumnsToLocalOnes().get(pseudoTable.findColumn(idColumn.getExpression())));
                    }
                    entityMapping.getEmbeddedBeanStrategies().forEach((k, v) -> v.getPropertyToColumn().forEach((p, c) -> propertyToColumn.put(Arrays.asList((Object[])new ValueAccessPoint[]{k}), (Selectable<?>)c)));
                    propertyToColumn.forEach((k, v) -> k.addAll(0, accessorPath));
                    return propertyToColumn;
                }
                if (joinNode instanceof JoinRoot) {
                    entityInflater = ((JoinRoot)joinNode).getEntityInflater();
                } else {
                    throw new UnsupportedOperationException("Unsupported join type " + Reflections.toString(joinNode.getClass()));
                }
            }
            EntityMapping entityMapping = entityInflater.getEntityMapping();
            HashMap propertyToColumn = new HashMap();
            if (entityMapping instanceof ElementRecordMapping) {
                ArrayList accessors = new ArrayList(accessorPath);
                Stream.concat(entityMapping.getPropertyToColumn().entrySet().stream(), entityMapping.getReadonlyPropertyToColumn().entrySet().stream()).forEach(entry -> propertyToColumn.put(accessors, joinNode.getOriginalColumnsToLocalOnes().get(entry.getValue())));
            } else {
                Stream.concat(entityMapping.getPropertyToColumn().entrySet().stream(), entityMapping.getReadonlyPropertyToColumn().entrySet().stream()).forEach(entry -> {
                    ReversibleAccessor accessor = (ReversibleAccessor)entry.getKey();
                    List key = accessor instanceof AccessorChain ? new ArrayList(((AccessorChain)accessor).getAccessors()) : Arrays.asList((Object[])new ValueAccessPoint[]{accessor});
                    propertyToColumn.put(key, joinNode.getOriginalColumnsToLocalOnes().get(entry.getValue()));
                });
                IdentifierAssembler identifierAssembler = entityMapping.getIdMapping().getIdentifierAssembler();
                if (identifierAssembler instanceof SimpleIdentifierAssembler) {
                    Column idColumn = ((SimpleIdentifierAssembler)identifierAssembler).getColumn();
                    ReversibleAccessor idAccessor = ((AccessorWrapperIdAccessor)entityMapping.getIdMapping().getIdAccessor()).getIdAccessor();
                    propertyToColumn.put(Arrays.asList((Object[])new ValueAccessPoint[]{idAccessor}), joinNode.getOriginalColumnsToLocalOnes().get(idColumn));
                }
                entityMapping.getEmbeddedBeanStrategies().forEach((k, v) -> v.getPropertyToColumn().forEach((p, c) -> propertyToColumn.put(Arrays.asList((Object[])new ValueAccessPoint[]{k}), (Selectable<?>)c)));
                propertyToColumn.forEach((k, v) -> k.addAll(0, accessorPath));
            }
            return propertyToColumn;
        }

        public Selectable<?> giveColumn(List<? extends ValueAccessPoint<?>> valueAccessPoints) {
            Selectable<?> column = this.propertyToColumn.get(valueAccessPoints);
            if (column != null) {
                return column;
            }
            throw this.newConfigurationException(valueAccessPoints);
        }

        private MappingConfigurationException newConfigurationException(List<? extends ValueAccessPoint<?>> valueAccessPoints) {
            StringAppender accessPointAsString = new StringAppender(){

                public StringAppender cat(Object o) {
                    if (o instanceof ValueAccessPoint) {
                        super.cat((Object)AccessorDefinition.toString((ValueAccessPoint)((ValueAccessPoint)o)));
                    } else {
                        super.cat(o);
                    }
                    return this;
                }
            };
            accessPointAsString.ccat(valueAccessPoints, (Object)" > ");
            return new MappingConfigurationException("Error while looking for column of " + accessPointAsString + " : it is not declared in mapping of " + Reflections.toString(this.tree.getRoot().getEntityInflater().getEntityType()));
        }
    }
}

