/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.util.Set;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.ColumnVariable;
import org.codefilarete.stalactite.sql.order.PlaceholderVariable;
import org.codefilarete.stalactite.sql.order.StatementVariable;
import org.codefilarete.tool.collection.KeepOrderSet;

public class Update<T extends Table<T>> {
    private final T targetTable;
    private final Set<Column<T, ?>> columnsToUpdate;
    private final Set<StatementVariable<?, T>> row = new KeepOrderSet();
    private final Where<?> criteria;

    public Update(T targetTable) {
        this(targetTable, ((Table)targetTable).getColumns());
    }

    public Update(T targetTable, Where<?> where) {
        this(targetTable, ((Table)targetTable).getColumns(), where);
    }

    public Update(T targetTable, Set<? extends Column<T, ?>> columnsToUpdate) {
        this(targetTable, columnsToUpdate, new Where());
    }

    public Update(T targetTable, Set<? extends Column<T, ?>> columnsToUpdate, Where<?> where) {
        this.targetTable = targetTable;
        this.columnsToUpdate = new KeepOrderSet(columnsToUpdate);
        this.criteria = where;
    }

    public T getTargetTable() {
        return this.targetTable;
    }

    public Set<Column<T, ?>> getColumnsToUpdate() {
        return this.columnsToUpdate;
    }

    public Where<?> getCriteria() {
        return this.criteria;
    }

    public <O> Update<T> set(Column<? extends T, O> column, O value) {
        this.row.add(new ColumnVariable<O, T>(column, value));
        return this;
    }

    public <O> Update<T> set(Column<? extends T, O> column1, Column<?, O> column2) {
        this.row.add(new ColumnVariable(column1, column2));
        return this;
    }

    public <O> Update<T> set(String paramName, O value) {
        this.row.add(new PlaceholderVariable(paramName, value));
        return this;
    }

    public Set<StatementVariable<?, T>> getRow() {
        return this.row;
    }
}

