/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.statement.binder.AbstractParameterBindersITTest;
import org.codefilarete.stalactite.sql.statement.binder.H2ParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.H2TypeMapping;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.stalactite.sql.test.H2DatabaseHelper;
import org.codefilarete.stalactite.sql.test.H2InMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class H2ParameterBindersTest
extends AbstractParameterBindersITTest {
    H2ParameterBindersTest() {
    }

    public DataSource giveDataSource() {
        return new H2InMemoryDataSource();
    }

    protected DatabaseHelper giveDatabaseHelper() {
        return new H2DatabaseHelper();
    }

    @BeforeEach
    void createParameterBinderRegistry() {
        this.parameterBinderRegistry = new H2ParameterBinderRegistry();
    }

    @BeforeEach
    void createJavaTypeToSqlTypeMapping() {
        this.javaTypeToSqlTypeMapping = new H2TypeMapping();
    }

    @Test
    void localDateTimeBinder() throws SQLException {
        LocalDateTime initialTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123456789);
        LocalDateTime comparisonTime = LocalDateTime.of(2021, Month.JULY, 12, 4, 23, 35, 123457000);
        Set databaseContent = this.insertAndSelect(LocalDateTime.class, Arrays.asSet((Object[])new LocalDateTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalDateTime[]{null, comparisonTime}));
    }

    @Test
    void localTimeBinder() throws SQLException {
        LocalTime initialTime = LocalTime.of(4, 23, 35, 123456789);
        LocalTime comparisonTime = LocalTime.of(4, 23, 35, 123457000);
        Set databaseContent = this.insertAndSelect(LocalTime.class, Arrays.asSet((Object[])new LocalTime[]{null, initialTime}));
        Assertions.assertThat((Collection)databaseContent).isEqualTo((Object)Arrays.asSet((Object[])new LocalTime[]{null, comparisonTime}));
    }
}

