/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.onetomany;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.diff.AbstractDiff;
import org.codefilarete.stalactite.engine.diff.IndexedDiff;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.SelectListenerCollection;
import org.codefilarete.stalactite.engine.runtime.CollectionUpdater;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.onetomany.IndexedMappedManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.ThreadLocals;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.trace.MutableInt;

public class OneToManyWithIndexedMappedAssociationEngine<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>, RIGHTTABLE extends Table<RIGHTTABLE>>
extends OneToManyWithMappedAssociationEngine<SRC, TRGT, SRCID, TRGTID, C, RIGHTTABLE> {
    private final Column<RIGHTTABLE, Integer> indexColumn;

    public OneToManyWithIndexedMappedAssociationEngine(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, IndexedMappedManyRelationDescriptor<SRC, TRGT, C, SRCID, TRGTID> manyRelationDefinition, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, Set<Column<RIGHTTABLE, ?>> mappedReverseColumns, Column<RIGHTTABLE, Integer> indexColumn, Function<SRCID, Map<Column<RIGHTTABLE, ?>, ?>> reverseColumnsValueProvider, ForeignKeyNamingStrategy foreignKeyNamingStrategy) {
        super(targetPersister, manyRelationDefinition, sourcePersister, mappedReverseColumns, reverseColumnsValueProvider, foreignKeyNamingStrategy);
        this.indexColumn = indexColumn;
    }

    public IndexedMappedManyRelationDescriptor<SRC, TRGT, C, SRCID, TRGTID> getManyRelationDescriptor() {
        return (IndexedMappedManyRelationDescriptor)this.manyRelationDescriptor;
    }

    @Override
    public <T1 extends Table<T1>, T2 extends Table<T2>> String addSelectCascade(Key<T1, SRCID> sourcePrimaryKey, boolean loadSeparately) {
        HashSet<Column<RIGHTTABLE, Integer>> columnsToSelect = new HashSet<Column<RIGHTTABLE, Integer>>(this.targetPersister.getMainTable().getPrimaryKey().getColumns());
        columnsToSelect.add(this.indexColumn);
        String relationJoinNodeName = this.targetPersister.joinAsMany("ROOT", this.sourcePersister, this.manyRelationDescriptor.getCollectionProvider(), sourcePrimaryKey, this.manyRelationDescriptor.getReverseColumn(), this.manyRelationDescriptor.getRelationFixer(), columnedRow -> {
            Object identifier = this.targetPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(columnedRow);
            Integer targetEntityIndex = (Integer)columnedRow.get(this.indexColumn);
            return identifier + "-" + targetEntityIndex;
        }, columnsToSelect, true, loadSeparately);
        this.addIndexSelection(relationJoinNodeName);
        SelectListenerCollection targetSelectListener = this.targetPersister.getPersisterListener().getSelectListener();
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>((SelectListener)targetSelectListener){
            final /* synthetic */ SelectListener val$targetSelectListener;
            {
                this.val$targetSelectListener = selectListener;
            }

            public void beforeSelect(Iterable<SRCID> ids) {
                this.val$targetSelectListener.beforeSelect(Collections.emptyList());
            }

            public void afterSelect(Set<? extends SRC> result) {
                Set collect = Iterables.stream(result).flatMap(src -> (Stream)Nullable.nullable(OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getCollectionGetter().apply(src)).map(Collection::stream).getOr(Stream.empty())).collect(Collectors.toSet());
                this.val$targetSelectListener.afterSelect(collect);
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.val$targetSelectListener.onSelectError(Collections.emptyList(), exception);
            }
        });
        return relationJoinNodeName;
    }

    private void addIndexSelection(String joinNodeName) {
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>(){

            public void beforeSelect(Iterable<SRCID> ids) {
                IndexedMappedManyRelationDescriptor.InMemoryRelationHolder relationFixer = (IndexedMappedManyRelationDescriptor.InMemoryRelationHolder)OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getRelationFixer();
                relationFixer.init();
            }

            public void afterSelect(Set<? extends SRC> result) {
                IndexedMappedManyRelationDescriptor.InMemoryRelationHolder relationFixer = (IndexedMappedManyRelationDescriptor.InMemoryRelationHolder)OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getRelationFixer();
                relationFixer.applySort(result);
                this.cleanContext();
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.cleanContext();
            }

            private void cleanContext() {
                IndexedMappedManyRelationDescriptor.InMemoryRelationHolder relationFixer = (IndexedMappedManyRelationDescriptor.InMemoryRelationHolder)OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getRelationFixer();
                relationFixer.clear();
            }
        });
        AbstractJoinNode join = (AbstractJoinNode)this.sourcePersister.getEntityJoinTree().getJoin(joinNodeName);
        join.setConsumptionListener((trgt, columnValueProvider) -> {
            IndexedMappedManyRelationDescriptor.InMemoryRelationHolder relationFixer = (IndexedMappedManyRelationDescriptor.InMemoryRelationHolder)this.manyRelationDescriptor.getRelationFixer();
            Map indexPerTargetId = relationFixer.getCurrentSelectedIndexes();
            if (indexPerTargetId != null) {
                int index = (Integer)columnValueProvider.get(this.indexColumn);
                Object relationOwnerId = this.targetPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(columnValueProvider);
                indexPerTargetId.put(relationOwnerId, index);
            }
        });
    }

    @Override
    public void addInsertCascade(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        this.addIndexInsertion();
        super.addInsertCascade(targetPersister);
    }

    private <TARGETTABLE extends Table<TARGETTABLE>> void addIndexInsertion() {
        final Function collectionGetter = this.manyRelationDescriptor.getCollectionGetter();
        Mapping.ShadowColumnValueProvider indexValueProvider = new Mapping.ShadowColumnValueProvider<TRGT, TARGETTABLE>(){

            public boolean accept(TRGT entity) {
                Object sourceEntity = OneToManyWithIndexedMappedAssociationEngine.this.giveRelationStorageContext().get(entity);
                return sourceEntity == null || OneToManyWithIndexedMappedAssociationEngine.this.sourcePersister.getMapping().getClassToPersist().isInstance(sourceEntity);
            }

            public Set<Column<TARGETTABLE, ?>> getColumns() {
                return Collections.singleton(OneToManyWithIndexedMappedAssociationEngine.this.indexColumn);
            }

            public Map<Column<TARGETTABLE, ?>, ?> giveValue(TRGT target) {
                Object source = OneToManyWithIndexedMappedAssociationEngine.this.giveRelationStorageContext().get(target);
                Integer targetEntityIndex = source == null ? null : Integer.valueOf(this.computeTargetIndex(source, target));
                HashMap<Column, Integer> result = new HashMap<Column, Integer>();
                result.put(OneToManyWithIndexedMappedAssociationEngine.this.indexColumn, targetEntityIndex);
                return result;
            }

            private int computeTargetIndex(SRC source, TRGT target) {
                int result;
                Collection apply = (Collection)collectionGetter.apply(source);
                if (apply instanceof List) {
                    result = ((List)apply).indexOf(target) + 1;
                } else if (apply instanceof LinkedHashSet) {
                    MutableInt counter = new MutableInt(0);
                    for (Object o : apply) {
                        counter.increment();
                        if (o != target) continue;
                        break;
                    }
                    result = counter.getValue();
                } else {
                    throw new UnsupportedOperationException("Index computation is not supported for " + Reflections.toString(apply.getClass()));
                }
                return result;
            }
        };
        this.targetPersister.getMapping().addShadowColumnInsert(indexValueProvider);
        this.targetPersister.getMapping().addShadowColumnUpdate(indexValueProvider);
    }

    @Override
    protected void addTargetInstancesUpdateCascader(boolean shouldDeleteRemoved) {
        ListCollectionUpdater collectionUpdater = new ListCollectionUpdater(this.manyRelationDescriptor.getCollectionGetter(), this.targetPersister, this.manyRelationDescriptor.getReverseSetter(), shouldDeleteRemoved, arg_0 -> ((EntityMapping)this.targetPersister.getMapping()).getId(arg_0), this.indexColumn);
        this.sourcePersister.getPersisterListener().addUpdateListener(new OneToManyWithMappedAssociationEngine.AfterUpdateTrigger(collectionUpdater));
    }

    private static class ListCollectionUpdater<SRC, TRGT, ID, C extends Collection<TRGT>, TARGETTABLE extends Table<TARGETTABLE>>
    extends CollectionUpdater<SRC, TRGT, C> {
        private final ThreadLocal<Map<TRGT, Integer>> currentUpdatableListIndex = new ThreadLocal();
        private final ThreadLocal<Map<TRGT, Integer>> currentInsertableListIndex = new ThreadLocal();
        private final Column<TARGETTABLE, Integer> indexingColumn;

        private ListCollectionUpdater(Function<SRC, C> collectionGetter, ConfiguredRelationalPersister<TRGT, ID> targetPersister, @javax.annotation.Nullable BiConsumer<TRGT, SRC> reverseSetter, boolean shouldDeleteRemoved, Function<TRGT, ?> idProvider, Column<TARGETTABLE, Integer> indexingColumn) {
            super(collectionGetter, targetPersister, reverseSetter, shouldDeleteRemoved, idProvider);
            this.indexingColumn = indexingColumn;
            this.addShadowIndexInsert(targetPersister);
            this.addShadowIndexUpdate(targetPersister);
        }

        private void addShadowIndexUpdate(ConfiguredRelationalPersister<TRGT, ID> targetPersister) {
            targetPersister.getMapping().addShadowColumnInsert(new Mapping.ShadowColumnValueProvider<TRGT, TARGETTABLE>(){

                public boolean accept(TRGT entity) {
                    return currentUpdatableListIndex.get() != null && ((Map)currentUpdatableListIndex.get()).containsKey(entity);
                }

                public Set<Column<TARGETTABLE, ?>> getColumns() {
                    return Arrays.asHashSet((Object[])new Column[]{indexingColumn});
                }

                public Map<Column<TARGETTABLE, ?>, ?> giveValue(TRGT bean) {
                    HashMap result = new HashMap();
                    result.put(indexingColumn, ((Map)currentUpdatableListIndex.get()).get(bean));
                    return result;
                }
            });
        }

        private void addShadowIndexInsert(ConfiguredRelationalPersister<TRGT, ID> targetPersister) {
            targetPersister.getMapping().addShadowColumnInsert(new Mapping.ShadowColumnValueProvider<TRGT, TARGETTABLE>(){

                public boolean accept(TRGT entity) {
                    return currentInsertableListIndex.get() != null && ((Map)currentInsertableListIndex.get()).containsKey(entity);
                }

                public Set<Column<TARGETTABLE, ?>> getColumns() {
                    return Arrays.asHashSet((Object[])new Column[]{indexingColumn});
                }

                public Map<Column<TARGETTABLE, ?>, ?> giveValue(TRGT bean) {
                    HashMap result = new HashMap();
                    result.put(indexingColumn, ((Map)currentInsertableListIndex.get()).get(bean));
                    return result;
                }
            });
        }

        @Override
        protected Set<? extends AbstractDiff<TRGT>> diff(Collection<TRGT> modified, Collection<TRGT> unmodified) {
            return this.getDiffer().diffOrdered(unmodified, modified);
        }

        @Override
        protected CollectionUpdater.UpdateContext newUpdateContext(Duo<SRC, SRC> updatePayload) {
            return new IndexedMappedAssociationUpdateContext(updatePayload);
        }

        @Override
        protected void onAddedElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<TRGT> diff) {
            super.onAddedElements(updateContext, diff);
            this.addNewIndexToContext((IndexedDiff)diff, (IndexedMappedAssociationUpdateContext)updateContext);
        }

        @Override
        protected void onHeldElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<TRGT> diff) {
            super.onHeldElements(updateContext, diff);
            this.addNewIndexToContext((IndexedDiff)diff, (IndexedMappedAssociationUpdateContext)updateContext);
        }

        private void addNewIndexToContext(IndexedDiff<TRGT> diff, IndexedMappedAssociationUpdateContext updateContext) {
            Set minus = Iterables.minus(diff.getReplacerIndexes(), diff.getSourceIndexes());
            Integer index = (Integer)Iterables.first((Iterable)minus);
            if (index != null) {
                updateContext.getIndexUpdates().put(diff.getReplacingInstance(), index);
            }
        }

        @Override
        protected void insertTargets(CollectionUpdater.UpdateContext updateContext) {
            ThreadLocals.doWithThreadLocal(this.currentInsertableListIndex, ((IndexedMappedAssociationUpdateContext)updateContext)::getIndexUpdates, () -> super.insertTargets(updateContext));
        }

        @Override
        protected void updateTargets(CollectionUpdater.UpdateContext updateContext, boolean allColumnsStatement) {
            ThreadLocals.doWithThreadLocal(this.currentUpdatableListIndex, ((IndexedMappedAssociationUpdateContext)updateContext)::getIndexUpdates, () -> super.updateTargets(updateContext, allColumnsStatement));
        }

        class IndexedMappedAssociationUpdateContext
        extends CollectionUpdater.UpdateContext {
            private final Map<TRGT, Integer> indexUpdates;

            public IndexedMappedAssociationUpdateContext(Duo<SRC, SRC> updatePayload) {
                super(updatePayload);
                this.indexUpdates = new IdentityHashMap();
            }

            public Map<TRGT, Integer> getIndexUpdates() {
                return this.indexUpdates;
            }
        }
    }
}

