/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.EntityFinder;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.GroupBy;
import org.codefilarete.stalactite.query.model.Having;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.Maps;

public class RelationalEntityFinder<C, I, T extends Table<T>>
implements EntityFinder<C, I> {
    private static final String PRIMARY_KEY_ALIAS = "rootId";
    private final EntityJoinTree<C, I> entityJoinTree;
    private final ConnectionProvider connectionProvider;
    private final Dialect dialect;
    private EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery;
    private SQLOperation.SQLOperationListener<?> operationListener;

    public RelationalEntityFinder(EntityJoinTree<C, I> entityJoinTree, ConnectionProvider connectionProvider, Dialect dialect) {
        this.entityJoinTree = entityJoinTree;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        PersisterBuilderContext.CURRENT.get().addBuildLifeCycleListener(new PersisterBuilderImpl.BuildLifeCycleListener(){

            @Override
            public void afterBuild() {
            }

            @Override
            public void afterAllBuild() {
                RelationalEntityFinder.this.buildQuery();
            }
        });
    }

    public RelationalEntityFinder(EntityJoinTree<C, I> entityJoinTree, ConnectionProvider connectionProvider, Dialect dialect, boolean withImmediateQueryBuild) {
        this.entityJoinTree = entityJoinTree;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        this.entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)dialect.getColumnBinderRegistry()).buildSelectQuery();
    }

    private void buildQuery() {
        this.entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
    }

    @Override
    public void setOperationListener(SQLOperation.SQLOperationListener<?> operationListener) {
        this.operationListener = operationListener;
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.entityJoinTree;
    }

    public Set<C> selectFromQueryBean(String sql, Map<String, Object> values) {
        HashMap parameterBinders = new HashMap();
        values.forEach((paramName, value) -> {
            PreparedStatementWriter writer = this.dialect.getColumnBinderRegistry().getWriter(value.getClass());
            parameterBinders.put((String)paramName, (PreparedStatementWriter<?>)writer);
        });
        return this.selectFromQueryBean(sql, values, parameterBinders);
    }

    public Set<C> selectFromQueryBean(String sql, Map<String, Object> values, Map<String, PreparedStatementWriter<?>> parameterBinders) {
        EntityTreeInflater<C> inflater = this.entityTreeQuery.getInflater();
        Query query = this.entityTreeQuery.getQuery();
        HashMap selectParameterBinders = new HashMap();
        HashMap aliases = new HashMap();
        query.getColumns().forEach(selectable -> {
            ResultSetReader reader;
            String alias = (String)Objects.preventNull(query.getAliases().get(selectable), (Object)selectable.getExpression());
            if (selectable instanceof Column) {
                reader = this.dialect.getColumnBinderRegistry().getReader((Object)((Column)selectable));
                selectParameterBinders.put(selectable, reader);
            } else {
                reader = this.dialect.getColumnBinderRegistry().getReader(selectable.getJavaType());
            }
            selectParameterBinders.put(selectable, reader);
            aliases.put((Selectable<?>)selectable, alias);
        });
        StringParamedSQL statement = new StringParamedSQL(sql, parameterBinders);
        statement.setValues(values);
        return new InternalExecutor(inflater, selectParameterBinders, aliases).execute(statement);
    }

    @Override
    public Set<C> select(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer, Map<String, Object> valuesPerParam) {
        Query queryClone = new Query(this.entityTreeQuery.getQuery().getSelectDelegate(), this.entityTreeQuery.getQuery().getFromDelegate(), new Where(), new GroupBy(), new Having(), new OrderBy(), new Limit());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone, where.getCriteria());
        if (where.hasCollectionCriteria()) {
            KeepOrderMap columns = queryClone.getSelectDelegate().clear();
            Column pk = (Column)Iterables.first((Iterable)((Table)this.entityJoinTree.getRoot().getTable()).getPrimaryKey().getColumns());
            queryClone.select((Selectable)pk, PRIMARY_KEY_ALIAS);
            Maps.ChainingMap aliases = Maps.asMap((Object)pk, (Object)PRIMARY_KEY_ALIAS);
            Maps.ChainingMap columnReaders = Maps.asMap((Object)pk, (Object)this.dialect.getColumnBinderRegistry().getBinder((Object)pk));
            orderByClauseConsumer.accept((OrderByChain<?>)queryClone.orderBy());
            limitAwareConsumer.accept((LimitAware<?>)queryClone.orderBy());
            Set<I> ids = this.readIds(sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap()), (Map<Column<?, ?>, ResultSetReader<?>>)columnReaders, (Map<Column<?, ?>, String>)aliases);
            if (ids.isEmpty()) {
                return Collections.emptySet();
            }
            queryClone.getSelectDelegate().remove((Selectable)pk);
            columns.forEach((arg_0, arg_1) -> ((Query)queryClone).select(arg_0, arg_1));
            queryClone.getWhereDelegate().clear();
            queryClone.where(pk, (ConditionalOperator)Operators.in(ids));
            PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(valuesPerParam);
            return new InternalExecutor(this.entityTreeQuery).execute(preparedSQL);
        }
        orderByClauseConsumer.accept((OrderByChain<?>)queryClone.orderBy());
        limitAwareConsumer.accept((LimitAware<?>)queryClone.orderBy());
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(valuesPerParam);
        return new InternalExecutor(this.entityTreeQuery).execute(preparedSQL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<I> readIds(PreparedSQL preparedSQL, Map<Column<?, ?>, ResultSetReader<?>> columnReaders, Map<Column<?, ?>, String> aliases) {
        EntityInflater<C, I> entityInflater = this.entityJoinTree.getRoot().getEntityInflater();
        try (ReadOperation closeableOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(closeableOperation.execute(), columnReaders, aliases);
            Set set = (Set)Iterables.collect(() -> rowIterator, row -> entityInflater.giveIdentifier((ColumnedRow)row), HashSet::new);
            return set;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    @Override
    public <R, O> R selectProjection(Consumer<Select> selectAdapter, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator, CriteriaChain where, boolean distinct, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.entityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        Query query = entityTreeQuery.getQuery();
        query.getSelectDelegate().setDistinct(distinct);
        orderByClauseConsumer.accept((OrderByChain<?>)query.getQuery().orderBy());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query, (Iterable)where);
        selectAdapter.accept(query.getSelectDelegate());
        Map aliases = query.getAliases();
        Map columnReaders = Iterables.map((Iterable)query.getColumns(), Function.identity(), selectable -> this.dialect.getColumnBinderRegistry().getBinder(selectable.getJavaType()));
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        return this.readProjection(preparedSQL, columnReaders, query.getAliases(), accumulator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R, O> R readProjection(PreparedSQL preparedSQL, Map<Selectable<?>, ResultSetReader<?>> columnReaders, Map<Selectable<?>, String> aliases, Accumulator<? super Function<Selectable<O>, O>, Object, R> accumulator) {
        try (ReadOperation closeableOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(closeableOperation.execute(), columnReaders, aliases);
            Object object = accumulator.collect((Iterable)Iterables.stream((Iterator)rowIterator).map(row -> arg_0 -> ((ColumnedRow)row).get(arg_0)).collect(Collectors.toList()));
            return (R)object;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private class InternalExecutor {
        private final EntityTreeInflater<C> inflater;
        private final Map<Selectable<?>, ResultSetReader<?>> selectParameterBinders;
        private final Map<Selectable<?>, String> columnAliases;

        private InternalExecutor(EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery) {
            this(entityTreeQuery.getInflater(), entityTreeQuery.getSelectParameterBinders(), entityTreeQuery.getColumnAliases());
        }

        public InternalExecutor(EntityTreeInflater<C> inflater, Map<Selectable<?>, ? extends ResultSetReader<?>> selectParameterBinders, Map<Selectable<?>, String> columnAliases) {
            this.inflater = inflater;
            this.selectParameterBinders = selectParameterBinders;
            this.columnAliases = columnAliases;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected <ParamType> Set<C> execute(SQLStatement<ParamType> query) {
            try (ReadOperation readOperation = RelationalEntityFinder.this.dialect.getReadOperationFactory().createInstance(query, RelationalEntityFinder.this.connectionProvider);){
                readOperation.setListener(RelationalEntityFinder.this.operationListener);
                readOperation.setValues(query.getValues());
                Set set = this.transform(readOperation);
                return set;
            }
            catch (RuntimeException e) {
                throw new SQLExecutionException(query.getSQL(), (Throwable)e);
            }
        }

        protected Set<C> transform(ReadOperation<?> closeableOperation) {
            ResultSet resultSet = closeableOperation.execute();
            ColumnedRowIterator rowIterator = new ColumnedRowIterator(resultSet, this.selectParameterBinders, this.columnAliases);
            return this.transform((Iterator<? extends ColumnedRow>)rowIterator);
        }

        protected Set<C> transform(Iterator<? extends ColumnedRow> rowIterator) {
            return this.inflater.transform(() -> rowIterator, 50);
        }
    }
}

