/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.jointable;

import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphicEntityFinder;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeQueryBuilder;
import org.codefilarete.stalactite.engine.runtime.load.JoinTableRootJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.MergeJoinNode;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.GroupBy;
import org.codefilarete.stalactite.query.model.Having;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.LimitAware;
import org.codefilarete.stalactite.query.model.OrderBy;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Where;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.ColumnedRowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.KeepOrderMap;

public class JoinTablePolymorphismEntityFinder<C, I, T extends Table<T>>
extends AbstractPolymorphicEntityFinder<C, I, T> {
    private final SingleLoadEntityJoinTree<C, I> singleLoadEntityJoinTree;
    private Query query;

    public JoinTablePolymorphismEntityFinder(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> persisterPerSubclass, ConnectionProvider connectionProvider, Dialect dialect) {
        super(mainPersister, persisterPerSubclass, connectionProvider, dialect);
        this.singleLoadEntityJoinTree = this.buildSingleLoadEntityJoinTree(mainPersister);
        PersisterBuilderContext.CURRENT.get().addBuildLifeCycleListener(new PersisterBuilderImpl.BuildLifeCycleListener(){

            @Override
            public void afterBuild() {
            }

            @Override
            public void afterAllBuild() {
                JoinTablePolymorphismEntityFinder.this.buildQuery();
            }
        });
    }

    private void buildQuery() {
        EntityTreeQueryBuilder.EntityTreeQuery<C> entityTreeQuery = new EntityTreeQueryBuilder<C>(this.singleLoadEntityJoinTree, (ResultSetReaderRegistry)this.dialect.getColumnBinderRegistry()).buildSelectQuery();
        this.query = entityTreeQuery.getQuery();
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.singleLoadEntityJoinTree;
    }

    private SingleLoadEntityJoinTree<C, I> buildSingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister) {
        SingleLoadEntityJoinTree result = new SingleLoadEntityJoinTree(mainPersister, new HashSet(this.persisterPerSubclass.values()));
        this.persisterPerSubclass.forEach((type, persister) -> {
            String mergeJoin = result.addMergeJoin("ROOT", new EntityMerger.EntityMergerAdapter(persister.getMapping()), mainPersister.getMainTable().getPrimaryKey(), persister.getMainTable().getPrimaryKey(), EntityJoinTree.JoinType.OUTER, joinNode -> {
                MergeJoinNode.MergeJoinRowConsumer subEntityConsumer = new MergeJoinNode.MergeJoinRowConsumer((MergeJoinNode)joinNode, persister.getMapping().getRowTransformer());
                ((JoinTableRootJoinNode)result.getRoot()).addSubPersister(persister, subEntityConsumer);
                return subEntityConsumer;
            });
            persister.getEntityJoinTree().projectTo(result, mergeJoin);
        });
        this.mainEntityJoinTree.projectTo(result, "ROOT");
        return result;
    }

    @Override
    public Set<C> selectWithSingleQuery(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        this.LOGGER.debug("Finding entities in a single query with criteria {}", (Object)where);
        if (this.hasSubPolymorphicPersister) {
            this.LOGGER.debug("Single query was asked but due to sub-polymorphism the query is made in 2 phases");
            return this.selectIn2Phases(where, orderByClauseConsumer, limitAwareConsumer);
        }
        return super.selectWithSingleQuery(where, orderByClauseConsumer, limitAwareConsumer, this.singleLoadEntityJoinTree, this.dialect, this.connectionProvider);
    }

    @Override
    public Set<C> selectIn2Phases(ConfiguredEntityCriteria where, Consumer<OrderByChain<?>> orderByClauseConsumer, Consumer<LimitAware<?>> limitAwareConsumer) {
        this.LOGGER.debug("Finding entities in 2-phases query with criteria {}", (Object)where);
        Query queryClone = new Query(this.query.getSelectDelegate(), this.query.getFromDelegate(), new Where(), new GroupBy(), new Having(), new OrderBy(), new Limit());
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(queryClone, where.getCriteria());
        HashMap columnReaders = new HashMap();
        queryClone.getColumns().forEach(selectable -> {
            ResultSetReader cfr_ignored_0 = (ResultSetReader)columnReaders.put((Selectable<?>)selectable, (ResultSetReader<?>)this.dialect.getColumnBinderRegistry().getBinder((Object)((Column)selectable)));
        });
        orderByClauseConsumer.accept((OrderByChain<?>)queryClone.orderBy());
        limitAwareConsumer.accept((LimitAware<?>)queryClone.orderBy());
        Map<Class, Set<I>> idsPerSubtype = this.readIds(sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap()), columnReaders, this.query.getAliases());
        Set ids = idsPerSubtype.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (this.hasSubPolymorphicPersister) {
            this.LOGGER.debug("Asking sub-polymorphic persisters to load the entities");
            HashSet result = new HashSet();
            idsPerSubtype.forEach((k, v) -> result.addAll(((ConfiguredRelationalPersister)this.persisterPerSubclass.get(k)).select((Iterable)v)));
            return result;
        }
        return this.selectWithSingleQuery(this.newWhereIdClause(ids), orderByChain -> {}, limitAware -> {});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<Class, Set<I>> readIds(PreparedSQL preparedSQL, Map<Selectable<?>, ResultSetReader<?>> columnReaders, Map<Selectable<?>, String> aliases) {
        KeepOrderMap result = new KeepOrderMap();
        try (ReadOperation readOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            ColumnedRowIterator resultSetIterator = new ColumnedRowIterator(resultSet, columnReaders, aliases);
            resultSetIterator.forEachRemaining(arg_0 -> this.lambda$readIds$7((Map)result, arg_0));
            KeepOrderMap keepOrderMap = result;
            return keepOrderMap;
        }
        catch (RuntimeException e) {
            throw new SQLExecutionException(preparedSQL.getSQL(), (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$readIds$7(Map result, ColumnedRow row) {
        Set entries = this.persisterPerSubclass.entrySet();
        Duo duo = null;
        for (Map.Entry entry : entries) {
            Object identifier = ((ConfiguredRelationalPersister)entry.getValue()).getMapping().getIdMapping().getIdentifierAssembler().assemble(row);
            if (identifier == null) continue;
            duo = new Duo(entry.getKey(), identifier);
            break;
        }
        result.computeIfAbsent(duo.getLeft(), k -> new HashSet()).add(duo.getRight());
    }

    private static class SingleLoadEntityJoinTree<C, I>
    extends EntityJoinTree<C, I> {
        public <T extends Table<T>> SingleLoadEntityJoinTree(ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters) {
            super((EntityJoinTree<C, I> tree) -> new JoinTableRootJoinNode(tree, mainPersister, subPersisters, mainPersister.getMapping().getSelectableColumns(), mainPersister.getMainTable()));
        }

        @Override
        public JoinTableRootJoinNode<C, I, ?> getRoot() {
            return (JoinTableRootJoinNode)super.getRoot();
        }
    }
}

