/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.nativ;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.spring.repository.query.NativeQueries;
import org.codefilarete.stalactite.spring.repository.query.NativeQuery;
import org.codefilarete.stalactite.spring.repository.query.nativ.NativeQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.nativ.SqlNativeRepositoryQuery;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.VisibleForTesting;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;

public class NativeQueryLookupStrategy<C>
implements QueryLookupStrategy {
    private final Dialect dialect;
    private final ConnectionProvider connectionProvider;
    private final AdvancedEntityPersister<C, ?> entityPersister;

    public NativeQueryLookupStrategy(AdvancedEntityPersister<C, ?> entityPersister, Dialect dialect, ConnectionProvider connectionProvider) {
        this.entityPersister = entityPersister;
        this.dialect = dialect;
        this.connectionProvider = connectionProvider;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        String sql = this.findSQL(method);
        if (sql != null) {
            NativeQueryMethod queryMethod = new NativeQueryMethod(method, metadata, factory);
            Accumulator accumulator = queryMethod.isCollectionQuery() ? Accumulators.toKeepingOrderSet() : Accumulators.getFirstUnique();
            return new SqlNativeRepositoryQuery<C>(queryMethod, sql, this.entityPersister, accumulator, this.dialect, this.connectionProvider);
        }
        return null;
    }

    @javax.annotation.Nullable
    @VisibleForTesting
    String findSQL(Method method) {
        Nullable queries = Nullable.nullable((Object)method.getAnnotation(NativeQueries.class)).map(NativeQueries::value).map(Arrays::asList);
        if (queries.isPresent()) {
            TreeMap dialectPerSortedCompatibility = new TreeMap(ServiceLoaderDialectResolver.DatabaseSignet.COMPARATOR);
            ((List)queries.get()).forEach(query -> dialectPerSortedCompatibility.merge(new ServiceLoaderDialectResolver.DatabaseSignet(query.vendor(), query.major(), query.minor()), query, (c1, c2) -> {
                String printableSignet = Strings.footPrint((Object)new ServiceLoaderDialectResolver.DatabaseSignet(c1.vendor(), c1.major(), c1.minor()), (Function[])new Function[]{ServiceLoaderDialectResolver.DatabaseSignet::toString});
                throw new IllegalStateException("Multiple queries with same database compatibility found on method " + Reflections.toString((Method)method) + " : " + printableSignet);
            }));
            ServiceLoaderDialectResolver.DatabaseSignet currentSignet = this.dialect.getCompatibility();
            Map.Entry foundEntry = dialectPerSortedCompatibility.floorEntry(currentSignet);
            return (String)Nullable.nullable(foundEntry).map(e -> ((NativeQuery)e.getValue()).value()).get();
        }
        Nullable queryAnnotation = Nullable.nullable((Object)method.getAnnotation(NativeQuery.class));
        if (queryAnnotation.isPresent()) {
            NativeQuery nativeQuery = (NativeQuery)queryAnnotation.get();
            int comparison = ServiceLoaderDialectResolver.DatabaseSignet.COMPARATOR.compare(this.dialect.getCompatibility(), new ServiceLoaderDialectResolver.DatabaseSignet(nativeQuery.vendor(), nativeQuery.major(), nativeQuery.minor()));
            if (comparison >= 0) {
                return nativeQuery.value();
            }
        }
        return null;
    }
}

