/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class JoinRootTest {
    JoinRootTest() {
    }

    static ClassMapping buildMappingStrategyMock(String tableName) {
        return JoinRootTest.buildMappingStrategyMock(new Table(tableName));
    }

    static ClassMapping buildMappingStrategyMock(Table table) {
        ClassMapping mappingStrategyMock = (ClassMapping)Mockito.mock(ClassMapping.class);
        Mockito.when((Object)mappingStrategyMock.getTargetTable()).thenReturn((Object)table);
        Mockito.when((Object)mappingStrategyMock.getSelectableColumns()).thenAnswer(invocation -> table.getColumns());
        return mappingStrategyMock;
    }

    @Test
    public void addRelationJoin_targetNodeDoesntExist_throwsException() {
        Table table = new Table("toto");
        ClassMapping mappingStrategyMock = JoinRootTest.buildMappingStrategyMock(table);
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)mappingStrategyMock), (Fromable)table);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> entityJoinTree.addRelationJoin("XX", null, (Accessor)Mockito.mock(Accessor.class), null, null, null, EntityJoinTree.JoinType.OUTER, null, Collections.emptySet())).isInstanceOf(IllegalArgumentException.class)).hasMessage("No join named XX exists to add a new join on");
    }

    @Test
    public void giveTables() {
        ClassMapping totoMappingMock = JoinRootTest.buildMappingStrategyMock("Toto");
        Table totoTable = totoMappingMock.getTargetTable();
        totoTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey totoPrimaryKey = totoTable.getPrimaryKey();
        ClassMapping tataMappingMock = JoinRootTest.buildMappingStrategyMock("Tata");
        Table tataTable = tataMappingMock.getTargetTable();
        tataTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tataPrimaryKey = tataTable.getPrimaryKey();
        ClassMapping tutuMappingMock = JoinRootTest.buildMappingStrategyMock("Tutu");
        Table tutuTable = tutuMappingMock.getTargetTable();
        tutuTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey tutuPrimaryKey = tutuTable.getPrimaryKey();
        ClassMapping titiMappingMock = JoinRootTest.buildMappingStrategyMock("Titi");
        Table titiTable = titiMappingMock.getTargetTable();
        titiTable.addColumn("id", Long.TYPE).primaryKey();
        PrimaryKey titiPrimaryKey = titiTable.getPrimaryKey();
        EntityJoinTree entityJoinTree = new EntityJoinTree((EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)totoMappingMock), (Fromable)totoMappingMock.getTargetTable());
        String tataAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tataMappingMock), (Accessor)Mockito.mock(Accessor.class), (Key)totoPrimaryKey, (Key)tataPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String tutuAddKey = entityJoinTree.addRelationJoin(tataAddKey, (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)tutuMappingMock), (Accessor)Mockito.mock(Accessor.class), (Key)tataPrimaryKey, (Key)tutuPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        String titiAddKey = entityJoinTree.addRelationJoin("ROOT", (EntityInflater)new EntityInflater.EntityMappingAdapter((EntityMapping)titiMappingMock), (Accessor)Mockito.mock(Accessor.class), (Key)totoPrimaryKey, (Key)titiPrimaryKey, null, EntityJoinTree.JoinType.INNER, null, Collections.emptySet());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)entityJoinTree.giveTables()).usingElementComparator(Table.COMPARATOR_ON_SCHEMA_AND_NAME)).containsExactlyInAnyOrder((Object[])new Table[]{totoTable, tataTable, tutuTable, titiTable});
    }
}

