/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.DialectBuilder;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.SQLOperationsFactories;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.OperatorSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.UnitaryOperator;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.DialectOptions;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.QuerySQLBuilderFactoryBuilder;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSQL;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.PreparedUpdate;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Sorter;
import org.codefilarete.tool.trace.MutableLong;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

class DialectBuilderTest {
    private DatabaseVendorSettings defaultDatabaseVendorSettings;

    DialectBuilderTest() {
    }

    @BeforeEach
    void initialize() {
        ParameterBinderRegistry parameterBinderRegistry = new ParameterBinderRegistry();
        DefaultTypeMapping defaultTypeMapping = new DefaultTypeMapping();
        this.defaultDatabaseVendorSettings = new DatabaseVendorSettings(new ServiceLoaderDialectResolver.DatabaseSignet("my_vendor", 1, 0), (Set)Arrays.asSet((Object[])new String[]{"a_keyword"}), '\'', (JavaTypeToSqlTypeMapping)defaultTypeMapping, parameterBinderRegistry, (parameterBinders, dmlNameProviderFactory, sqlTypeRegistry) -> {
            DMLGenerator dmlGenerator = new DMLGenerator(parameterBinders, (Sorter)DMLGenerator.NoopSorter.INSTANCE, dmlNameProviderFactory);
            DDLTableGenerator ddlTableGenerator = new DDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
            DDLSequenceGenerator ddlSequenceGenerator = new DDLSequenceGenerator(dmlNameProviderFactory);
            return new SQLOperationsFactories(new WriteOperationFactory(), new ReadOperationFactory(), dmlGenerator, ddlTableGenerator, ddlSequenceGenerator, (databaseSequence, connectionProvider) -> {
                MutableLong counter = new MutableLong();
                return () -> ((MutableLong)counter).increment();
            });
        }, (GeneratedKeysReaderFactory)new GeneratedKeysReaderFactory.DefaultGeneratedKeysReaderFactory(parameterBinderRegistry), 100, false);
    }

    @Nested
    class BuildWithOptions {
        BuildWithOptions() {
        }

        @Test
        <T extends Table<T>> void quoteSQLIdentifiers_sqlIdentifiersAreQuoted() {
            DialectOptions dialectOptions = new DialectOptions();
            dialectOptions.quoteSQLIdentifiers();
            dialectOptions.setQuoteCharacter('`');
            DialectBuilder testInstance = new DialectBuilder(DialectBuilderTest.this.defaultDatabaseVendorSettings, dialectOptions);
            Dialect dialect = testInstance.build();
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", Long.TYPE);
            Column nameColumn = totoTable.addColumn("name", String.class);
            String totoTableCreateScript = dialect.getDdlTableGenerator().generateCreateTable(totoTable);
            Assertions.assertThat((String)totoTableCreateScript).isEqualTo("create table `Toto`(`id` bigint not null, `name` varchar)");
            String sequenceScript = dialect.getDdlSequenceGenerator().generateCreateSequence(new Sequence(null, "tOtO"));
            Assertions.assertThat((String)sequenceScript).isEqualTo("create sequence `tOtO`");
            ColumnParameterizedSQL insert = dialect.getDmlGenerator().buildInsert((Iterable)Arrays.asList((Object[])new Column[]{idColumn, nameColumn}));
            Assertions.assertThat((String)insert.getSQL()).isEqualTo("insert into `Toto`(`id`, `name`) values (?, ?)");
            PreparedUpdate update = dialect.getDmlGenerator().buildUpdate((Iterable)Arrays.asList((Object[])new Column[]{idColumn, nameColumn}), (Iterable)Arrays.asList((Object[])new Column[]{idColumn}));
            Assertions.assertThat((String)update.getSQL()).isEqualTo("update `Toto` set `id` = ?, `name` = ? where `id` = ?");
            ColumnParameterizedSQL delete = dialect.getDmlGenerator().buildDelete(totoTable, (Iterable)Arrays.asList((Object[])new Column[]{idColumn}));
            Assertions.assertThat((String)delete.getSQL()).isEqualTo("delete from `Toto` where `id` = ?");
            ColumnParameterizedSQL select = dialect.getDmlGenerator().buildSelect(totoTable, (Iterable)Arrays.asList((Object[])new Column[]{idColumn}), (Iterable)Arrays.asList((Object[])new Column[]{idColumn}));
            Assertions.assertThat((String)select.getSQL()).isEqualTo("select `id` from `Toto` where `id` = ?");
            Query query = new Query((Fromable)totoTable);
            query.select((Selectable)idColumn, new Selectable[0]);
            query.where(idColumn, (ConditionalOperator)Operators.eq((Object)idColumn));
            query.groupBy(idColumn, new Column[0]);
            query.having(new Object[]{idColumn, Operators.eq((Object)idColumn)});
            Assertions.assertThat((String)dialect.getQuerySQLBuilderFactory().queryBuilder(query).toSQL()).isEqualTo("select `Toto`.`id` from `Toto` where `Toto`.`id` = `Toto`.`id` group by `Toto`.`id` having `Toto`.`id`= `Toto`.`id`");
        }

        @Test
        <T extends Table<T>> void withNewTypeBinding_bindingIsApplied() {
            ParameterBinder dummyParameterBinder = (ParameterBinder)Mockito.mock(ParameterBinder.class);
            DialectOptions dialectOptions = new DialectOptions();
            class DummyType {
                DummyType() {
                }
            }
            dialectOptions.addTypeBinding(DummyType.class, "a SQL type", dummyParameterBinder);
            DialectBuilder testInstance = new DialectBuilder(DialectBuilderTest.this.defaultDatabaseVendorSettings, dialectOptions);
            Dialect dialect = testInstance.build();
            Assertions.assertThat((Object)dialect.getColumnBinderRegistry().getBinder(DummyType.class)).isEqualTo((Object)dummyParameterBinder);
            Table dummyTable = new Table("Dummy");
            Column dummyColumn = dummyTable.addColumn("id", DummyType.class);
            Assertions.assertThat((String)dialect.getSqlTypeRegistry().getTypeName(dummyColumn)).isEqualTo("a SQL type");
        }

        @Test
        void operatorPrintIsOverridden_itIsTakenIntoAccountInDeleteAndQuery() throws SQLException {
            DialectBuilder testInstance = new DialectBuilder(DialectBuilderTest.this.defaultDatabaseVendorSettings){

                protected QuerySQLBuilderFactoryBuilder createQuerySQLBuilderFactoryBuilder(DMLNameProviderFactory dmlNameProviderFactory, ColumnBinderRegistry columnBinderRegistry) {
                    QuerySQLBuilderFactoryBuilder querySQLBuilderFactoryBuilder = super.createQuerySQLBuilderFactoryBuilder(dmlNameProviderFactory, columnBinderRegistry);
                    querySQLBuilderFactoryBuilder.withOperatorSQLBuilderFactory(new OperatorSQLBuilderFactory(){

                        public OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSQLBuilder(FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
                            return new OperatorSQLBuilderFactory.OperatorSQLBuilder(functionSQLBuilder){

                                public <V> void cat(Selectable<V> column, ConditionalOperator<?, V> operator, SQLAppender sql) {
                                    if (operator instanceof Like) {
                                        sql.cat("LIKE ", new String[0]).catValue((Object)((Like)operator).getValue());
                                    } else {
                                        super.cat(column, operator, sql);
                                    }
                                }
                            };
                        }
                    });
                    return querySQLBuilderFactoryBuilder;
                }
            };
            Dialect dialect = testInstance.build();
            Connection connectionMock = (Connection)Mockito.mock(Connection.class);
            ArgumentCaptor sqlCaptor = ArgumentCaptor.forClass(String.class);
            PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet(Collections.emptySet()));
            Mockito.when((Object)connectionMock.prepareStatement((String)sqlCaptor.capture())).thenReturn((Object)preparedStatementMock);
            PersistenceContext persistenceContext = new PersistenceContext(() -> connectionMock, dialect);
            Table dummyTable = new Table("dummyTable");
            Column dummyColumn = dummyTable.addColumn("dummyColumn", String.class);
            persistenceContext.newQuery((QueryProvider)QueryEase.select((Selectable)dummyColumn, (Selectable[])new Selectable[0]).from((Fromable)dummyTable).where(dummyColumn, (ConditionalOperator)Operators.like((CharSequence)"x")), String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)((String)sqlCaptor.getValue())).isEqualTo("select dummyTable.dummyColumn from dummyTable where dummyTable.dummyColumn LIKE 'x'");
            persistenceContext.delete(dummyTable, QueryEase.where((Selectable)dummyColumn, (ConditionalOperator)Operators.like((CharSequence)"x"))).execute();
            Assertions.assertThat((String)((String)sqlCaptor.getValue())).isEqualTo("delete from dummyTable where dummyColumn LIKE ?");
        }

        @Test
        void userDefinedOperatorCanBeTakenIntoAccountByOperatorSQLBuilderOverride() throws SQLException {
            DialectBuilder testInstance = new DialectBuilder(DialectBuilderTest.this.defaultDatabaseVendorSettings){

                protected QuerySQLBuilderFactoryBuilder createQuerySQLBuilderFactoryBuilder(DMLNameProviderFactory dmlNameProviderFactory, ColumnBinderRegistry columnBinderRegistry) {
                    QuerySQLBuilderFactoryBuilder querySQLBuilderFactoryBuilder = super.createQuerySQLBuilderFactoryBuilder(dmlNameProviderFactory, columnBinderRegistry);
                    querySQLBuilderFactoryBuilder.withOperatorSQLBuilderFactory(new OperatorSQLBuilderFactory(){

                        public OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSQLBuilder(FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
                            return new OperatorSQLBuilderFactory.OperatorSQLBuilder(functionSQLBuilder){

                                public <V> void cat(Selectable<V> column, ConditionalOperator<?, V> operator, SQLAppender sql) {
                                    class MyOperator
                                    extends UnitaryOperator<String> {
                                        public MyOperator(String value) {
                                            super((Object)value);
                                        }
                                    }
                                    if (operator instanceof MyOperator) {
                                        sql.cat("myOperator ", new String[0]).catValue((Object)((MyOperator)operator).getValue());
                                    } else {
                                        super.cat(column, operator, sql);
                                    }
                                }
                            };
                        }
                    });
                    return querySQLBuilderFactoryBuilder;
                }
            };
            Dialect dialect = testInstance.build();
            Connection connectionMock = (Connection)Mockito.mock(Connection.class);
            ArgumentCaptor sqlCaptor = ArgumentCaptor.forClass(String.class);
            PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet(Collections.emptySet()));
            Mockito.when((Object)connectionMock.prepareStatement((String)sqlCaptor.capture())).thenReturn((Object)preparedStatementMock);
            PersistenceContext persistenceContext = new PersistenceContext(() -> connectionMock, dialect);
            Table dummyTable = new Table("dummyTable");
            Column dummyColumn = dummyTable.addColumn("dummyColumn", String.class);
            persistenceContext.newQuery((QueryProvider)QueryEase.select((Selectable)dummyColumn, (Selectable[])new Selectable[0]).from((Fromable)dummyTable).where(dummyColumn, (ConditionalOperator)new MyOperator("42")), String.class).execute(Accumulators.getFirst());
            Assertions.assertThat((String)((String)sqlCaptor.getValue())).isEqualTo("select dummyTable.dummyColumn from dummyTable where dummyTable.dummyColumn myOperator '42'");
            persistenceContext.delete(dummyTable, QueryEase.where((Selectable)dummyColumn, (ConditionalOperator)new MyOperator("42"))).execute();
            Assertions.assertThat((String)((String)sqlCaptor.getValue())).isEqualTo("delete from dummyTable where dummyColumn myOperator ?");
        }
    }

    @Nested
    class Keywords {
        Keywords() {
        }

        @Test
        <T extends Table<T>> void keywordsAreEscaped() {
            DialectBuilder testInstance = new DialectBuilder(DialectBuilderTest.this.defaultDatabaseVendorSettings);
            Dialect dialect = testInstance.build();
            Table keywordNamedTable = new Table("a_KeYworD");
            Column idColumn = keywordNamedTable.addColumn("id", Long.TYPE);
            Column nameColumn = keywordNamedTable.addColumn("name", String.class);
            String totoTableCreateScript = dialect.getDdlTableGenerator().generateCreateTable(keywordNamedTable);
            Assertions.assertThat((String)totoTableCreateScript).isEqualTo("create table 'a_KeYworD'(id bigint not null, name varchar)");
            String sequenceScript = dialect.getDdlSequenceGenerator().generateCreateSequence(new Sequence(null, "A_KeywOrD"));
            Assertions.assertThat((String)sequenceScript).isEqualTo("create sequence 'A_KeywOrD'");
            ColumnParameterizedSQL insert = dialect.getDmlGenerator().buildInsert((Iterable)Arrays.asList((Object[])new Column[]{idColumn, nameColumn}));
            Assertions.assertThat((String)insert.getSQL()).isEqualTo("insert into 'a_KeYworD'(id, name) values (?, ?)");
            PreparedUpdate update = dialect.getDmlGenerator().buildUpdate((Iterable)Arrays.asList((Object[])new Column[]{idColumn, nameColumn}), (Iterable)Arrays.asList((Object[])new Column[]{idColumn}));
            Assertions.assertThat((String)update.getSQL()).isEqualTo("update 'a_KeYworD' set id = ?, name = ? where id = ?");
            ColumnParameterizedSQL delete = dialect.getDmlGenerator().buildDelete(keywordNamedTable, (Iterable)Arrays.asList((Object[])new Column[]{idColumn}));
            Assertions.assertThat((String)delete.getSQL()).isEqualTo("delete from 'a_KeYworD' where id = ?");
            ColumnParameterizedSQL select = dialect.getDmlGenerator().buildSelect(keywordNamedTable, (Iterable)Arrays.asList((Object[])new Column[]{idColumn}), (Iterable)Arrays.asList((Object[])new Column[]{idColumn}));
            Assertions.assertThat((String)select.getSQL()).isEqualTo("select id from 'a_KeYworD' where id = ?");
        }

        @Test
        <T extends Table<T>> void keywordsCanBeChanged() {
            DialectBuilder testInstance = new DialectBuilder(DialectBuilderTest.this.defaultDatabaseVendorSettings, new DialectOptions().addSqlKeywords(new String[]{"another_keyword"}).removeSqlKeywords(new String[]{"a_keyWOrd"}));
            Dialect dialect = testInstance.build();
            Table keywordNamedTable = new Table("a_KeYworD");
            Column idColumn = keywordNamedTable.addColumn("another_keyword", Long.TYPE);
            Column nameColumn = keywordNamedTable.addColumn("name", String.class);
            String totoTableCreateScript = dialect.getDdlTableGenerator().generateCreateTable(keywordNamedTable);
            Assertions.assertThat((String)totoTableCreateScript).isEqualTo("create table a_KeYworD('another_keyword' bigint not null, name varchar)");
            String sequenceScript = dialect.getDdlSequenceGenerator().generateCreateSequence(new Sequence(null, "A_KeywOrD"));
            Assertions.assertThat((String)sequenceScript).isEqualTo("create sequence A_KeywOrD");
            ColumnParameterizedSQL insert = dialect.getDmlGenerator().buildInsert((Iterable)Arrays.asList((Object[])new Column[]{idColumn, nameColumn}));
            Assertions.assertThat((String)insert.getSQL()).isEqualTo("insert into a_KeYworD('another_keyword', name) values (?, ?)");
            PreparedUpdate update = dialect.getDmlGenerator().buildUpdate((Iterable)Arrays.asList((Object[])new Column[]{idColumn, nameColumn}), (Iterable)Arrays.asList((Object[])new Column[]{idColumn}));
            Assertions.assertThat((String)update.getSQL()).isEqualTo("update a_KeYworD set 'another_keyword' = ?, name = ? where 'another_keyword' = ?");
            ColumnParameterizedSQL delete = dialect.getDmlGenerator().buildDelete(keywordNamedTable, (Iterable)Arrays.asList((Object[])new Column[]{idColumn}));
            Assertions.assertThat((String)delete.getSQL()).isEqualTo("delete from a_KeYworD where 'another_keyword' = ?");
            ColumnParameterizedSQL select = dialect.getDmlGenerator().buildSelect(keywordNamedTable, (Iterable)Arrays.asList((Object[])new Column[]{idColumn}), (Iterable)Arrays.asList((Object[])new Column[]{idColumn}));
            Assertions.assertThat((String)select.getSQL()).isEqualTo("select 'another_keyword' from a_KeYworD where 'another_keyword' = ?");
        }
    }
}

