/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.elementcollection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.ColumnNamingStrategy;
import org.codefilarete.stalactite.engine.ElementCollectionTableNamingStrategy;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.cascade.AfterInsertCollectionCascader;
import org.codefilarete.stalactite.engine.configurer.BeanMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.RelationConfigurer;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementCollectionRelation;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementRecord;
import org.codefilarete.stalactite.engine.configurer.elementcollection.ElementRecordMapping;
import org.codefilarete.stalactite.engine.runtime.CollectionUpdater;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EmbeddedClassMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.PairIterator;

public class ElementCollectionRelationConfigurer<SRC, TRGT, I, C extends Collection<TRGT>> {
    private static final AccessorDefinition ELEMENT_RECORD_ID_ACCESSOR_DEFINITION = AccessorDefinition.giveDefinition((ValueAccessPoint)new AccessorByMethodReference(ElementRecord::getId));
    private final ConfiguredRelationalPersister<SRC, I> sourcePersister;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final ColumnNamingStrategy columnNamingStrategy;
    private final ElementCollectionTableNamingStrategy tableNamingStrategy;
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;

    public ElementCollectionRelationConfigurer(ConfiguredRelationalPersister<SRC, I> sourcePersister, ForeignKeyNamingStrategy foreignKeyNamingStrategy, ColumnNamingStrategy columnNamingStrategy, ElementCollectionTableNamingStrategy tableNamingStrategy, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        this.sourcePersister = sourcePersister;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.columnNamingStrategy = columnNamingStrategy;
        this.tableNamingStrategy = tableNamingStrategy;
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
    }

    public <SRCTABLE extends Table<SRCTABLE>, COLLECTIONTABLE extends Table<COLLECTIONTABLE>> void configure(ElementCollectionRelation<SRC, TRGT, C> elementCollectionRelation) {
        AccessorDefinition collectionProviderDefinition = AccessorDefinition.giveDefinition(elementCollectionRelation.getCollectionProvider());
        PrimaryKey sourcePK = this.sourcePersister.getMapping().getTargetTable().getPrimaryKey();
        ElementCollectionMapping<SRCTABLE, COLLECTIONTABLE> elementCollectionMapping = this.buildCollectionTableMapping(elementCollectionRelation, collectionProviderDefinition, sourcePK);
        final ElementRecordPersister collectionPersister = new ElementRecordPersister(elementCollectionMapping.elementRecordMapping, this.dialect, this.connectionConfiguration);
        ReversibleAccessor<SRC, C> collectionAccessor = elementCollectionRelation.getCollectionProvider();
        this.addInsertCascade(this.sourcePersister, collectionPersister, (Accessor<SRC, C>)collectionAccessor);
        this.addUpdateCascade(this.sourcePersister, collectionPersister, (Accessor<SRC, C>)collectionAccessor);
        this.addDeleteCascade(this.sourcePersister, collectionPersister, (Accessor<SRC, C>)collectionAccessor);
        Supplier collectionFactory = (Supplier)Objects.preventNull(elementCollectionRelation.getCollectionFactory(), (Object)BeanRelationFixer.giveCollectionFactory((Class)collectionProviderDefinition.getMemberType()));
        this.addSelectCascade(this.sourcePersister, collectionPersister, sourcePK, elementCollectionMapping.reverseForeignKey, (arg_0, arg_1) -> ((Mutator)elementCollectionRelation.getCollectionProvider().toMutator()).set(arg_0, arg_1), arg_0 -> collectionAccessor.get(arg_0), collectionFactory);
        PersisterBuilderContext currentBuilderContext = PersisterBuilderContext.CURRENT.get();
        currentBuilderContext.addBuildLifeCycleListener(new RelationConfigurer.GraphLoadingRelationRegisterer<SRC, I, TRGT>(elementCollectionRelation.getComponentType(), elementCollectionRelation.getCollectionProvider(), this.sourcePersister.getClassToPersist()){

            @Override
            public void consume(ConfiguredRelationalPersister<TRGT, ?> targetPersister) {
                super.consume(collectionPersister);
            }
        });
    }

    private <SRCTABLE extends Table<SRCTABLE>, COLLECTIONTABLE extends Table<COLLECTIONTABLE>> ElementCollectionMapping<SRCTABLE, COLLECTIONTABLE> buildCollectionTableMapping(final ElementCollectionRelation<SRC, TRGT, C> linkage, AccessorDefinition collectionProviderDefinition, PrimaryKey<SRCTABLE, I> sourcePK) {
        ElementRecordMapping elementRecordMapping;
        String tableName = (String)Nullable.nullable((Object)linkage.getTargetTableName()).getOr(() -> this.tableNamingStrategy.giveName(collectionProviderDefinition));
        Table targetTable = (Table)Nullable.nullable((Object)linkage.getTargetTable()).getOr(() -> new Table(tableName));
        HashMap primaryKeyForeignColumnMapping = new HashMap();
        Column reverseColumn = linkage.getReverseColumn();
        Key reverseKey = (Key)Nullable.nullable(reverseColumn).map(Key::ofSingleColumn).getOr(() -> {
            Key.KeyBuilder result = Key.from((Fromable)targetTable);
            sourcePK.getColumns().forEach(col -> {
                String reverseColumnName = (String)Nullable.nullable((Object)linkage.getReverseColumnName()).getOr(() -> this.columnNamingStrategy.giveName(ELEMENT_RECORD_ID_ACCESSOR_DEFINITION));
                Column reverseCol = targetTable.addColumn(reverseColumnName, col.getJavaType()).primaryKey();
                primaryKeyForeignColumnMapping.put(col, reverseCol);
                result.addColumn((JoinLink)reverseCol);
            });
            return result.build();
        });
        ForeignKey reverseForeignKey = targetTable.addForeignKey(this.foreignKeyNamingStrategy::giveName, reverseKey, sourcePK);
        this.registerColumnBinder(reverseForeignKey, sourcePK);
        EmbeddableMappingConfiguration embeddableConfiguration = (EmbeddableMappingConfiguration)Nullable.nullable(linkage.getEmbeddableConfigurationProvider()).map(EmbeddableMappingConfigurationProvider::getConfiguration).get();
        IdentifierAssembler sourceIdentifierAssembler = this.sourcePersister.getMapping().getIdMapping().getIdentifierAssembler();
        if (embeddableConfiguration == null) {
            String columnName = (String)Nullable.nullable((Object)linkage.getElementColumnName()).getOr(() -> this.columnNamingStrategy.giveName(collectionProviderDefinition));
            Column elementColumn = targetTable.addColumn(columnName, linkage.getComponentType());
            if (collectionProviderDefinition.getMemberType().isAssignableFrom(Set.class)) {
                elementColumn.primaryKey();
            }
            elementRecordMapping = new ElementRecordMapping(targetTable, elementColumn, sourceIdentifierAssembler, primaryKeyForeignColumnMapping);
        } else {
            BeanMappingBuilder elementCollectionMappingBuilder = new BeanMappingBuilder(embeddableConfiguration, targetTable, this.dialect.getColumnBinderRegistry(), new BeanMappingBuilder.ColumnNameProvider(this.columnNamingStrategy){

                @Override
                protected String giveColumnName(BeanMappingBuilder.BeanMappingConfiguration.Linkage pawn) {
                    return (String)Nullable.nullable((Object)linkage.getOverriddenColumnNames().get(pawn.getAccessor())).getOr(() -> super.giveColumnName(pawn));
                }
            });
            Map columnMapping = elementCollectionMappingBuilder.build().getMapping();
            HashMap projectedColumnMap = new HashMap();
            columnMapping.forEach((propertyAccessor, column) -> {
                AccessorChain accessorChain = AccessorChain.chainNullSafe((List)Arrays.asList((Object[])new ReversibleAccessor[]{ElementRecord.ELEMENT_ACCESSOR, propertyAccessor}), (accessor, valueType) -> {
                    if (accessor == ElementRecord.ELEMENT_ACCESSOR) {
                        return Reflections.newInstance(embeddableConfiguration.getBeanType());
                    }
                    return AccessorChain.ValueInitializerOnNullValue.newInstance((Accessor)accessor, (Class)valueType);
                });
                projectedColumnMap.put(accessorChain, column);
                column.primaryKey();
            });
            Class<ElementRecord> elementRecordClass = ElementRecord.class;
            EmbeddedClassMapping elementRecordMappingStrategy = new EmbeddedClassMapping(elementRecordClass, targetTable, projectedColumnMap);
            elementRecordMapping = new ElementRecordMapping(targetTable, elementRecordMappingStrategy, sourceIdentifierAssembler, primaryKeyForeignColumnMapping);
        }
        return new ElementCollectionMapping(reverseForeignKey, elementRecordMapping);
    }

    private void registerColumnBinder(ForeignKey<?, ?, I> reverseColumn, PrimaryKey<?, I> sourcePK) {
        PairIterator pairIterator = new PairIterator((Iterable)reverseColumn.getColumns(), (Iterable)sourcePK.getColumns());
        pairIterator.forEachRemaining(col -> {
            this.dialect.getColumnBinderRegistry().register((Column)col.getLeft(), this.dialect.getColumnBinderRegistry().getBinder(col.getRight()));
            this.dialect.getSqlTypeRegistry().put((Column)col.getLeft(), this.dialect.getSqlTypeRegistry().getTypeName((Column)col.getRight()));
        });
    }

    private void addInsertCascade(ConfiguredRelationalPersister<SRC, I> sourcePersister, EntityPersister<ElementRecord<TRGT, I>, ElementRecord<TRGT, I>> wrapperPersister, Accessor<SRC, C> collectionAccessor) {
        Function<SRC, Collection<ElementRecord<TRGT, I>>> collectionProviderForInsert = this.collectionProvider(collectionAccessor, (IdAccessor<SRC, I>)sourcePersister.getMapping(), false);
        sourcePersister.addInsertListener(new TargetInstancesInsertCascader<SRC, TRGT, I>(wrapperPersister, collectionProviderForInsert));
    }

    private void addUpdateCascade(ConfiguredRelationalPersister<SRC, I> sourcePersister, final EntityPersister<ElementRecord<TRGT, I>, ElementRecord<TRGT, I>> elementRecordPersister, Accessor<SRC, C> collectionAccessor) {
        Function<SRC, Collection<ElementRecord<TRGT, I>>> collectionProviderAsPersistedInstances = this.collectionProvider(collectionAccessor, (IdAccessor<SRC, I>)sourcePersister.getMapping(), true);
        CollectionUpdater collectionUpdater = new CollectionUpdater<SRC, ElementRecord<TRGT, I>, Collection<ElementRecord<TRGT, I>>>(collectionProviderAsPersistedInstances, elementRecordPersister, (o, i) -> {}, true, ElementRecord::footprint){

            @Override
            protected void insertTargets(CollectionUpdater.UpdateContext updateContext) {
                elementRecordPersister.insert(updateContext.getAddedElements());
            }
        };
        sourcePersister.addUpdateListener(new OneToManyWithMappedAssociationEngine.AfterUpdateTrigger(collectionUpdater));
    }

    private void addDeleteCascade(ConfiguredRelationalPersister<SRC, I> sourcePersister, EntityPersister<ElementRecord<TRGT, I>, ElementRecord<TRGT, I>> wrapperPersister, Accessor<SRC, C> collectionAccessor) {
        Function<SRC, Collection<ElementRecord<TRGT, I>>> collectionProviderAsPersistedInstances = this.collectionProvider(collectionAccessor, (IdAccessor<SRC, I>)sourcePersister.getMapping(), true);
        sourcePersister.addDeleteListener(new OneToManyWithMappedAssociationEngine.DeleteTargetEntitiesBeforeDeleteCascader<SRC, ElementRecord<TRGT, I>>(wrapperPersister, collectionProviderAsPersistedInstances));
    }

    private void addSelectCascade(ConfiguredRelationalPersister<SRC, I> sourcePersister, RelationalEntityPersister<ElementRecord<TRGT, I>, ElementRecord<TRGT, I>> elementRecordPersister, PrimaryKey<?, I> sourcePK, ForeignKey<?, ?, I> elementRecordToSourceForeignKey, BiConsumer<SRC, C> collectionSetter, Function<SRC, C> collectionGetter, Supplier<C> collectionFactory) {
        BeanRelationFixer relationFixer = BeanRelationFixer.ofAdapter(collectionSetter, collectionGetter, collectionFactory, (bean, input, collection) -> collection.add(input.getElement()));
        elementRecordPersister.joinAsMany(sourcePersister, sourcePK, elementRecordToSourceForeignKey, relationFixer, (Function<ColumnedRow, Object>)null, "ROOT", true, false);
    }

    private Function<SRC, Collection<ElementRecord<TRGT, I>>> collectionProvider(Accessor<SRC, C> collectionAccessor, IdAccessor<SRC, I> idAccessor, boolean markAsPersisted) {
        return src -> (HashSet)Iterables.collect((Iterable)((Iterable)Nullable.nullable((Object)collectionAccessor.get(src)).getOr(() -> new ArrayList())), trgt -> new ElementRecord<Object, Object>(idAccessor.getId(src), trgt).setPersisted(markAsPersisted), HashSet::new);
    }

    public static class ElementRecordPersister<TRGT, ID, T extends Table<T>>
    extends SimpleRelationalEntityPersister<ElementRecord<TRGT, ID>, ElementRecord<TRGT, ID>, T> {
        public ElementRecordPersister(ClassMapping<ElementRecord<TRGT, ID>, ElementRecord<TRGT, ID>, T> elementRecordMapping, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
            super(elementRecordMapping, dialect, connectionConfiguration);
        }

        @Override
        public Column getColumn(List<? extends ValueAccessPoint<?>> accessorChain) {
            return (Column)Iterables.first((Iterable)this.getMapping().getSelectableColumns());
        }
    }

    private static class TargetInstancesInsertCascader<SRC, TRGT, ID>
    extends AfterInsertCollectionCascader<SRC, ElementRecord<TRGT, ID>> {
        private final Function<SRC, ? extends Collection<ElementRecord<TRGT, ID>>> collectionGetter;

        public TargetInstancesInsertCascader(EntityPersister<ElementRecord<TRGT, ID>, ElementRecord<TRGT, ID>> targetPersister, Function<SRC, ? extends Collection<ElementRecord<TRGT, ID>>> collectionGetter) {
            super(targetPersister);
            this.collectionGetter = collectionGetter;
        }

        @Override
        protected void postTargetInsert(Iterable<? extends ElementRecord<TRGT, ID>> entities) {
        }

        @Override
        protected Collection<ElementRecord<TRGT, ID>> getTargets(SRC source) {
            return this.collectionGetter.apply(source);
        }
    }

    private class ElementCollectionMapping<SRCTABLE extends Table<SRCTABLE>, COLLECTIONTABLE extends Table<COLLECTIONTABLE>> {
        public final ForeignKey<COLLECTIONTABLE, SRCTABLE, I> reverseForeignKey;
        public final ClassMapping<ElementRecord<TRGT, I>, ElementRecord<TRGT, I>, COLLECTIONTABLE> elementRecordMapping;

        public ElementCollectionMapping(ForeignKey<COLLECTIONTABLE, SRCTABLE, I> reverseForeignKey, ClassMapping<ElementRecord<TRGT, I>, ElementRecord<TRGT, I>, COLLECTIONTABLE> elementRecordMapping) {
            this.reverseForeignKey = reverseForeignKey;
            this.elementRecordMapping = elementRecordMapping;
        }
    }
}

