/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.tool.collection.ReadOnlyList;

public abstract class AbstractJoinNode<C, T1 extends Fromable, T2 extends Fromable, JOINTYPE>
implements JoinNode<C, T2> {
    private final Key<T1, JOINTYPE> leftJoinLink;
    private final Key<T2, JOINTYPE> rightJoinLink;
    private final EntityJoinTree.JoinType joinType;
    private final Set<Selectable<?>> columnsToSelect;
    private final JoinNode<?, T1> parent;
    private final List<AbstractJoinNode> joins = new ArrayList<AbstractJoinNode>();
    @Nullable
    protected String tableAlias;
    @Nullable
    private EntityTreeJoinNodeConsumptionListener<C> consumptionListener;

    protected AbstractJoinNode(JoinNode<?, T1> parent, JoinLink<T1, JOINTYPE> leftJoinLink, JoinLink<T2, JOINTYPE> rightJoinLink, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias) {
        this(parent, Key.ofSingleColumn(leftJoinLink), Key.ofSingleColumn(rightJoinLink), joinType, columnsToSelect, tableAlias);
    }

    protected AbstractJoinNode(JoinNode<?, T1> parent, Key<T1, JOINTYPE> leftJoinLink, Key<T2, JOINTYPE> rightJoinLink, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias) {
        this.parent = parent;
        this.leftJoinLink = leftJoinLink;
        this.rightJoinLink = rightJoinLink;
        this.joinType = joinType;
        this.columnsToSelect = columnsToSelect;
        this.tableAlias = tableAlias;
        parent.add(this);
    }

    @Override
    public <ROOT, ID> EntityJoinTree<ROOT, ID> getTree() {
        JoinNodeHierarchyIterator joinNodeHierarchyIterator = new JoinNodeHierarchyIterator(this);
        AbstractJoinNode currentNode = this;
        while (joinNodeHierarchyIterator.hasNext()) {
            currentNode = joinNodeHierarchyIterator.next();
        }
        return currentNode.getParent().getTree();
    }

    public JoinNode<?, T1> getParent() {
        return this.parent;
    }

    @Override
    public T2 getTable() {
        return this.getRightTable();
    }

    public Key<T1, JOINTYPE> getLeftJoinLink() {
        return this.leftJoinLink;
    }

    public Key<T2, JOINTYPE> getRightJoinLink() {
        return this.rightJoinLink;
    }

    public EntityJoinTree.JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public Set<Selectable<?>> getColumnsToSelect() {
        return this.columnsToSelect;
    }

    @Override
    public ReadOnlyList<AbstractJoinNode> getJoins() {
        return new ReadOnlyList(this.joins);
    }

    @Nullable
    EntityTreeJoinNodeConsumptionListener<C> getConsumptionListener() {
        return this.consumptionListener;
    }

    public AbstractJoinNode<C, T1, T2, JOINTYPE> setConsumptionListener(@Nullable EntityTreeJoinNodeConsumptionListener<C> consumptionListener) {
        this.consumptionListener = consumptionListener;
        return this;
    }

    @Override
    public void add(AbstractJoinNode node) {
        if (node.getParent() != this) {
            throw new IllegalArgumentException("Node is not added as child of right node : parent differs from target owner");
        }
        this.joins.add(node);
    }

    @Override
    @Nullable
    public String getTableAlias() {
        return this.tableAlias;
    }

    public T2 getRightTable() {
        return (T2)this.rightJoinLink.getTable();
    }

    static class JoinNodeHierarchyIterator
    implements Iterator<AbstractJoinNode> {
        private AbstractJoinNode currentNode;

        JoinNodeHierarchyIterator(AbstractJoinNode currentNode) {
            this.currentNode = currentNode;
        }

        @Override
        public boolean hasNext() {
            return this.currentNode != null;
        }

        @Override
        public AbstractJoinNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AbstractJoinNode toReturn = this.currentNode;
            this.prepareNextIteration();
            return toReturn;
        }

        private void prepareNextIteration() {
            JoinNode parent = this.currentNode.getParent();
            this.currentNode = parent instanceof AbstractJoinNode ? (AbstractJoinNode)parent : null;
        }
    }
}

