/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.SingleTablePolymorphicRelationJoinNode;
import org.codefilarete.stalactite.mapping.RowTransformer;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;

public class SingleTablePolymorphicRelationJoinNode<C, T1 extends Table<T1>, T2 extends Table<T2>, JOINCOLTYPE, I, DTYPE>
extends RelationJoinNode<C, T1, T2, JOINCOLTYPE, I> {
    private final Set<ConfiguredRelationalPersister<? extends C, I>> subPersisters;
    private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;
    private final Column<T2, DTYPE> discriminatorColumn;

    public SingleTablePolymorphicRelationJoinNode(JoinNode<T1> parent, Key<T1, JOINCOLTYPE> leftJoinColumn, Key<T2, JOINCOLTYPE> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias, EntityInflater<C, I> entityInflater, BeanRelationFixer<Object, C> beanRelationFixer, Column<T2, DTYPE> discriminatorColumn, Set<ConfiguredRelationalPersister<? extends C, I>> subPersisters, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias, entityInflater, beanRelationFixer, null);
        this.discriminatorColumn = discriminatorColumn;
        this.subPersisters = subPersisters;
        this.polymorphismPolicy = polymorphismPolicy;
    }

    @Override
    public RelationJoinNode.RelationJoinRowConsumer<C, I> toConsumer(JoinNode<T2> joinNode) {
        return new SingleTablePolymorphicRelationJoinRowConsumer(joinNode);
    }

    protected class SingleTablePolymorphicRelationJoinRowConsumer
    implements RelationJoinNode.RelationJoinRowConsumer<C, I> {
        private final Map<DTYPE, org.codefilarete.stalactite.engine.runtime.load.SingleTablePolymorphicRelationJoinNode$SingleTablePolymorphicRelationJoinRowConsumer.SubEntityDeterminer<? extends C>> subEntityDeterminerPerDiscriminatorValue;
        private final JoinNode<?> joinNode;

        private SingleTablePolymorphicRelationJoinRowConsumer(JoinNode<?> joinNode) {
            this.joinNode = joinNode;
            this.subEntityDeterminerPerDiscriminatorValue = Iterables.map((Iterable)SingleTablePolymorphicRelationJoinNode.this.subPersisters, subPersister -> SingleTablePolymorphicRelationJoinNode.this.polymorphismPolicy.getDiscriminatorValue(subPersister.getClassToPersist()), subPersister -> new SubEntityDeterminer(subPersister), HashMap::new);
        }

        @Override
        public JoinNode<?> getNode() {
            return this.joinNode;
        }

        @Override
        public C applyRelatedEntity(Object parentJoinEntity, ColumnedRow row, EntityTreeInflater.TreeInflationContext context) {
            RowIdentifier rowIdentifier = this.giveIdentifier(row);
            if (rowIdentifier == null) {
                return null;
            }
            Object rightIdentifier = rowIdentifier.entityIdentifier;
            EntityTreeInflater.RelationIdentifier eventuallyApplied = new EntityTreeInflater.RelationIdentifier(parentJoinEntity, SingleTablePolymorphicRelationJoinNode.this.getEntityType(), rightIdentifier, this);
            if (context.isTreatedOrAppend(eventuallyApplied)) {
                Object rightEntity = context.giveEntityFromCache(SingleTablePolymorphicRelationJoinNode.this.getEntityType(), rightIdentifier, () -> rowIdentifier.rowConsumer.createInstance(row));
                SingleTablePolymorphicRelationJoinNode.this.getBeanRelationFixer().apply(parentJoinEntity, rightEntity);
                if (SingleTablePolymorphicRelationJoinNode.this.getConsumptionListener() != null) {
                    SingleTablePolymorphicRelationJoinNode.this.getConsumptionListener().onNodeConsumption(rightEntity, row);
                }
                return rightEntity;
            }
            return null;
        }

        @Nullable
        private <D extends C> org.codefilarete.stalactite.engine.runtime.load.SingleTablePolymorphicRelationJoinNode$SingleTablePolymorphicRelationJoinRowConsumer.RowIdentifier<D> giveIdentifier(ColumnedRow row) {
            Object identifier;
            SubEntityDeterminer discriminatorConsumer;
            row = EntityTreeInflater.currentContext().getDecoder(this.joinNode);
            Object discriminatorValue = row.get((Selectable)SingleTablePolymorphicRelationJoinNode.this.discriminatorColumn);
            if (discriminatorValue != null && (discriminatorConsumer = (SubEntityDeterminer)this.subEntityDeterminerPerDiscriminatorValue.get(discriminatorValue)) != null && (identifier = discriminatorConsumer.giveIdentifier(row)) != null) {
                return new RowIdentifier(this, identifier, discriminatorConsumer);
            }
            return null;
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }

        private static class RowIdentifier<D extends C> {
            private final I entityIdentifier;
            private final org.codefilarete.stalactite.engine.runtime.load.SingleTablePolymorphicRelationJoinNode$SingleTablePolymorphicRelationJoinRowConsumer.SubEntityDeterminer<D> rowConsumer;
            final /* synthetic */ SingleTablePolymorphicRelationJoinRowConsumer this$1;

            private RowIdentifier(I entityIdentifier, org.codefilarete.stalactite.engine.runtime.load.SingleTablePolymorphicRelationJoinNode$SingleTablePolymorphicRelationJoinRowConsumer.SubEntityDeterminer<D> rowConsumer) {
                this.this$1 = var1_1;
                this.entityIdentifier = entityIdentifier;
                this.rowConsumer = rowConsumer;
            }
        }

        private class SubEntityDeterminer<D extends C> {
            private final Function<ColumnedRow, I> identifierProvider = row -> subPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(row);
            private final RowTransformer<D> entityInflater;

            public SubEntityDeterminer(ConfiguredRelationalPersister<D, I> subPersister) {
                this.entityInflater = subPersister.getMapping().getRowTransformer();
            }

            @Nullable
            public I giveIdentifier(ColumnedRow row) {
                return this.identifierProvider.apply(row);
            }

            public D createInstance(ColumnedRow row) {
                return (D)this.entityInflater.transform(row);
            }
        }
    }
}

