/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeJoinNodeConsumptionListener;
import org.codefilarete.stalactite.engine.runtime.load.JoinNode;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;

public class PassiveJoinNode<C, T1 extends Fromable, T2 extends Fromable, I>
extends AbstractJoinNode<C, T1, T2, I> {
    PassiveJoinNode(JoinNode<T1> parent, JoinLink<T1, I> leftJoinColumn, JoinLink<T2, I> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias);
    }

    PassiveJoinNode(JoinNode<T1> parent, Key<T1, I> leftJoinColumn, Key<T2, I> rightJoinColumn, EntityJoinTree.JoinType joinType, Set<? extends Selectable<?>> columnsToSelect, @Nullable String tableAlias) {
        super(parent, leftJoinColumn, rightJoinColumn, joinType, columnsToSelect, tableAlias);
    }

    @Override
    public JoinRowConsumer toConsumer(JoinNode<T2> joinNode) {
        return new PassiveJoinRowConsumer(this.getConsumptionListener(), joinNode);
    }

    public class PassiveJoinRowConsumer
    implements JoinRowConsumer {
        @Nullable
        private final EntityTreeJoinNodeConsumptionListener<C> consumptionListener;
        private final JoinNode<?> joinNode;

        public PassiveJoinRowConsumer(EntityTreeJoinNodeConsumptionListener<C> consumptionListener, JoinNode<?> joinNode) {
            this.consumptionListener = consumptionListener;
            this.joinNode = joinNode;
        }

        @Override
        public JoinNode<?> getNode() {
            return PassiveJoinNode.this;
        }

        void consume(C parentJoinEntity, ColumnedRow row) {
            if (this.consumptionListener != null) {
                this.consumptionListener.onNodeConsumption(parentJoinEntity, row);
            }
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }
    }
}

