/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.mapping.AbstractTransformer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EmbeddedBeanMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.ToCollectionRowTransformer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.function.Predicates;

public class ColumnedCollectionMapping<C extends Collection<O>, O, T extends Table<T>>
implements EmbeddedBeanMapping<C, T> {
    private final T targetTable;
    private final Set<Column<T, ?>> columns;
    private final ToCollectionRowTransformer<C> rowTransformer;
    private final Class<C> persistedClass;

    public ColumnedCollectionMapping(T targetTable, Set<? extends Column<T, ?>> columns, Class<C> rowClass) {
        this.targetTable = targetTable;
        this.columns = columns;
        this.persistedClass = rowClass;
        this.rowTransformer = new LocalToCollectionRowTransformer(this.getPersistedClass(), this::toCollectionValue);
    }

    public Class<C> getPersistedClass() {
        return this.persistedClass;
    }

    public T getTargetTable() {
        return this.targetTable;
    }

    @Override
    public Set<Column<T, ?>> getColumns() {
        return this.columns;
    }

    @Override
    public void addPropertySetByConstructor(ValueAccessPoint<C> accessor) {
    }

    @Override
    public Map<Column<T, ?>, ?> getInsertValues(C c) {
        Object toIterate = c;
        if (org.codefilarete.tool.collection.Collections.isEmpty(c)) {
            toIterate = new ArrayList();
        }
        PairIterator valueColumnPairIterator = new PairIterator(this.columns.iterator(), (Iterator)new PairIterator.InfiniteIterator(toIterate.iterator()));
        return Iterables.map(() -> valueColumnPairIterator, Duo::getLeft, e -> this.toDatabaseValue(e.getRight()));
    }

    @Override
    public Map<Mapping.UpwhereColumn<T>, ?> getUpdateValues(C modified, C unmodified, boolean allColumns) {
        HashMap toReturn;
        block4: {
            block3: {
                toReturn = new HashMap();
                if (modified == null) break block3;
                LinkedHashMap unmodifiedColumns = new LinkedHashMap();
                Object unmodifiedIterator = unmodified == null ? new PairIterator.EmptyIterator() : unmodified.iterator();
                PairIterator.UntilBothIterator untilBothIterator = new PairIterator.UntilBothIterator(modified.iterator(), (Iterator)unmodifiedIterator);
                PairIterator valueColumnPairIterator = new PairIterator(this.columns.iterator(), (Iterator)untilBothIterator);
                valueColumnPairIterator.forEachRemaining(diffEntry -> {
                    Column fieldColumn = (Column)diffEntry.getLeft();
                    Duo toBeCompared = (Duo)diffEntry.getRight();
                    if (!Predicates.equalOrNull((Object)toBeCompared.getLeft(), (Object)toBeCompared.getRight())) {
                        toReturn.put(fieldColumn, this.toDatabaseValue(toBeCompared.getLeft()));
                    } else {
                        unmodifiedColumns.put(fieldColumn, toBeCompared.getRight());
                    }
                });
                if (!allColumns || toReturn.isEmpty()) break block4;
                LinkedHashSet missingColumns = new LinkedHashSet(this.columns);
                missingColumns.removeAll(toReturn.keySet());
                for (Column column : missingColumns) {
                    Object missingValue = unmodifiedColumns.get(column);
                    toReturn.put(column, missingValue);
                }
                break block4;
            }
            if (allColumns && unmodified != null) {
                for (Column<T, ?> column : this.columns) {
                    toReturn.put(column, null);
                }
            }
        }
        return this.convertToUpwhereColumn(toReturn);
    }

    private Map<Mapping.UpwhereColumn<T>, ?> convertToUpwhereColumn(Map<? extends Column<T, ?>, ?> map) {
        HashMap convertion = new HashMap();
        map.forEach((c, s) -> convertion.put(new Mapping.UpwhereColumn(c, true), s));
        return convertion;
    }

    protected Object toDatabaseValue(O object) {
        return object;
    }

    protected O toCollectionValue(Object object) {
        return (O)object;
    }

    @Override
    public C transform(Row row) {
        return (C)((Collection)this.rowTransformer.transform(row));
    }

    @Override
    public Map<ReversibleAccessor<C, ?>, Column<T, ?>> getPropertyToColumn() {
        throw new UnsupportedOperationException(Reflections.toString(ColumnedCollectionMapping.class) + " can't export a mapping between some accessors and their columns");
    }

    @Override
    public Map<ReversibleAccessor<C, ?>, Column<T, ?>> getReadonlyPropertyToColumn() {
        throw new UnsupportedOperationException(Reflections.toString(ColumnedCollectionMapping.class) + " can't export a mapping between some accessors and their columns");
    }

    @Override
    public Set<Column<T, ?>> getWritableColumns() {
        return this.columns;
    }

    @Override
    public Set<Column<T, ?>> getReadonlyColumns() {
        return Collections.emptySet();
    }

    @Override
    public AbstractTransformer<C> copyTransformerWithAliases(ColumnedRow columnedRow) {
        return this.rowTransformer.copyWithAliases(columnedRow);
    }

    private class LocalToCollectionRowTransformer<C extends Collection>
    extends ToCollectionRowTransformer<C> {
        private final Function<Object, Object> databaseValueConverter;

        private LocalToCollectionRowTransformer(Class<C> persistedClass, Function<Object, Object> databaseValueConverter) {
            super(persistedClass);
            this.databaseValueConverter = databaseValueConverter;
        }

        private LocalToCollectionRowTransformer(Function<Function<Column<?, ?>, Object>, C> beanFactory, ColumnedRow columnedRow, Iterable<Column<T, ?>> columns, Function<Object, Object> databaseValueConverter) {
            super(beanFactory, columnedRow);
            this.databaseValueConverter = databaseValueConverter;
        }

        @Override
        public AbstractTransformer<C> copyWithAliases(ColumnedRow columnedRow) {
            return new LocalToCollectionRowTransformer<C>(this.beanFactory, columnedRow, ColumnedCollectionMapping.this.columns, this.databaseValueConverter);
        }

        @Override
        public void applyRowToBean(Row row, C collection) {
            for (Column column : ColumnedCollectionMapping.this.columns) {
                Object value = row.get(column.getName());
                collection.add((Object)this.databaseValueConverter.apply(value));
            }
        }
    }
}

