/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.load;

import java.util.Collection;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityInflater;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.EntityTreeInflater;
import org.codefilarete.stalactite.engine.runtime.load.JoinRoot;
import org.codefilarete.stalactite.engine.runtime.load.JoinRowConsumer;
import org.codefilarete.stalactite.mapping.AbstractTransformer;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderSet;

public class SingleTableRootJoinNode<C, I, T extends Table<T>, DTYPE>
extends JoinRoot<C, I, T> {
    private final Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters;
    private final Set<Column<T, ?>> allColumnsInHierarchy;
    private final Column<T, DTYPE> discriminatorColumn;
    private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;

    public SingleTableRootJoinNode(EntityJoinTree<C, I> tree, ConfiguredRelationalPersister<C, I> mainPersister, Set<? extends ConfiguredRelationalPersister<C, I>> subPersisters, Column<T, DTYPE> discriminatorColumn, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy) {
        super(tree, new EntityInflater.EntityMappingAdapter(mainPersister.getMapping()), mainPersister.getMainTable());
        this.subPersisters = subPersisters;
        this.discriminatorColumn = discriminatorColumn;
        this.polymorphismPolicy = polymorphismPolicy;
        this.allColumnsInHierarchy = (Set)Collections.cat((Collection[])new Collection[]{Arrays.asList((Object[])new ConfiguredRelationalPersister[]{mainPersister}), subPersisters}).stream().flatMap(persister -> persister.getMainTable().getColumns().stream()).collect(Collectors.toCollection(KeepOrderSet::new));
    }

    @Override
    public Set<Selectable<?>> getColumnsToSelect() {
        return this.allColumnsInHierarchy;
    }

    @Override
    public JoinRowConsumer.RootJoinRowConsumer<C> toConsumer(ColumnedRow columnedRow) {
        Set subEntityConsumer = this.subPersisters.stream().map(subPersister -> {
            EntityMapping mapping = subPersister.getMapping();
            return new SubPersisterConsumer(row -> mapping.getIdMapping().getIdentifierAssembler().assemble(row, columnedRow), mapping.getClassToPersist(), (AbstractTransformer)mapping.copyTransformerWithAliases(columnedRow));
        }).collect(Collectors.toSet());
        BiConsumer<Object, Row> rowConsumptionListener = this.getConsumptionListener() == null ? null : (rootEntity, row) -> this.getConsumptionListener().onNodeConsumption(rootEntity, column -> columnedRow.getValue((Selectable)column, row));
        return new SingleTablePolymorphicJoinRootRowConsumer(subEntityConsumer, rowConsumptionListener, this.polymorphismPolicy, row -> columnedRow.getValue(this.discriminatorColumn, row));
    }

    static class SingleTablePolymorphicJoinRootRowConsumer<C, I, DTYPE>
    implements JoinRowConsumer.RootJoinRowConsumer<C> {
        private final Set<SubPersisterConsumer<C, I>> subConsumers;
        @Nullable
        private final BiConsumer<C, Row> consumptionListener;
        private final PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy;
        private final Function<Row, DTYPE> discriminatorValueReader;

        private SingleTablePolymorphicJoinRootRowConsumer(Set<SubPersisterConsumer<C, I>> subConsumers, @Nullable BiConsumer<C, Row> consumptionListener, PolymorphismPolicy.SingleTablePolymorphism<C, DTYPE> polymorphismPolicy, Function<Row, DTYPE> discriminatorValueReader) {
            this.subConsumers = subConsumers;
            this.consumptionListener = consumptionListener;
            this.polymorphismPolicy = polymorphismPolicy;
            this.discriminatorValueReader = discriminatorValueReader;
        }

        @Override
        public C createRootInstance(Row row, EntityTreeInflater.TreeInflationContext context) {
            Duo subInflater = this.findSubInflater(row);
            Object result = subInflater == null ? null : context.giveEntityFromCache(((SubPersisterConsumer)subInflater.getRight()).subEntityType, subInflater.getLeft(), () -> ((SubPersisterConsumer)subInflater.getRight()).subEntityFactory.transform(row));
            if (this.consumptionListener != null) {
                this.consumptionListener.accept(result, row);
            }
            return (C)result;
        }

        @Nullable
        public Duo<I, SubPersisterConsumer<C, I>> findSubInflater(Row row) {
            Class<C> subEntityClass = this.polymorphismPolicy.getClass(this.discriminatorValueReader.apply(row));
            Duo subClassRowConsumer = Iterables.find(this.subConsumers, subConsumer -> ((SubPersisterConsumer)subConsumer).subEntityType, subEntityClass::equals);
            SubPersisterConsumer subIdentifierConsumer = (SubPersisterConsumer)subClassRowConsumer.getLeft();
            return new Duo(subIdentifierConsumer.identifierAssembler.apply(row), (Object)subIdentifierConsumer);
        }

        public String toString() {
            return Reflections.toString(this.getClass());
        }
    }

    static class SubPersisterConsumer<C, I> {
        private final Function<Row, I> identifierAssembler;
        private final Class<C> subEntityType;
        private final AbstractTransformer<C> subEntityFactory;

        private SubPersisterConsumer(Function<Row, I> identifierAssembler, Class<C> subEntityType, AbstractTransformer<C> subEntityFactory) {
            this.identifierAssembler = identifierAssembler;
            this.subEntityType = subEntityType;
            this.subEntityFactory = subEntityFactory;
        }
    }
}

