/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.AlreadyAssignedIdentifierPersistExecutor;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.PersisterListenerWrapper;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.stalactite.engine.runtime.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.ComposedIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.query.EntityFinder;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.tool.collection.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPolymorphismPersister<C, I>
extends PersisterListenerWrapper<C, I>
implements ConfiguredRelationalPersister<C, I>,
PolymorphicPersister<C>,
AdvancedEntityPersister<C, I> {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final Map<Class<C>, ConfiguredRelationalPersister<C, I>> subEntitiesPersisters;
    protected final ConfiguredRelationalPersister<C, I> mainPersister;
    protected final EntityCriteriaSupport<C> criteriaSupport;
    protected final EntityFinder<C, I> entityFinder;
    protected final PersistExecutor<C> persistExecutor;

    protected AbstractPolymorphismPersister(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, EntityFinder<C, I> entityFinder) {
        this.mainPersister = mainPersister;
        this.subEntitiesPersisters = subEntitiesPersisters;
        this.criteriaSupport = new EntityCriteriaSupport(mainPersister.getMapping());
        this.entityFinder = entityFinder;
        this.persistExecutor = mainPersister.getMapping().getIdMapping().getIdentifierInsertionManager() instanceof AlreadyAssignedIdentifierManager ? new AlreadyAssignedIdentifierPersistExecutor((ConfiguredPersister)this) : new PersistExecutor.DefaultPersistExecutor((EntityPersister)this);
    }

    public Map<Class<C>, ConfiguredRelationalPersister<C, I>> getSubEntitiesPersisters() {
        return this.subEntitiesPersisters;
    }

    public Set<C> doSelect(Iterable<I> ids) {
        this.LOGGER.debug("selecting entities {}", ids);
        IdMapping idMapping = this.mainPersister.getMapping().getIdMapping();
        AccessorWrapperIdAccessor idAccessor = (AccessorWrapperIdAccessor)idMapping.getIdAccessor();
        if (idMapping.getIdentifierAssembler() instanceof ComposedIdentifierAssembler) {
            Map columnValues = ((ComposedIdentifierAssembler)idMapping.getIdentifierAssembler()).getColumnValues(ids);
            TupleIn tupleIn = TupleIn.transformBeanColumnValuesToTupleInValues((int)((int)Iterables.size(ids)), (Map)columnValues);
            EntityQueryCriteriaSupport<C, I> newCriteriaSupport = this.newCriteriaSupport();
            newCriteriaSupport.getEntityCriteriaSupport().getCriteria().and(new Object[]{tupleIn});
            return (Set)newCriteriaSupport.wrapIntoExecutable().execute(Accumulators.toSet());
        }
        return (Set)((RelationalEntityPersister.ExecutableEntityQueryCriteria)this.selectWhere().and(new AccessorChain(new Accessor[]{idAccessor.getIdAccessor()}), (ConditionalOperator)Operators.in(ids))).execute(Accumulators.toSet());
    }

    @Override
    public RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ?> selectWhere() {
        return this.newCriteriaSupport().wrapIntoExecutable();
    }

    @Override
    public EntityQueryCriteriaSupport<C, I> newCriteriaSupport() {
        return new EntityQueryCriteriaSupport<C, I>(this.criteriaSupport, this.entityFinder, this.getPersisterListener());
    }

    public EntityPersister.ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<Select> selectAdapter) {
        ProjectionQueryCriteriaSupport<C, I> projectionSupport = new ProjectionQueryCriteriaSupport<C, I>(this.criteriaSupport, this.entityFinder, selectAdapter);
        return projectionSupport.wrapIntoExecutable();
    }

    public Set<C> selectAll() {
        return (Set)this.selectWhere().execute(Accumulators.toSet());
    }

    public boolean isNew(C entity) {
        return this.mainPersister.isNew(entity);
    }

    public Class<C> getClassToPersist() {
        return this.mainPersister.getClassToPersist();
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.mainPersister.getEntityJoinTree();
    }

    public I getId(C entity) {
        return (I)this.mainPersister.getId(entity);
    }

    protected void doPersist(Iterable<? extends C> entities) {
        this.persistExecutor.persist(entities);
    }
}

