/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetomany;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleMutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.onetomany.FirstPhaseCycleLoadListener;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyAssociationConfiguration;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.onetomany.IndexedMappedManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.MappedManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithIndexedMappedAssociationEngine;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;

class OneToManyWithMappedAssociationConfigurer<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>>
extends OneToManyConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, C, LEFTTABLE> {
    private OneToManyWithMappedAssociationEngine<SRC, TRGT, SRCID, TRGTID, C, RIGHTTABLE> mappedAssociationEngine;
    private Key<RIGHTTABLE, SRCID> foreignKey;
    private Set<Column<RIGHTTABLE, ?>> mappedReverseColumns;
    private Function<SRCID, Map<Column<RIGHTTABLE, ?>, Object>> reverseColumnsValueProvider;

    OneToManyWithMappedAssociationConfigurer(OneToManyAssociationConfiguration<SRC, TRGT, SRCID, TRGTID, C, LEFTTABLE> associationConfiguration, boolean loadSeparately) {
        super(associationConfiguration, loadSeparately);
    }

    @Override
    protected void configure(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        this.determineForeignKeyColumns(targetPersister);
        this.assignAssociationEngine(targetPersister);
        this.mappedAssociationEngine.addSelectCascade(this.associationConfiguration.getLeftPrimaryKey(), this.loadSeparately);
        this.addWriteCascades(this.mappedAssociationEngine, targetPersister);
    }

    protected void determineForeignKeyColumns(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        Object mainTargetTable = targetPersister.getMainTable();
        Key.KeyBuilder foreignKeyBuilder = Key.from(mainTargetTable);
        OneToManyRelation relation = this.associationConfiguration.getOneToManyRelation();
        if (!relation.getForeignKeyNameMapping().isEmpty()) {
            HashMap foreignKeyColumnMapping = new HashMap();
            relation.getForeignKeyNameMapping().forEach((valueAccessPoint, colName) -> {
                Accessor accessor;
                AccessorDefinition localAccessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint);
                Object object = valueAccessPoint instanceof Accessor ? (Accessor)valueAccessPoint : (accessor = valueAccessPoint instanceof ReversibleMutator ? ((ReversibleMutator)valueAccessPoint).toAccessor() : null);
                if (accessor == null) {
                    throw new UnsupportedOperationException("Can't get accessor from " + valueAccessPoint);
                }
                Column column = mainTargetTable.addColumn(colName, localAccessorDefinition.getMemberType());
                foreignKeyBuilder.addColumn((JoinLink)column);
                foreignKeyColumnMapping.put(accessor, column);
            });
            this.mappedReverseColumns = new HashSet(foreignKeyColumnMapping.values());
            this.reverseColumnsValueProvider = srcid -> {
                HashMap result = new HashMap();
                foreignKeyColumnMapping.forEach((accessor, column) -> result.put(column, accessor.get(srcid)));
                return result;
            };
        } else if (!relation.getForeignKeyColumnMapping().isEmpty()) {
            HashMap foreignKeyColumnMapping = new HashMap();
            relation.getForeignKeyColumnMapping().forEach((valueAccessPoint, column) -> {
                Accessor accessor;
                Object object = valueAccessPoint instanceof Accessor ? (Accessor)valueAccessPoint : (accessor = valueAccessPoint instanceof ReversibleMutator ? ((ReversibleMutator)valueAccessPoint).toAccessor() : null);
                if (accessor == null) {
                    throw new UnsupportedOperationException("Can't get accessor from " + valueAccessPoint);
                }
                foreignKeyBuilder.addColumn((JoinLink)column);
                foreignKeyColumnMapping.put(accessor, column);
            });
            this.mappedReverseColumns = new HashSet(foreignKeyColumnMapping.values());
            this.reverseColumnsValueProvider = srcid -> {
                HashMap result = new HashMap();
                foreignKeyColumnMapping.forEach((accessor, column) -> result.put(column, accessor.get(srcid)));
                return result;
            };
        } else if (relation.getReverseColumn() != null) {
            foreignKeyBuilder.addColumn(relation.getReverseColumn());
            this.mappedReverseColumns = Arrays.asHashSet((Object[])new Column[]{relation.getReverseColumn()});
            this.reverseColumnsValueProvider = srcid -> {
                HashMap result = new HashMap();
                result.put(relation.getReverseColumn(), srcid);
                return result;
            };
        } else if (relation.getReverseGetter() != null) {
            HashMap foreignKeyColumnMapping = new HashMap();
            PrimaryKey primaryKey = this.associationConfiguration.getSrcPersister().getMainTable().getPrimaryKey();
            AccessorDefinition reverseGetterDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)Accessors.accessor(relation.getReverseGetter()));
            primaryKey.getColumns().forEach(pkColumn -> {
                String colName = this.associationConfiguration.getJoinColumnNamingStrategy().giveName(reverseGetterDefinition, (Column<?, ?>)pkColumn);
                Column fkColumn = mainTargetTable.addColumn(colName, pkColumn.getJavaType(), pkColumn.getSize());
                foreignKeyBuilder.addColumn((JoinLink)fkColumn);
                foreignKeyColumnMapping.put(pkColumn, fkColumn);
            });
            this.mappedReverseColumns = new HashSet(foreignKeyColumnMapping.values());
            this.reverseColumnsValueProvider = srcid -> {
                IdentifierAssembler identifierAssembler = this.associationConfiguration.getSrcPersister().getMapping().getIdMapping().getIdentifierAssembler();
                Map columnValues = identifierAssembler.getColumnValues(srcid);
                return Maps.innerJoin((Map)foreignKeyColumnMapping, (Map)columnValues);
            };
        } else if (relation.getReverseSetter() != null) {
            HashMap foreignKeyColumnMapping = new HashMap();
            PrimaryKey primaryKey = this.associationConfiguration.getSrcPersister().getMainTable().getPrimaryKey();
            AccessorDefinition reverseGetterDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)Accessors.mutator(relation.getReverseSetter()));
            primaryKey.getColumns().forEach(pkColumn -> {
                String colName = this.associationConfiguration.getJoinColumnNamingStrategy().giveName(reverseGetterDefinition, (Column<?, ?>)pkColumn);
                Column fkColumn = mainTargetTable.addColumn(colName, pkColumn.getJavaType(), pkColumn.getSize());
                foreignKeyBuilder.addColumn((JoinLink)fkColumn);
                foreignKeyColumnMapping.put(pkColumn, fkColumn);
            });
            this.mappedReverseColumns = new HashSet(foreignKeyColumnMapping.values());
            this.reverseColumnsValueProvider = srcid -> {
                IdentifierAssembler identifierAssembler = this.associationConfiguration.getSrcPersister().getMapping().getIdMapping().getIdentifierAssembler();
                Map columnValues = identifierAssembler.getColumnValues(srcid);
                return Maps.innerJoin((Map)foreignKeyColumnMapping, (Map)columnValues);
            };
        }
        this.foreignKey = foreignKeyBuilder.build();
        if (!relation.isTargetTablePerClassPolymorphic()) {
            mainTargetTable.addForeignKey(this.associationConfiguration.getForeignKeyNamingStrategy()::giveName, this.foreignKey, this.associationConfiguration.getLeftPrimaryKey());
        } else {
            targetPersister.giveImpliedTables().forEach(table -> this.extracted(table));
        }
    }

    private <IMPLIEDTABLE extends Table<IMPLIEDTABLE>> void extracted(IMPLIEDTABLE table) {
        Key.KeyBuilder projectedKeyBuilder = Key.from(table);
        this.foreignKey.getColumns().forEach(column -> projectedKeyBuilder.addColumn((JoinLink)table.addColumn(column.getName(), column.getJavaType(), column.getSize())));
        Key projectedKey = projectedKeyBuilder.build();
        ForeignKeyNamingStrategy foreignKeyNamingStrategy = this.associationConfiguration.getForeignKeyNamingStrategy();
        table.addForeignKey(foreignKeyNamingStrategy::giveName, projectedKey, this.associationConfiguration.getLeftPrimaryKey());
    }

    void assignAssociationEngine(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        BiConsumer<Object, Object> reverseSetterAsConsumer;
        PropertyAccessor reversePropertyAccessor = null;
        if (this.associationConfiguration.getOneToManyRelation().getReverseSetter() != null) {
            reversePropertyAccessor = Accessors.mutator(this.associationConfiguration.getOneToManyRelation().getReverseSetter());
        } else if (this.associationConfiguration.getOneToManyRelation().getReverseGetter() != null) {
            reversePropertyAccessor = Accessors.accessor(this.associationConfiguration.getOneToManyRelation().getReverseGetter()).toMutator();
        }
        BiConsumer<Object, Object> biConsumer = reverseSetterAsConsumer = reversePropertyAccessor == null ? null : (arg_0, arg_1) -> ((Mutator)reversePropertyAccessor).set(arg_0, arg_1);
        if (this.associationConfiguration.getOneToManyRelation().isOrdered()) {
            this.assignEngineForIndexedAssociation(reverseSetterAsConsumer, this.foreignKey, this.associationConfiguration.getOneToManyRelation().getIndexingColumn(), targetPersister);
        } else {
            this.assignEngineForNonIndexedAssociation(this.foreignKey, targetPersister, reverseSetterAsConsumer);
        }
    }

    @Override
    public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        this.determineForeignKeyColumns(targetPersister);
        this.assignAssociationEngine(targetPersister);
        this.mappedAssociationEngine.addSelectIn2Phases(this.associationConfiguration.getLeftPrimaryKey(), this.mappedAssociationEngine.getManyRelationDescriptor().getReverseColumn(), this.associationConfiguration.getCollectionGetter(), firstPhaseCycleLoadListener);
        this.addWriteCascades(this.mappedAssociationEngine, targetPersister);
        return new CascadeConfigurationResult(this.mappedAssociationEngine.getManyRelationDescriptor().getRelationFixer(), this.associationConfiguration.getSrcPersister());
    }

    private void addWriteCascades(OneToManyWithMappedAssociationEngine<SRC, TRGT, SRCID, TRGTID, C, RIGHTTABLE> mappedAssociationEngine, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        if (this.associationConfiguration.isWriteAuthorized()) {
            mappedAssociationEngine.addInsertCascade(targetPersister);
            mappedAssociationEngine.addUpdateCascade(this.associationConfiguration.isOrphanRemoval(), targetPersister);
            mappedAssociationEngine.addDeleteCascade(this.associationConfiguration.isOrphanRemoval(), targetPersister);
        }
    }

    private void assignEngineForNonIndexedAssociation(Key<?, SRCID> reverseColumn, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, @javax.annotation.Nullable BiConsumer<TRGT, SRC> reverseSetter) {
        MappedManyRelationDescriptor<Object, TRGT, Collection, SRCID> manyRelationDefinition = new MappedManyRelationDescriptor<Object, TRGT, Collection, SRCID>(arg_0 -> this.associationConfiguration.getCollectionGetter().get(arg_0), (arg_0, arg_1) -> this.associationConfiguration.getSetter().set(arg_0, arg_1), this.associationConfiguration.getCollectionFactory(), reverseSetter, reverseColumn);
        this.mappedAssociationEngine = new OneToManyWithMappedAssociationEngine<Object, TRGT, SRCID, TRGTID, Collection, RIGHTTABLE>(targetPersister, manyRelationDefinition, this.associationConfiguration.getSrcPersister(), this.mappedReverseColumns, this.reverseColumnsValueProvider);
    }

    private void assignEngineForIndexedAssociation(@javax.annotation.Nullable BiConsumer<TRGT, SRC> reverseSetter, Key<?, SRCID> reverseColumn, @javax.annotation.Nullable Column<?, Integer> indexingColumn, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        if (indexingColumn == null) {
            String indexingColumnName = (String)Nullable.nullable((Object)this.associationConfiguration.getColumnName()).getOr(() -> this.associationConfiguration.getIndexColumnNamingStrategy().giveName(this.associationConfiguration.getAccessorDefinition()));
            Class<Integer> indexColumnType = this.associationConfiguration.isOrphanRemoval() ? Integer.TYPE : Integer.class;
            indexingColumn = targetPersister.getMapping().getTargetTable().addColumn(indexingColumnName, indexColumnType);
        }
        IndexedMappedManyRelationDescriptor<Object, Object, Collection, Object, Object> manyRelationDefinition = new IndexedMappedManyRelationDescriptor<Object, Object, Collection, Object, Object>(arg_0 -> this.associationConfiguration.getCollectionGetter().get(arg_0), (arg_0, arg_1) -> this.associationConfiguration.getSetter().set(arg_0, arg_1), this.associationConfiguration.getCollectionFactory(), reverseSetter, reverseColumn, (Column<? extends Table, Integer>)indexingColumn, arg_0 -> this.associationConfiguration.getSrcPersister().getId(arg_0), arg_0 -> targetPersister.getId(arg_0));
        this.mappedAssociationEngine = new OneToManyWithIndexedMappedAssociationEngine<Object, Object, Object, Object, Collection, RIGHTTABLE>(targetPersister, manyRelationDefinition, this.associationConfiguration.getSrcPersister(), this.mappedReverseColumns, this.reverseColumnsValueProvider);
    }
}

