/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.AssociationTableNamingStrategy;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class AssociationTableNamingStrategyTest {
    AssociationTableNamingStrategyTest() {
    }

    @Test
    void giveName() {
        Table countryTable = new Table(null, "CountryTable");
        countryTable.addColumn("id", String.class).primaryKey();
        Table cityTable = new Table(null, "CityTable");
        cityTable.addColumn("cityId", String.class).primaryKey();
        AssociationTableNamingStrategy.DefaultAssociationTableNamingStrategy testInstance = new AssociationTableNamingStrategy.DefaultAssociationTableNamingStrategy();
        Assertions.assertThat((String)testInstance.giveName(new AccessorDefinition(Country.class, "cities", Set.class), countryTable.getPrimaryKey(), cityTable.getPrimaryKey())).isEqualTo("Country_cities");
        Assertions.assertThat((String)testInstance.giveName(new AccessorDefinition(Country.class, "giveCities", Set.class), countryTable.getPrimaryKey(), cityTable.getPrimaryKey())).isEqualTo("Country_giveCities");
    }

    private static class Country {
        private final Set<City> cities = new HashSet<City>();

        Country() {
        }

        public Set<City> getCities() {
            return this.cities;
        }

        public Set<City> giveCities() {
            return this.cities;
        }
    }

    @Nested
    class keyColumnNames_primaryKeysTargetSameEntity_keyColumnNamesAreDifferent {
        keyColumnNames_primaryKeysTargetSameEntity_keyColumnNamesAreDifferent() {
        }

        @Test
        void fallsbackOnAttributeName() {
            AssociationTableNamingStrategy.DefaultAssociationTableNamingStrategy testInstance = new AssociationTableNamingStrategy.DefaultAssociationTableNamingStrategy();
            AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)new AccessorByMethodReference(CyclingModel::getCyclingModels));
            Table cyclingModelTable = new Table("CyclingModelTable");
            Column idColumn = cyclingModelTable.addColumn("id", Long.TYPE);
            idColumn.primaryKey();
            AssociationTableNamingStrategy.ReferencedColumnNames columnNames = testInstance.giveColumnNames(accessorDefinition, cyclingModelTable.getPrimaryKey(), cyclingModelTable.getPrimaryKey());
            Assertions.assertThat((String)columnNames.getLeftColumnName(idColumn)).isEqualTo("cyclingModelTable_id");
            Assertions.assertThat((String)columnNames.getRightColumnName(idColumn)).isEqualTo("cyclingModels_id");
        }

        @Test
        <T extends Table<T>> void attributeNameIsSameAsTable_throwsException() {
            AssociationTableNamingStrategy.DefaultAssociationTableNamingStrategy testInstance = new AssociationTableNamingStrategy.DefaultAssociationTableNamingStrategy();
            AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)new AccessorByMethodReference(CyclingModel::getCyclingModel));
            Table cyclingModelTable = new Table("CyclingModel");
            cyclingModelTable.addColumn("id", Long.TYPE).primaryKey();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> testInstance.giveColumnNames(accessorDefinition, cyclingModelTable.getPrimaryKey(), cyclingModelTable.getPrimaryKey())).extracting(t -> (MappingConfigurationException)Exceptions.findExceptionInCauses((Throwable)t, MappingConfigurationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Identical column names in association table of collection o.c.s.e.keyColumnNames_primaryKeysTargetSameEntity_keyColumnNamesAreDifferent$CyclingModel.cyclingModel : cyclingModel_id");
        }

        private class CyclingModel {
            private final Set<CyclingModel> cyclingModels = new HashSet<CyclingModel>();
            private final CyclingModel cyclingModel = null;

            private CyclingModel() {
            }

            public Set<CyclingModel> getCyclingModels() {
                return this.cyclingModels;
            }

            public CyclingModel getCyclingModel() {
                return this.cyclingModel;
            }
        }
    }
}

