/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.runtime.DMLExecutor;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.ColumnParameterizedSelect;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Iterables;

public class SelectExecutor<C, I, T extends Table<T>>
extends DMLExecutor<C, I, T>
implements org.codefilarete.stalactite.engine.SelectExecutor<C, I> {
    private final InternalExecutor<C, I, T> internalExecutor;
    private final ReadOperationFactory readOperationFactory;
    private final Integer fetchSize;
    protected SQLOperation.SQLOperationListener<Column<T, ?>> operationListener;

    public SelectExecutor(EntityMapping<C, I, T> mappingStrategy, ConnectionConfiguration connectionConfiguration, DMLGenerator dmlGenerator, ReadOperationFactory readOperationFactory, int inOperatorMaxSize) {
        super(mappingStrategy, connectionConfiguration.getConnectionProvider(), dmlGenerator, inOperatorMaxSize);
        this.internalExecutor = new InternalExecutor<C, I, T>(mappingStrategy);
        this.readOperationFactory = readOperationFactory;
        this.fetchSize = connectionConfiguration.getFetchSize();
    }

    public void setOperationListener(SQLOperation.SQLOperationListener<Column<T, ?>> operationListener) {
        this.operationListener = operationListener;
    }

    @Override
    public Set<C> select(Iterable<I> ids) {
        int blockSize = this.getInOperatorMaxSize();
        List parcels = org.codefilarete.tool.collection.Collections.parcel(ids, (int)blockSize);
        HashSet<C> result = new HashSet<C>(50);
        if (!parcels.isEmpty()) {
            Throwable throwable;
            List lastParcel = (List)Iterables.last((List)parcels, Collections.emptyList());
            int lastBlockSize = lastParcel.size();
            if (lastBlockSize != blockSize) {
                parcels = Iterables.cutTail((List)parcels);
            } else {
                lastParcel = Collections.emptyList();
            }
            SimpleConnectionProvider localConnectionProvider = new SimpleConnectionProvider(this.getConnectionProvider().giveConnection());
            Object targetTable = this.getMapping().getTargetTable();
            Set columnsToRead = this.getMapping().getSelectableColumns();
            if (!parcels.isEmpty()) {
                throwable = null;
                try (ReadOperation defaultReadOperation = this.newReadOperation(targetTable, columnsToRead, blockSize, (ConnectionProvider)localConnectionProvider);){
                    parcels.forEach(parcel -> result.addAll(this.internalExecutor.execute(defaultReadOperation, (List<I>)parcel)));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            if (!lastParcel.isEmpty()) {
                throwable = null;
                try (ReadOperation lastReadOperation = this.newReadOperation(targetTable, columnsToRead, lastBlockSize, (ConnectionProvider)localConnectionProvider);){
                    result.addAll(this.internalExecutor.execute(lastReadOperation, lastParcel));
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
        return result;
    }

    private ReadOperation<Column<T, ?>> newReadOperation(T targetTable, Set<Column<T, ?>> columnsToRead, int blockSize, ConnectionProvider connectionProvider) {
        ColumnParameterizedSelect<T> selectStatement = this.getDmlGenerator().buildSelectByKey(targetTable, columnsToRead, ((Table)targetTable).getPrimaryKey().getColumns(), blockSize);
        ReadOperation<T> readOperation = this.readOperationFactory.createInstance(selectStatement, connectionProvider, this.fetchSize);
        readOperation.setListener(this.operationListener);
        return readOperation;
    }

    @VisibleForTesting
    static class InternalExecutor<C, I, T extends Table<T>> {
        private final IdentifierAssembler<I, T> primaryKeyProvider;
        private final Function<Row, C> transformer;

        InternalExecutor(EntityMapping<C, I, T> mapping) {
            this(mapping.getIdMapping().getIdentifierAssembler(), mapping::transform);
        }

        InternalExecutor(IdentifierAssembler<I, T> primaryKeyProvider, Function<Row, C> transformer) {
            this.primaryKeyProvider = primaryKeyProvider;
            this.transformer = transformer;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @VisibleForTesting
        Set<C> execute(ReadOperation<Column<T, ?>> operation, List<I> ids) {
            Map<Column<T, ?>, Object> primaryKeyValues = this.primaryKeyProvider.getColumnValues((Iterable<I>)ids);
            try (ReadOperation<Column<T, ?>> closeableOperation = operation;){
                closeableOperation.setValues(primaryKeyValues);
                Set<C> set = this.transform(closeableOperation, primaryKeyValues.size());
                return set;
            }
            catch (RuntimeException e) {
                throw new SQLExecutionException(operation.getSqlStatement().getSQL(), (Throwable)e);
            }
        }

        protected Set<C> transform(ReadOperation<Column<T, ?>> closeableOperation, int size) {
            ResultSet resultSet = closeableOperation.execute();
            RowIterator rowIterator = new RowIterator(resultSet, ((ColumnParameterizedSelect)closeableOperation.getSqlStatement()).getSelectParameterBinders());
            return this.transform((Iterator<Row>)rowIterator, size);
        }

        protected Set<C> transform(Iterator<Row> rowIterator, int resultSize) {
            return (Set)Iterables.collect(() -> rowIterator, this.transformer, () -> new HashSet(resultSize));
        }
    }
}

