/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableTypeAssert;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.RuntimeMappingException;
import org.codefilarete.stalactite.engine.idprovider.LongProvider;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportOneToOneTest {
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private FluentEntityMappingBuilder<Person, Identifier<Long>> personConfiguration;
    private FluentEntityMappingBuilder<City, Identifier<Long>> cityConfiguration;
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void initTest() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityMappingBuilder;
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions personMappingBuilder;
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
        this.personConfiguration = personMappingBuilder = MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName);
        this.cityConfiguration = cityMappingBuilder = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
    }

    @Test
    public void lightOneToOne_relationIsPersisted() throws SQLException {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        dialect.getColumnBinderRegistry().register(Person.class, Identified.identifiedBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Person.class, "int");
        PersistenceContext persistenceContext = new PersistenceContext(this.dataSource, dialect);
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).map(Country::getPresident).columnName("presidentId").build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider personIdProvider = new LongProvider(123L);
        Person person = new Person((Long)personIdProvider.giveNewIdentifier());
        person.setName("France president");
        LongProvider countryIdProvider = new LongProvider(456L);
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        dummyCountry.setPresident(person);
        countryPersister.insert((Object)dummyCountry);
        ResultSet resultSet = persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select count(*) as countryCount from Country where presidentId = " + person.getId().getDelegate());
        RowIterator resultSetIterator = new RowIterator(resultSet, (Map)Maps.asMap((Object)"countryCount", (Object)DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER));
        resultSetIterator.hasNext();
        Assertions.assertThat((Object)((Row)resultSetIterator.next()).get("countryCount")).isEqualTo((Object)1);
        Country selectedCountry = (Country)countryPersister.select(dummyCountry.getId());
        Person person2 = new Person((Long)personIdProvider.giveNewIdentifier());
        person2.setName("French president");
        dummyCountry.setPresident(person2);
        countryPersister.update((Object)dummyCountry, (Object)selectedCountry, false);
        resultSet = persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select count(*) as countryCount from Country where presidentId = " + person2.getId().getDelegate());
        resultSetIterator = new RowIterator(resultSet, (Map)Maps.asMap((Object)"countryCount", (Object)DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER));
        resultSetIterator.hasNext();
        Assertions.assertThat((Object)((Row)resultSetIterator.next()).get("countryCount")).isEqualTo((Object)1);
    }

    @Test
    void multiple_oneToOne() throws SQLException {
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getDescription).mapOneToOne(Country::getPresident, this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).mapOneToOne(Country::getCapital, this.cityConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider countryIdProvider = new LongProvider();
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        dummyCountry.setDescription("Smelly cheese !");
        Person person = new Person((Long)new LongProvider().giveNewIdentifier());
        person.setName("French president");
        dummyCountry.setPresident(person);
        City capital = new City((Long)new LongProvider().giveNewIdentifier());
        capital.setName("Paris");
        dummyCountry.setCapital(capital);
        countryPersister.insert((Object)dummyCountry);
        Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
        Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("French president");
        Assertions.assertThat((String)persistedCountry.getCapital().getName()).isEqualTo("Paris");
        Assertions.assertThat((boolean)persistedCountry.getPresident().getId().isPersisted()).isTrue();
        Assertions.assertThat((boolean)persistedCountry.getCapital().getId().isPersisted()).isTrue();
        Country dummyCountry2 = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry2.setName("France 2");
        dummyCountry2.setPresident(person);
        dummyCountry2.setCapital(capital);
        countryPersister.insert((Object)dummyCountry2);
        Country persistedCountry2 = (Country)countryPersister.select(dummyCountry2.getId());
        Assertions.assertThat(persistedCountry2.getId()).isEqualTo(new PersistedIdentifier<Long>(1L));
        Assertions.assertThat((String)persistedCountry2.getPresident().getName()).isEqualTo("French president");
        Assertions.assertThat((Long)((Long)persistedCountry2.getPresident().getId().getDelegate())).isEqualTo(persistedCountry.getPresident().getId().getDelegate());
        Assertions.assertThat((Long)((Long)persistedCountry2.getCapital().getId().getDelegate())).isEqualTo(persistedCountry.getCapital().getId().getDelegate());
        Assertions.assertThat((Object)persistedCountry2.getPresident()).isNotSameAs((Object)persistedCountry.getPresident());
        Assertions.assertThat((Object)persistedCountry2.getCapital()).isNotSameAs((Object)persistedCountry.getCapital());
        persistedCountry2.getPresident().setName("French president renamed");
        persistedCountry2.getCapital().setName("Paris renamed");
        countryPersister.update((Object)persistedCountry2, (Object)dummyCountry2, true);
        ResultSet resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select name from Person");
        resultSet.next();
        Assertions.assertThat((String)resultSet.getString("name")).isEqualTo("French president renamed");
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select name from City");
        resultSet.next();
        Assertions.assertThat((String)resultSet.getString("name")).isEqualTo("Paris renamed");
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        Assertions.assertThat((int)this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("update Country set presidentId = null, capitalId = null where id = " + dummyCountry2.getId().getDelegate())).isEqualTo(1);
        countryPersister.delete((Object)persistedCountry);
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = " + persistedCountry.getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Person where id = " + persistedCountry.getPresident().getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = " + persistedCountry.getCapital().getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
    }

    @Test
    void multiple_oneToOne_partialOrphanRemoval() throws SQLException {
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getDescription).mapOneToOne(Country::getPresident, this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapOneToOne(Country::getCapital, this.cityConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider countryIdProvider = new LongProvider();
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        dummyCountry.setDescription("Smelly cheese !");
        Person person = new Person((Long)new LongProvider().giveNewIdentifier());
        person.setName("French president");
        dummyCountry.setPresident(person);
        City capital = new City((Long)new LongProvider().giveNewIdentifier());
        capital.setName("Paris");
        dummyCountry.setCapital(capital);
        countryPersister.insert((Object)dummyCountry);
        Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
        Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("French president");
        Assertions.assertThat((String)persistedCountry.getCapital().getName()).isEqualTo("Paris");
        Assertions.assertThat((boolean)persistedCountry.getPresident().getId().isPersisted()).isTrue();
        Assertions.assertThat((boolean)persistedCountry.getCapital().getId().isPersisted()).isTrue();
        Country dummyCountry2 = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry2.setName("France 2");
        dummyCountry2.setPresident(person);
        dummyCountry2.setCapital(capital);
        countryPersister.insert((Object)dummyCountry2);
        Country persistedCountry2 = (Country)countryPersister.select(dummyCountry2.getId());
        Assertions.assertThat(persistedCountry2.getId()).isEqualTo(new PersistedIdentifier<Long>(1L));
        Assertions.assertThat((String)persistedCountry2.getPresident().getName()).isEqualTo("French president");
        Assertions.assertThat((Long)((Long)persistedCountry2.getPresident().getId().getDelegate())).isEqualTo(persistedCountry.getPresident().getId().getDelegate());
        Assertions.assertThat((Long)((Long)persistedCountry2.getCapital().getId().getDelegate())).isEqualTo(persistedCountry.getCapital().getId().getDelegate());
        Assertions.assertThat((Object)persistedCountry2.getPresident()).isNotSameAs((Object)persistedCountry.getPresident());
        Assertions.assertThat((Object)persistedCountry2.getCapital()).isNotSameAs((Object)persistedCountry.getCapital());
        Assertions.assertThat((int)this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("update Country set presidentId = null, capitalId = null where id = " + dummyCountry.getId().getDelegate())).isEqualTo(1);
        persistedCountry2.setPresident(null);
        persistedCountry2.getCapital().setName("Paris renamed");
        countryPersister.update((Object)persistedCountry2, (Object)dummyCountry2, true);
        ResultSet resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select name from Person");
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select name from City");
        resultSet.next();
        Assertions.assertThat((String)resultSet.getString("name")).isEqualTo("Paris renamed");
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        countryPersister.delete((Object)persistedCountry2);
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = " + persistedCountry2.getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Person where id = " + dummyCountry2.getPresident().getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = " + persistedCountry2.getCapital().getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
    }

    public static class LiteCity {
        private final String name;
        private final Integer countryId;

        public LiteCity(String name, Integer countryId) {
            this.name = name;
            this.countryId = countryId;
        }
    }

    @Nested
    class CascadeAll {
        CascadeAll() {
        }

        @Test
        void ownedBySourceSide() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.cityConfiguration).cascading(CascadeOptions.RelationMode.ALL).mappedBy(City::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            this.assertCascadeAll((EntityPersister<Country, Identifier<Long>>)countryPersister);
        }

        @Test
        void ownedByReverseSideGetter() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.cityConfiguration).cascading(CascadeOptions.RelationMode.ALL).mappedBy(City::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            this.assertCascadeAll((EntityPersister<Country, Identifier<Long>>)countryPersister);
        }

        @Test
        void ownedByReverseSideSetter() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.cityConfiguration).cascading(CascadeOptions.RelationMode.ALL).mappedBy(City::setCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            this.assertCascadeAll((EntityPersister<Country, Identifier<Long>>)countryPersister);
        }

        @Test
        void ownedByReverseSideColumn() {
            Table cityTable = new Table("City");
            Column countryId = cityTable.addColumn("countryId", Identifier.LONG_TYPE);
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityConfigurer = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)cityConfigurer).cascading(CascadeOptions.RelationMode.ALL).mappedBy(countryId).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            this.assertCascadeAll((EntityPersister<Country, Identifier<Long>>)countryPersister);
        }

        private void assertCascadeAll(EntityPersister<Country, Identifier<Long>> countryPersister) {
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider countryIdProvider = new LongProvider(42L);
            Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
            dummyCountry.setName("France");
            dummyCountry.setDescription("Smelly cheese !");
            LongProvider cityIdProvider = new LongProvider();
            City paris = new City((Long)cityIdProvider.giveNewIdentifier());
            paris.setName("Paris");
            dummyCountry.setCapital(paris);
            countryPersister.insert((Object)dummyCountry);
            Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
            Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((String)persistedCountry.getDescription()).isEqualTo("Smelly cheese !");
            Assertions.assertThat((String)persistedCountry.getCapital().getName()).isEqualTo("Paris");
            Assertions.assertThat((boolean)persistedCountry.getCapital().getId().isPersisted()).isTrue();
            Country modifiedCountry = persistedCountry;
            Country referentCountry = dummyCountry;
            modifiedCountry.setCapital(null);
            countryPersister.update((Object)modifiedCountry, (Object)referentCountry, false);
            modifiedCountry = (Country)countryPersister.select(referentCountry.getId());
            Assertions.assertThat((Object)modifiedCountry.getCapital()).isNull();
            PersistenceContext.ExecutableBeanPropertyQueryMapper citySelector = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select name, countryId from City where id = :id", LiteCity.class).mapKey(LiteCity::new, "name", String.class, "countryId", Integer.class);
            LiteCity city = (LiteCity)citySelector.set("id", paris.getId()).execute(Accumulators.getFirstUnique());
            Assertions.assertThat((Object)city).usingRecursiveComparison().isEqualTo((Object)new LiteCity("Paris", null));
            referentCountry = (Country)countryPersister.select(referentCountry.getId());
            City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
            lyon.setName("Lyon");
            modifiedCountry.setCapital(lyon);
            countryPersister.update((Object)modifiedCountry, (Object)referentCountry, false);
            modifiedCountry = (Country)countryPersister.select(referentCountry.getId());
            Assertions.assertThat((Object)modifiedCountry.getCapital()).isEqualTo((Object)lyon);
            Assertions.assertThat((Object)citySelector.set("id", lyon.getId()).execute(Accumulators.getFirstUnique())).usingRecursiveComparison().isEqualTo((Object)new LiteCity("Lyon", 42));
            referentCountry = (Country)countryPersister.select(referentCountry.getId());
            modifiedCountry.getCapital().setName("Lyon renamed");
            countryPersister.update((Object)modifiedCountry, (Object)referentCountry, false);
            modifiedCountry = (Country)countryPersister.select(referentCountry.getId());
            Assertions.assertThat((Object)citySelector.set("id", lyon.getId()).execute(Accumulators.getFirstUnique())).usingRecursiveComparison().isEqualTo((Object)new LiteCity("Lyon renamed", 42));
            countryPersister.delete((Object)modifiedCountry);
            Assertions.assertThat((Object)citySelector.set("id", lyon.getId()).execute(Accumulators.getFirstUnique())).usingRecursiveComparison().isEqualTo((Object)new LiteCity("Lyon renamed", null));
        }

        @Nested
        class Delete {
            Delete() {
            }

            @Test
            void targetEntityIsDeleted() throws SQLException {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Person(id) values (42), (666)");
                FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country(id, presidentId) values (100, 42), (200, 666)");
                Country persistedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(100L));
                countryPersister.delete((Object)persistedCountry);
                ResultSet resultSet = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 100");
                Assertions.assertThat((boolean)resultSet.next()).isFalse();
                resultSet = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Person where id = 42");
                Assertions.assertThat((boolean)resultSet.next()).isTrue();
                resultSet = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 200");
                Assertions.assertThat((boolean)resultSet.next()).isTrue();
                resultSet = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Person where id = 666");
                Assertions.assertThat((boolean)resultSet.next()).isTrue();
            }
        }

        @Nested
        class Update {
            Update() {
            }

            @Test
            void relationChanged_relationIsOwnedBySource() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                LongProvider personIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                dummyCountry.setDescription("Smelly cheese !");
                Person originalPresident = new Person((Long)personIdProvider.giveNewIdentifier());
                originalPresident.setName("French president");
                dummyCountry.setPresident(originalPresident);
                countryPersister.insert((Object)dummyCountry);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
                persistedCountry.getPresident().setName("French president renamed");
                countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
                Country countryFromDB = (Country)countryPersister.select(dummyCountry.getId());
                Assertions.assertThat((String)countryFromDB.getPresident().getName()).isEqualTo("French president renamed");
                Assertions.assertThat((boolean)persistedCountry.getPresident().getId().isPersisted()).isTrue();
                Person newPresident = new Person((Long)personIdProvider.giveNewIdentifier());
                newPresident.setName("new French president");
                persistedCountry.setPresident(newPresident);
                countryPersister.update((Object)persistedCountry, (Object)countryFromDB, true);
                countryFromDB = (Country)countryPersister.select(dummyCountry.getId());
                Assertions.assertThat((String)countryFromDB.getPresident().getName()).isEqualTo("new French president");
                Assertions.assertThat(countryFromDB.getPresident().getId()).isEqualTo(newPresident.getId());
                EntityPersister personPersister = FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration.build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                Assertions.assertThat((String)((Person)personPersister.select(originalPresident.getId())).getName()).isEqualTo("French president renamed");
            }

            @Test
            void relationChanged_relationIsOwnedByTarget() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).mappedBy(Person::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                LongProvider personIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                dummyCountry.setDescription("Smelly cheese !");
                Person originalPresident = new Person((Long)personIdProvider.giveNewIdentifier());
                originalPresident.setName("French president");
                dummyCountry.setPresident(originalPresident);
                originalPresident.setCountry(dummyCountry);
                countryPersister.insert((Object)dummyCountry);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
                persistedCountry.getPresident().setName("French president renamed");
                countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
                Country countryFromDB = (Country)countryPersister.select(dummyCountry.getId());
                Assertions.assertThat((String)countryFromDB.getPresident().getName()).isEqualTo("French president renamed");
                Assertions.assertThat((boolean)persistedCountry.getPresident().getId().isPersisted()).isTrue();
                Person newPresident = new Person((Long)personIdProvider.giveNewIdentifier());
                newPresident.setName("new French president");
                persistedCountry.setPresident(newPresident);
                newPresident.setCountry(dummyCountry);
                countryPersister.update((Object)persistedCountry, (Object)countryFromDB, true);
                countryFromDB = (Country)countryPersister.select(dummyCountry.getId());
                Assertions.assertThat((String)countryFromDB.getPresident().getName()).isEqualTo("new French president");
                Assertions.assertThat(countryFromDB.getPresident().getId()).isEqualTo(newPresident.getId());
                EntityPersister personPersister = FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration.build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                Assertions.assertThat((String)((Person)personPersister.select(originalPresident.getId())).getName()).isEqualTo("French president renamed");
                PersistenceContext.ExecutableBeanPropertyQueryMapper countryIdQuery = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select countryId from Person where id = :personId", Long.class).mapKey("countryId", Long.class);
                PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = countryIdQuery.set("personId", originalPresident.getId());
                Set originalPresidentCountryId = (Set)longExecutableQuery1.execute(Accumulators.toSet());
                Assertions.assertThat((Long)((Long)Iterables.first((Iterable)originalPresidentCountryId))).isNull();
                PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = countryIdQuery.set("personId", newPresident.getId());
                Set newPresidentCountryId = (Set)longExecutableQuery.execute(Accumulators.toSet());
                Assertions.assertThat((Long)((Long)dummyCountry.getId().getDelegate())).isEqualTo(Iterables.first((Iterable)newPresidentCountryId));
            }

            @Test
            void relationNullified_relationIsOwnedBySource() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                LongProvider personIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                dummyCountry.setDescription("Smelly cheese !");
                Person president = new Person((Long)personIdProvider.giveNewIdentifier());
                president.setName("French president");
                dummyCountry.setPresident(president);
                countryPersister.insert((Object)dummyCountry);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
                persistedCountry.setPresident(null);
                countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
                Country countryFromDB = (Country)countryPersister.select(dummyCountry.getId());
                Assertions.assertThat((Object)countryFromDB.getPresident()).isNull();
                EntityPersister personPersister = FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration.build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                Person previousPresident = (Person)personPersister.select(president.getId());
                Assertions.assertThat((Object)previousPresident).isNotNull();
                Assertions.assertThat((String)previousPresident.getName()).isNotNull();
            }

            @Test
            void relationNullifiedWithOrphanRemoval() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                LongProvider personIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                dummyCountry.setDescription("Smelly cheese !");
                Person president = new Person((Long)personIdProvider.giveNewIdentifier());
                president.setName("French president");
                dummyCountry.setPresident(president);
                countryPersister.insert((Object)dummyCountry);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
                persistedCountry.setPresident(null);
                countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
                Country countryFromDB = (Country)countryPersister.select(dummyCountry.getId());
                Assertions.assertThat((Object)countryFromDB.getPresident()).isNull();
                EntityPersister personPersister = FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration.build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                Person previousPresident = (Person)personPersister.select(president.getId());
                Assertions.assertThat((Object)previousPresident).isNull();
            }

            @Test
            void relationChanged_relationIsOwnedBySource_withOrphanRemoval() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                LongProvider personIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                dummyCountry.setDescription("Smelly cheese !");
                Person president = new Person((Long)personIdProvider.giveNewIdentifier());
                president.setName("French president");
                dummyCountry.setPresident(president);
                countryPersister.insert((Object)dummyCountry);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
                Person newPresident = new Person((Long)personIdProvider.giveNewIdentifier());
                newPresident.setName("New French president");
                persistedCountry.setPresident(newPresident);
                countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
                Country countryFromDB = (Country)countryPersister.select(dummyCountry.getId());
                Assertions.assertThat((Object)countryFromDB.getPresident()).isEqualTo((Object)newPresident);
                EntityPersister personPersister = FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration.build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                Person previousPresident = (Person)personPersister.select(president.getId());
                Assertions.assertThat((Object)previousPresident).isNull();
            }

            @Test
            void mandatory_withNullTarget_throwsException() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).mandatory().build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                Person person = new Person((Long)new LongProvider().giveNewIdentifier());
                person.setName("French president");
                dummyCountry.setPresident(person);
                countryPersister.insert((Object)dummyCountry);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
                persistedCountry.setPresident(null);
                ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(RuntimeMappingException.class).as("Non null value expected for relation o.c.s.e.m.Person o.c.s.e.m.Country.getPresident() on object Country@0", new Object[0])).isThrownBy(() -> countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true));
            }
        }

        @Nested
        class Insert {
            Insert() {
            }

            @Test
            void insertOnce_targetInstanceIsInserted() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                dummyCountry.setDescription("Smelly cheese !");
                Person person = new Person((Long)new LongProvider().giveNewIdentifier());
                person.setName("French president");
                dummyCountry.setPresident(person);
                countryPersister.insert((Object)dummyCountry);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
                Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
                Assertions.assertThat((String)persistedCountry.getDescription()).isEqualTo("Smelly cheese !");
                Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("French president");
                Assertions.assertThat((boolean)persistedCountry.getPresident().getId().isPersisted()).isTrue();
            }

            @Test
            void insertTwice_targetInstanceIsInsertedOnce() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                dummyCountry.setDescription("Smelly cheese !");
                Person person = new Person((Long)new LongProvider().giveNewIdentifier());
                person.setName("French president");
                dummyCountry.setPresident(person);
                countryPersister.insert((Object)dummyCountry);
                Country dummyCountry2 = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry2.setName("France 2");
                dummyCountry2.setPresident(person);
                countryPersister.insert((Object)dummyCountry2);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry2.getId());
                Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(1L));
                Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("French president");
                Assertions.assertThat((Long)((Long)persistedCountry.getPresident().getId().getDelegate())).isEqualTo(dummyCountry.getPresident().getId().getDelegate());
                Assertions.assertThat((Object)persistedCountry.getPresident()).isNotSameAs((Object)dummyCountry.getPresident());
            }

            @Test
            void mandatory_withNullTarget_throwsException() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).mandatory().build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(RuntimeMappingException.class).as("Non null value expected for relation o.c.s.e.m.Person o.c.s.e.m.Country.getPresident() on object Country@0", new Object[0])).isThrownBy(() -> countryPersister.insert((Object)dummyCountry));
            }

            @Test
            void insert_targetInstanceIsUpdated() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                dummyCountry.setDescription("Smelly cheese !");
                Person person = new Person((Long)new LongProvider().giveNewIdentifier());
                person.setName("French president");
                dummyCountry.setPresident(person);
                countryPersister.insert((Object)dummyCountry);
                person.setName("Me !!");
                Country dummyCountry2 = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry2.setName("France 2");
                dummyCountry2.setPresident(person);
                countryPersister.insert((Object)dummyCountry2);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry2.getId());
                Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("Me !!");
                PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as countryCount from Country", Long.class).mapKey(Long::new, "countryCount", Long.class);
                Set countryCount = (Set)longExecutableQuery.execute(Accumulators.toSet());
                Assertions.assertThat((Long)((Long)Iterables.first((Iterable)countryCount))).isEqualTo(2L);
            }

            @Test
            void insert_targetInstanceIsUpdated_ownedByReverseSide() {
                EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL).mappedBy(Person::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
                ddlDeployer.deployDDL();
                LongProvider countryIdProvider = new LongProvider();
                Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry.setName("France");
                dummyCountry.setDescription("Smelly cheese !");
                Person person = new Person((Long)new LongProvider().giveNewIdentifier());
                person.setName("French president");
                dummyCountry.setPresident(person);
                person.setCountry(dummyCountry);
                countryPersister.insert((Object)dummyCountry);
                person.setName("Me !!");
                Country dummyCountry2 = new Country((Long)countryIdProvider.giveNewIdentifier());
                dummyCountry2.setName("France 2");
                dummyCountry2.setPresident(person);
                person.setCountry(dummyCountry2);
                countryPersister.insert((Object)dummyCountry2);
                Country persistedCountry = (Country)countryPersister.select(dummyCountry2.getId());
                Assertions.assertThat((String)persistedCountry.getPresident().getName()).isEqualTo("Me !!");
                PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as countryCount from Country", Long.class).mapKey(Long::new, "countryCount", Long.class);
                Set countryCount = (Set)longExecutableQuery.execute(Accumulators.toSet());
                Assertions.assertThat((Long)((Long)Iterables.first((Iterable)countryCount))).isEqualTo(2L);
            }
        }
    }

    @Nested
    class ForeignKeyCreation {
        ForeignKeyCreation() {
        }

        @Test
        void relationOwnedBySource() throws SQLException {
            MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.cityConfiguration).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, "CITY")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_COUNTRY_CAPITALID_CITY_ID", "COUNTRY", "CAPITALID", "CITY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void relationOwnedByTargetSide() throws SQLException {
            ConfiguredPersister countryPersister = (ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.cityConfiguration).mappedBy(City::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, countryPersister.getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_CITY_COUNTRYID_COUNTRY_ID", "CITY", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void relationIsDefinedByColumnOnTargetSide() throws SQLException {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityMappingBuilder = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
            Table cityTable = new Table("city");
            Column stateColumn = cityTable.addColumn("state", Identifier.LONG_TYPE);
            ConfiguredPersister countryPersister = (ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)cityMappingBuilder).mappedBy(stateColumn).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_city_state_Country_id", "city", "state", "Country", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)cityTable.getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, countryPersister.getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualToIgnoringCase((CharSequence)expectedForeignKey.getSignature());
        }

        @Test
        void relationIsDefinedByColumnOnTargetSideAndReverseAccessorIsUsed_columnOverrideIsUsed() throws SQLException {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityMappingBuilder = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
            Table cityTable = new Table("city");
            Column stateColumn = cityTable.addColumn("state", Identifier.LONG_TYPE);
            ConfiguredPersister countryPersister = (ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)cityMappingBuilder).mappedBy(stateColumn).mappedBy(City::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, countryPersister.getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_CITY_STATE_COUNTRY_ID", "CITY", "STATE", "COUNTRY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void relationIsDefinedByColumnOnTargetSideAndReverseMutatorIsUsed_columnOverrideIsUsed() throws SQLException {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityMappingBuilder = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
            Table cityTable = new Table("city");
            Column stateColumn = cityTable.addColumn("state", Identifier.LONG_TYPE);
            ConfiguredPersister countryPersister = (ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)cityMappingBuilder).mappedBy(stateColumn).mappedBy(City::setCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, countryPersister.getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_CITY_STATE_COUNTRY_ID", "CITY", "STATE", "COUNTRY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void withTargetTable_targetTableIsUsed() throws SQLException {
            ConfiguredPersister countryPersister = (ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName), new Table("Township")).mappedBy(City::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTable_targetTableIsUsed$0((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"COUNTRY", "TOWNSHIP"});
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, countryPersister.getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_TOWNSHIP_COUNTRYID_COUNTRY_ID", "TOWNSHIP", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed() throws SQLException {
            ConfiguredPersister countryPersister = (ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE, (Table)new Table("Town")).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName)).mappedBy(City::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$1((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"COUNTRY", "TOWN"});
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, countryPersister.getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_TOWN_COUNTRYID_COUNTRY_ID", "TOWN", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void withTargetTableAndTableSetByTargetEntity_targetTableIsUsed() throws SQLException {
            ConfiguredPersister countryPersister = (ConfiguredPersister)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getCapital, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE, (Table)new Table("Town")).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName), new Table("Township")).mappedBy(City::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$2((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"COUNTRY", "TOWNSHIP"});
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, countryPersister.getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_TOWNSHIP_COUNTRYID_COUNTRY_ID", "TOWNSHIP", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        private static /* synthetic */ Iterator lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$2(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$1(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTable_targetTableIsUsed$0(ResultSetIterator tableIterator) {
            return tableIterator;
        }
    }

    @Nested
    class CascadeDeclaration {
        CascadeDeclaration() {
        }

        @Test
        void associationOnly_throwsException() {
            FluentEntityMappingBuilder.FluentMappingBuilderOneToOneOptions mappingBuilder = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$associationOnly_throwsException$0((FluentEntityMappingBuilder)mappingBuilder)).extracting(t -> (MappingConfigurationException)Exceptions.findExceptionInCauses((Throwable)t, MappingConfigurationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage(CascadeOptions.RelationMode.ASSOCIATION_ONLY + " is only relevant for one-to-many association");
        }

        @Test
        void notDefined_defaultIsAll_getter() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Country country = new Country(new PersistableIdentifier<Long>(42L));
            country.setPresident(new Person(new PersistableIdentifier<Long>(666L)));
            countryPersister.insert((Object)country);
            Country selectedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Long)((Long)selectedCountry.getId().getDelegate())).isEqualTo(42L);
            Assertions.assertThat((Long)((Long)selectedCountry.getPresident().getId().getDelegate())).isEqualTo(666L);
            countryPersister.delete((Object)selectedCountry);
            Assertions.assertThat((Object)countryPersister.select(new PersistedIdentifier<Long>(42L))).isEqualTo(null);
            EntityPersister personPersister = FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration.build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            Assertions.assertThat((Long)((Long)((Person)personPersister.select(new PersistedIdentifier<Long>(666L))).getId().getDelegate())).isEqualTo(666L);
        }

        @Test
        void readOnly_getter() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            this.assert_cascade_readOnly((EntityPersister<Country, Identifier<Long>>)countryPersister);
        }

        @Test
        void readOnly_setter() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::setPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            this.assert_cascade_readOnly((EntityPersister<Country, Identifier<Long>>)countryPersister);
        }

        private void assert_cascade_readOnly(EntityPersister<Country, Identifier<Long>> countryPersister) throws SQLException {
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Country dummyCountry = new Country(new PersistableIdentifier<Long>(42L));
            dummyCountry.setName("France");
            dummyCountry.setDescription("Smelly cheese !");
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setName("French president");
            dummyCountry.setPresident(person);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> countryPersister.insert((Object)dummyCountry)).extracting(t -> (BatchUpdateException)Exceptions.findExceptionInCauses((Throwable)t, BatchUpdateException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("integrity constraint violation: foreign key no parent ; FK_COUNTRY_PRESIDENTID_PERSON_ID table: COUNTRY value: 1");
            FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Person(id, name) values (1, 'French president')").execute();
            FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Country(id, name, presidentId) values (42, 'France', 1)").execute();
            Country loadedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((String)loadedCountry.getName()).isEqualTo("France");
            Assertions.assertThat((String)loadedCountry.getPresident().getName()).isEqualTo("French president");
            loadedCountry.setName("touched France");
            loadedCountry.getPresident().setName("touched french president");
            countryPersister.update((Object)loadedCountry, (Object)dummyCountry, false);
            Assertions.assertThat((String)((String)FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Person where id = 1", String.class).mapKey("name", String.class).execute(Accumulators.getFirst()))).isEqualTo("French president");
            countryPersister.delete((Object)loadedCountry);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Country", String.class).mapKey("name", String.class);
            Assertions.assertThat((boolean)((Set)stringExecutableQuery.execute(Accumulators.toSet())).isEmpty()).isTrue();
            Assertions.assertThat((String)((String)FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Person where id = 1", String.class).mapKey("name", String.class).execute(Accumulators.getFirst()))).isEqualTo("French president");
        }

        @Test
        void readOnly_getter_ownedByTarget() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.READ_ONLY).mappedBy(Person::getCountry).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            this.assert_cascade_readOnly_ownByTarget((EntityPersister<Country, Identifier<Long>>)countryPersister);
        }

        private void assert_cascade_readOnly_ownByTarget(EntityPersister<Country, Identifier<Long>> countryPersister) throws SQLException {
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Country dummyCountry = new Country(new PersistableIdentifier<Long>(42L));
            dummyCountry.setName("France");
            dummyCountry.setDescription("Smelly cheese !");
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setName("French president");
            dummyCountry.setPresident(person);
            EntityPersister personPersister = FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration.build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            personPersister.insert((Object)person);
            countryPersister.insert((Object)dummyCountry);
            Country loadedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((String)loadedCountry.getName()).isEqualTo("France");
            Assertions.assertThat((String)loadedCountry.getPresident().getName()).isEqualTo("French president");
            loadedCountry.setName("touched France");
            loadedCountry.getPresident().setName("touched french president");
            countryPersister.update((Object)loadedCountry, (Object)dummyCountry, false);
            Assertions.assertThat((String)((String)FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Person where id = 1", String.class).mapKey("name", String.class).execute(Accumulators.getFirst()))).isEqualTo("French president");
            Person newPerson = new Person(new PersistableIdentifier<Long>(2L));
            newPerson.setName("New French president");
            FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getPersister(Person.class).insert((Object)newPerson);
            dummyCountry.setPresident(newPerson);
            countryPersister.update((Object)dummyCountry, (Object)loadedCountry, true);
            Assertions.assertThat((String)((Country)countryPersister.select(new PersistedIdentifier<Long>(42L))).getPresident().getName()).isEqualTo("New French president");
            countryPersister.delete((Object)dummyCountry);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery2 = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Country", String.class).mapKey("name", String.class);
            Assertions.assertThat((Collection)((Collection)stringExecutableQuery2.execute(Accumulators.toSet()))).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery1 = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Person", String.class).mapKey("name", String.class);
            Assertions.assertThat((Collection)((Collection)stringExecutableQuery1.execute(Accumulators.toSet()))).containsExactly((Object[])new String[]{"French president", "New French president"});
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Person where id = 2", String.class).mapKey("name", String.class);
            ((ObjectAssert)Assertions.assertThat((Collection)((Collection)stringExecutableQuery.execute(Accumulators.toSet()))).first()).isEqualTo((Object)"New French president");
        }

        @Test
        void cascade_deleteWithOrphanRemoval() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportOneToOneTest.this.personConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Person(id) values (42), (666)");
            FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country(id, presidentId) values (100, 42), (200, 666)");
            Country persistedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(100L));
            countryPersister.delete((Object)persistedCountry);
            ResultSet resultSet = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 100");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Person where id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 200");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Person where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
        }

        private /* synthetic */ void lambda$associationOnly_throwsException$0(FluentEntityMappingBuilder mappingBuilder) throws Throwable {
            mappingBuilder.build(FluentEntityMappingConfigurationSupportOneToOneTest.this.persistenceContext);
        }
    }
}

