/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.trace.MutableInt;

public class TablePerClassPolymorphicSelectExecutor<C, I, T extends Table<T>>
implements SelectExecutor<C, I> {
    private static final String UNION_ALL_SEPARATOR = ") union all (";
    @VisibleForTesting
    protected static final String DISCRIMINATOR_ALIAS = "Y";
    private final ConfiguredRelationalPersister<C, I> mainPersister;
    private final Map<Class<? extends C>, Table> tablePerSubEntity;
    private final Map<Class<C>, ConfiguredRelationalPersister<C, I>> subEntitiesPersisters;
    private final ConnectionProvider connectionProvider;
    private final Dialect dialect;
    private final String discriminatorAlias;
    private final Map<Class, String> discriminatorValuePerSubType;
    private final Map<String, Class> subTypePerDiscriminatorValue;

    public TablePerClassPolymorphicSelectExecutor(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, ConnectionProvider connectionProvider, Dialect dialect) {
        this.mainPersister = mainPersister;
        this.subEntitiesPersisters = subEntitiesPersisters;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
        this.discriminatorAlias = DISCRIMINATOR_ALIAS;
        this.tablePerSubEntity = Iterables.map(subEntitiesPersisters.entrySet(), Map.Entry::getKey, (Function)Functions.chain(Map.Entry::getValue, ConfiguredRelationalPersister::getMainTable), KeepOrderMap::new);
        this.discriminatorValuePerSubType = Iterables.map(this.tablePerSubEntity.entrySet(), Map.Entry::getKey, entry -> ((Class)entry.getKey()).getSimpleName());
        this.subTypePerDiscriminatorValue = Iterables.map(this.tablePerSubEntity.entrySet(), entry -> ((Class)entry.getKey()).getSimpleName(), Map.Entry::getKey);
    }

    public Set<C> select(Iterable<I> ids) {
        PrimaryKey primaryKey = this.mainPersister.getMainTable().getPrimaryKey();
        if (primaryKey.isComposed() && !this.dialect.supportsTupleCondition()) {
            throw new UnsupportedOperationException("Database doesn't support tuple-in so selection can't be done trivially, not yet supported");
        }
        KeepOrderSet queries = new KeepOrderSet();
        HashMap<String, ParameterBinder> readers = new HashMap<String, ParameterBinder>();
        readers.put(this.discriminatorAlias, this.dialect.getColumnBinderRegistry().getBinder(String.class));
        this.mainPersister.getMainTable().getPrimaryKey().getColumns().forEach(column -> readers.put(column.getName(), this.dialect.getColumnBinderRegistry().getBinder(column)));
        ColumnedRow columnedRow = new ColumnedRow(selectable -> ((Column)selectable).getName());
        this.tablePerSubEntity.forEach((arg_0, arg_1) -> this.lambda$select$5(columnedRow, primaryKey, ids, (Set)queries, arg_0, arg_1));
        HashMap parameterBinders = new HashMap();
        HashMap values = new HashMap();
        StringAppender unionSql = new StringAppender();
        MutableInt parameterIndex = new MutableInt(1);
        MutableInt queriesCount = new MutableInt(1);
        queries.forEach(preparedSQL -> {
            unionSql.cat((Object)preparedSQL.getSQL(), (Object)UNION_ALL_SEPARATOR);
            preparedSQL.getValues().values().forEach(value -> {
                values.put(parameterIndex.getValue(), value);
                Object parameterBinder = !primaryKey.isComposed() ? this.dialect.getColumnBinderRegistry().getBinder(Iterables.first((Iterable)this.mainPersister.getMainTable().getPrimaryKey().getColumns())) : preparedSQL.getParameterBinder((Object)(parameterIndex.getValue() - (queriesCount.getValue() - 1) * primaryKey.getColumns().size()));
                parameterBinders.put(parameterIndex.getValue(), parameterBinder);
                parameterIndex.increment();
            });
            queriesCount.increment();
        });
        unionSql.cutTail(UNION_ALL_SEPARATOR.length());
        unionSql.wrap((Object)"(", (Object)")");
        PreparedSQL preparedSQL2 = new PreparedSQL(unionSql.toString(), parameterBinders);
        preparedSQL2.setValues(values);
        KeepOrderMap idsPerSubclass = new KeepOrderMap();
        try (ReadOperation readOperation = this.dialect.getReadOperationFactory().createInstance((SQLStatement)preparedSQL2, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            RowIterator resultSetIterator = new RowIterator(resultSet, readers);
            resultSetIterator.forEachRemaining(arg_0 -> this.lambda$select$9((Map)idsPerSubclass, columnedRow, arg_0));
        }
        HashSet result = new HashSet();
        idsPerSubclass.forEach((subclass, subclassIds) -> result.addAll(this.subEntitiesPersisters.get(subclass).select((Iterable)subclassIds)));
        return result;
    }

    @VisibleForTesting
    TupleIn transformCompositeIdentifierColumnValuesToTupleInValues(int idsCount, Map<? extends Column<T, ?>, Object> values) {
        ArrayList<Object[]> resultValues = new ArrayList<Object[]>(idsCount);
        Column[] columns = new ArrayList(values.keySet()).toArray(new Column[0]);
        for (int i = 0; i < idsCount; ++i) {
            ArrayList<Object> beanValues = new ArrayList<Object>(columns.length);
            for (Column column : columns) {
                Object value = values.get(column);
                if (value instanceof List) {
                    beanValues.add(((List)value).get(i));
                    continue;
                }
                beanValues.add(value);
            }
            resultValues.add(beanValues.toArray());
        }
        return new TupleIn(columns, resultValues);
    }

    private /* synthetic */ void lambda$select$9(Map idsPerSubclass, ColumnedRow columnedRow, Row row) {
        String discriminatorValue = (String)row.get(this.discriminatorAlias);
        Class entitySubclass = this.subTypePerDiscriminatorValue.get(discriminatorValue.trim());
        idsPerSubclass.computeIfAbsent(entitySubclass, k -> new HashSet()).add(this.subEntitiesPersisters.get(entitySubclass).getMapping().getIdMapping().getIdentifierAssembler().assemble(row, columnedRow));
    }

    private /* synthetic */ void lambda$select$5(ColumnedRow columnedRow, PrimaryKey primaryKey, Iterable ids, Set queries, Class subEntityType, Table subEntityTable) {
        PrimaryKey subClassPrimaryKey = subEntityTable.getPrimaryKey();
        String discriminatorValue = this.discriminatorValuePerSubType.get(subEntityType);
        TreeMap aliases = new TreeMap(Comparator.comparing(Column::getName));
        subClassPrimaryKey.getColumns().forEach(column -> aliases.put((Column)column, columnedRow.getAlias((Selectable)column)));
        Query.FluentFromClause from = QueryEase.select(aliases).add("'" + discriminatorValue + "'", String.class).as(this.discriminatorAlias).from((Fromable)subEntityTable);
        if (!primaryKey.isComposed()) {
            from.where((Column)Iterables.first((Iterable)subClassPrimaryKey.getColumns()), (ConditionalOperator)Operators.in((Iterable)ids));
        } else {
            List idsAsList = Collections.asList((Iterable)ids);
            Map columnValues = this.subEntitiesPersisters.get(subEntityType).getMapping().getIdMapping().getIdentifierAssembler().getColumnValues(idsAsList);
            from.where(new Object[]{this.transformCompositeIdentifierColumnValuesToTupleInValues(idsAsList.size(), columnValues)});
        }
        Query query = (Query)from.getQuery();
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query);
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        queries.add(preparedSQL);
    }
}

