/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Engine;
import org.codefilarete.stalactite.engine.model.Truck;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class FluentEntityMappingConfigurationSupportPolymorphismTest {
    private static final Dialect DIALECT = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private final ConnectionProvider connectionProvider = new CurrentThreadConnectionProvider(this.dataSource);
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportPolymorphismTest() {
    }

    @BeforeAll
    static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
        DIALECT.getColumnBinderRegistry().register(Color.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER, Color::new, Color::getRgb)));
        DIALECT.getSqlTypeRegistry().put(Color.class, "int");
    }

    @BeforeEach
    public void beforeTest() {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, DIALECT);
    }

    static Object[][] polymorphicPersisters() {
        PersistenceContext persistenceContext1 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext2 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        PersistenceContext persistenceContext3 = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
        Object[][] result = new Object[][]{{"single table", MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId).map(Vehicle::getColor), (Object)"TRUCK")).build(persistenceContext1), persistenceContext1.getConnectionProvider()}, {"joined tables", MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId).map(Vehicle::getColor))).build(persistenceContext2), persistenceContext2.getConnectionProvider()}, {"table per class", MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId).map(Vehicle::getColor))).build(persistenceContext3), persistenceContext3.getConnectionProvider()}};
        new DDLDeployer(persistenceContext1).deployDDL();
        new DDLDeployer(persistenceContext2).deployDDL();
        new DDLDeployer(persistenceContext3).deployDDL();
        return result;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"polymorphicPersisters"})
    void crud(String testDisplayName, EntityPersister<AbstractVehicle, Identifier<Long>> persister, ConnectionProvider connectionProvider) throws SQLException {
        Car dummyCar = new Car(1L);
        dummyCar.setModel("Renault");
        Truck dummyTruck = new Truck(2L);
        dummyTruck.setColor(new Color(42));
        persister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
        Car dummyCarModified = new Car(1L);
        dummyCarModified.setModel("Peugeot");
        Truck dummyTruckModified = new Truck(2L);
        dummyTruckModified.setColor(new Color(99));
        persister.update((Object)dummyCarModified, (Object)dummyCar, true);
        persister.update((Object)dummyTruckModified, (Object)dummyTruck, true);
        connectionProvider.giveConnection().commit();
        persister.delete((Object)dummyCarModified);
        persister.delete((Object)dummyTruckModified);
        connectionProvider.giveConnection().rollback();
        persister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCarModified, dummyTruckModified}));
        connectionProvider.giveConnection().rollback();
        Assertions.assertThat((Object)persister.select(dummyTruck.getId())).isEqualTo((Object)dummyTruckModified);
        Assertions.assertThat((Object)persister.select(dummyCar.getId())).isEqualTo((Object)dummyCarModified);
        Assertions.assertThat(new HashSet(persister.select((Iterable)Arrays.asSet((Object[])new Identifier[]{dummyCar.getId(), dummyTruck.getId()})))).isEqualTo((Object)Arrays.asSet((Object[])new Vehicle[]{dummyCarModified, dummyTruckModified}));
    }

    static enum ElectricPlug {
        Type1,
        Type2,
        CCS,
        CHAdeMo;

    }

    static class ElectricCar
    extends Car {
        private ElectricPlug plug;

        ElectricCar() {
        }

        ElectricCar(long id) {
            super(id);
        }

        public ElectricPlug getPlug() {
            return this.plug;
        }

        public ElectricCar setPlug(ElectricPlug plug) {
            this.plug = plug;
            return this;
        }
    }

    @Nested
    class TablePerClass {
        TablePerClass() {
        }

        @Test
        void oneSubClass() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Car"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{AbstractVehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select * from car", String.class).mapKey("model", String.class);
            Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
            abstractVehiclePersister.delete((Object)dummyCar);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).isEmpty();
        }

        @Test
        void twoSubClasses() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).map(Vehicle::getColor)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Car", "Truck"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{AbstractVehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from car", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from truck", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            AbstractVehicle loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            Set loadedVehicles = abstractVehiclePersister.selectAll();
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new AbstractVehicle[]{dummyTruck, dummyCar});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from car where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from car where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
        }

        @Test
        void twoSubClasses_withReadonlyProperty() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel).readonly().map(Vehicle::getColor)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select model from Car", String.class).mapKey("model", String.class);
            String model = (String)vehicleIdQuery.execute(Accumulators.getFirst());
            Assertions.assertThat((String)model).isNull();
        }

        @Test
        void twoSubClasses_withCommonProperties() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(Car::getModel)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Car", "Truck"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from car", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from truck", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Vehicle loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery1 = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(42)));
            Set loadedVehicles = (Set)vehicleExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyTruck});
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(666)));
            loadedVehicles = (Set)vehicleExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyCar});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from car where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from truck where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
        }

        @Test
        void listenersAreNotified() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.tablePerClass().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            PersistListener persistListenerMock = (PersistListener)Mockito.mock(PersistListener.class);
            InsertListener insertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
            UpdateListener updateListenerMock = (UpdateListener)Mockito.mock(UpdateListener.class);
            SelectListener selectListenerMock = (SelectListener)Mockito.mock(SelectListener.class);
            DeleteListener deleteListenerMock = (DeleteListener)Mockito.mock(DeleteListener.class);
            abstractVehiclePersister.addPersistListener(persistListenerMock);
            abstractVehiclePersister.addInsertListener(insertListenerMock);
            abstractVehiclePersister.addUpdateListener(updateListenerMock);
            abstractVehiclePersister.addSelectListener(selectListenerMock);
            abstractVehiclePersister.addDeleteListener(deleteListenerMock);
            abstractVehiclePersister.insert((Object)dummyCar);
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            abstractVehiclePersister.update((Object)dummyCar, (Object)dummyCar, true);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            abstractVehiclePersister.delete((Object)dummyCar);
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).beforeDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).afterDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            Mockito.clearInvocations((Object[])new Object[]{insertListenerMock, updateListenerMock, selectListenerMock});
            dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.persist((Object)dummyCar);
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).beforePersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).afterPersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            Mockito.clearInvocations((Object[])new SelectListener[]{selectListenerMock});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new PersistedIdentifier[]{new PersistedIdentifier<Long>(1L)}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).afterSelect((Set)Arrays.asHashSet((Object[])new AbstractVehicle[]{loadedCar}));
        }
    }

    @Nested
    class JoinTable {
        JoinTable() {
        }

        @Test
        void oneSubClass() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"AbstractVehicle", "Car"}));
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{AbstractVehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select * from abstractVehicle left outer join car on abstractVehicle.id = car.id", String.class).mapKey("model", String.class);
            Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
            abstractVehiclePersister.delete((Object)dummyCar);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).isEmpty();
        }

        @Test
        void twoSubClasses() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"AbstractVehicle", "Car", "Truck"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{AbstractVehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from abstractVehicle", Integer.class).mapKey("id", Integer.class);
            Set vehicleIds = (Set)vehicleIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)vehicleIds).containsExactly((Object[])new Integer[]{1, 2});
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from car", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from truck", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            AbstractVehicle loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            Set loadedVehicles = abstractVehiclePersister.selectAll();
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new AbstractVehicle[]{dummyCar, dummyTruck});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as vehicleCount from abstractVehicle where id in (" + dummyCar.getId().getDelegate() + ", " + (Long)dummyTruck.getId().getDelegate() + ")"), Integer.class).mapKey("vehicleCount", Integer.class);
            Integer vehicleCount = (Integer)Iterables.first((Iterable)((Iterable)vehicleQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)vehicleCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from car where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from car where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
        }

        @Test
        void twoSubClasses_withReadonlyProperty() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).readonly().map(Vehicle::getColor)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select model from Car", String.class).mapKey("model", String.class);
            String model = (String)vehicleIdQuery.execute(Accumulators.getFirst());
            Assertions.assertThat((String)model).isNull();
        }

        @Test
        void twoSubClasses_withCommonProperties() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel)).addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle", "Car", "Truck"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from Vehicle", Integer.class).mapKey("id", Integer.class);
            Set vehicleIds = (Set)vehicleIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)vehicleIds).containsExactly((Object[])new Integer[]{1, 2});
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from car", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from truck", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Vehicle loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            dummyCar.setColor(new Color(256));
            abstractVehiclePersister.update((Object)dummyCar, (Object)loadedVehicle, false);
            loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery1 = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(42)));
            Set loadedVehicles = (Set)vehicleExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyTruck});
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(256)));
            loadedVehicles = (Set)vehicleExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyCar});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from Vehicle where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from Vehicle where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
        }

        @Test
        void listenersAreNotified() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor))).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            PersistListener persistListenerMock = (PersistListener)Mockito.mock(PersistListener.class);
            InsertListener insertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
            UpdateListener updateListenerMock = (UpdateListener)Mockito.mock(UpdateListener.class);
            SelectListener selectListenerMock = (SelectListener)Mockito.mock(SelectListener.class);
            DeleteListener deleteListenerMock = (DeleteListener)Mockito.mock(DeleteListener.class);
            abstractVehiclePersister.addPersistListener(persistListenerMock);
            abstractVehiclePersister.addInsertListener(insertListenerMock);
            abstractVehiclePersister.addUpdateListener(updateListenerMock);
            abstractVehiclePersister.addSelectListener(selectListenerMock);
            abstractVehiclePersister.addDeleteListener(deleteListenerMock);
            abstractVehiclePersister.insert((Object)dummyCar);
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            abstractVehiclePersister.update((Object)dummyCar, (Object)dummyCar, true);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            abstractVehiclePersister.delete((Object)dummyCar);
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).beforeDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).afterDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            Mockito.clearInvocations((Object[])new Object[]{insertListenerMock, updateListenerMock, selectListenerMock});
            dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.persist((Object)dummyCar);
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).beforePersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).afterPersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            Mockito.clearInvocations((Object[])new SelectListener[]{selectListenerMock});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new PersistedIdentifier[]{new PersistedIdentifier<Long>(1L)}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).afterSelect((Set)Arrays.asHashSet((Object[])new AbstractVehicle[]{loadedCar}));
        }
    }

    @Nested
    class SingleTable {
        SingleTable() {
        }

        @Test
        void oneSubClass() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor), (Object)"CAR")).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"AbstractVehicle"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{AbstractVehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select * from abstractVehicle", String.class).mapKey("model", String.class);
            Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactly((Object[])new String[]{"Renault"});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactly((Object[])new String[]{"Peugeot"});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
            abstractVehiclePersister.delete((Object)dummyCar);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).isEmpty();
        }

        @Test
        void twoSubClasses() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId).map(Vehicle::getColor), (Object)"TRUCK")).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"AbstractVehicle"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{AbstractVehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper modelQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select * from abstractVehicle", Duo.class).mapKey(Duo::new, "model", String.class, "color", Integer.class);
            Set allCars = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)"Renault", (Object)666), new Duo(null, (Object)42)});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Set existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)"Peugeot", (Object)666), new Duo(null, (Object)42)});
            AbstractVehicle loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            loadedVehicle = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            Set loadedVehicles = abstractVehiclePersister.selectAll();
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new AbstractVehicle[]{dummyCar, dummyTruck});
            abstractVehiclePersister.delete((Object)dummyCar);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo(null, (Object)42)});
            abstractVehiclePersister.delete((Object)dummyTruck);
            existingModels = (Set)modelQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)existingModels).isEmpty();
        }

        @Test
        void twoSubClasses_withReadonlyProperty() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).readonly().map(Vehicle::getColor), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId).map(Vehicle::getColor), (Object)"TRUCK")).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper vehicleIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select model from AbstractVehicle", String.class).mapKey("model", String.class);
            String model = (String)vehicleIdQuery.execute(Accumulators.getFirst());
            Assertions.assertThat((String)model).isNull();
        }

        @Test
        void twoSubClasses_withSqlBinder() {
            Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
            dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
            dialect.getSqlTypeRegistry().put(Identifier.class, "int");
            PersistenceContext persistenceContext = new PersistenceContext(FluentEntityMappingConfigurationSupportPolymorphismTest.this.connectionProvider, dialect);
            Table abstractVehicleTable = new Table("AbstractVehicle");
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE, (Table)abstractVehicleTable).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor).sqlBinder(DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER.wrap(Color::new, Color::getRgb)), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId), (Object)"TRUCK")).build(persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.insert((Object)dummyCar);
            Assertions.assertThat((Object)((Car)abstractVehiclePersister.select(dummyCar.getId())).getColor()).isEqualTo((Object)new Color(666));
        }

        @Test
        void twoSubClasses_withCommonProperties() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel), (Object)"CAR").addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Truck.class).map(AbstractVehicle::getId), (Object)"TRUCK")).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            HashSet tables = (HashSet)Iterables.collect((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)tables).containsExactlyInAnyOrder((Object[])new String[]{"Vehicle"});
            Assertions.assertThat((Collection)FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.getPersisters()).extracting(EntityPersister::getClassToPersist).containsExactlyInAnyOrder((Object[])new Class[]{Vehicle.class});
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            Truck dummyTruck = new Truck(2L);
            dummyTruck.setColor(new Color(42));
            abstractVehiclePersister.insert((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from Vehicle where DTYPE ='CAR'", Integer.class).mapKey("id", Integer.class);
            Set carIds = (Set)carIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)carIds).containsExactly((Object[])new Integer[]{1});
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckIdQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)"select id from Vehicle where DTYPE ='TRUCK'", Integer.class).mapKey("id", Integer.class);
            Set truckIds = (Set)truckIdQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)truckIds).containsExactly((Object[])new Integer[]{2});
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            Vehicle loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyCar);
            dummyCar.setColor(new Color(256));
            abstractVehiclePersister.update((Object)dummyCar, (Object)loadedVehicle, false);
            loadedVehicle = (Vehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(2L));
            Assertions.assertThat((Object)loadedVehicle).isEqualTo((Object)dummyTruck);
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery1 = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(42)));
            Set loadedVehicles = (Set)vehicleExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyTruck});
            EntityPersister.ExecutableEntityQuery vehicleExecutableQuery = abstractVehiclePersister.selectWhere(Vehicle::getColor, (ConditionalOperator)Operators.eq((Object)new Color(256)));
            loadedVehicles = (Set)vehicleExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)loadedVehicles).containsExactlyInAnyOrder((Object[])new Vehicle[]{dummyCar});
            abstractVehiclePersister.delete((Iterable)Arrays.asList((Object[])new Vehicle[]{dummyCar, dummyTruck}));
            PersistenceContext.ExecutableBeanPropertyQueryMapper carQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as carCount from Vehicle where id = " + dummyCar.getId().getDelegate()), Integer.class).mapKey("carCount", Integer.class);
            Integer carCount = (Integer)Iterables.first((Iterable)((Iterable)carQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)carCount).isEqualTo(0);
            PersistenceContext.ExecutableBeanPropertyQueryMapper truckQuery = FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext.newQuery((CharSequence)("select count(*) as truckCount from Vehicle where id = " + dummyTruck.getId().getDelegate()), Integer.class).mapKey("truckCount", Integer.class);
            Integer truckCount = (Integer)Iterables.first((Iterable)((Iterable)truckQuery.execute(Accumulators.toSet())));
            Assertions.assertThat((Integer)truckCount).isEqualTo(0);
        }

        @Test
        void listenersAreNotified() {
            EntityPersister abstractVehiclePersister = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.singleTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Car.class).map(AbstractVehicle::getId).map(Car::getModel).map(Vehicle::getColor), (Object)"CAR")).build(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportPolymorphismTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            PersistListener persistListenerMock = (PersistListener)Mockito.mock(PersistListener.class);
            InsertListener insertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
            UpdateListener updateListenerMock = (UpdateListener)Mockito.mock(UpdateListener.class);
            SelectListener selectListenerMock = (SelectListener)Mockito.mock(SelectListener.class);
            DeleteListener deleteListenerMock = (DeleteListener)Mockito.mock(DeleteListener.class);
            abstractVehiclePersister.addPersistListener(persistListenerMock);
            abstractVehiclePersister.addInsertListener(insertListenerMock);
            abstractVehiclePersister.addUpdateListener(updateListenerMock);
            abstractVehiclePersister.addSelectListener(selectListenerMock);
            abstractVehiclePersister.addDeleteListener(deleteListenerMock);
            abstractVehiclePersister.insert((Object)dummyCar);
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            abstractVehiclePersister.update((Object)dummyCar, (Object)dummyCar, true);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            abstractVehiclePersister.delete((Object)dummyCar);
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).beforeDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((DeleteListener)Mockito.verify((Object)deleteListenerMock)).afterDelete((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            Mockito.clearInvocations((Object[])new Object[]{insertListenerMock, updateListenerMock, selectListenerMock});
            dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setEngine(new Engine(100L));
            dummyCar.setColor(new Color(666));
            abstractVehiclePersister.persist((Object)dummyCar);
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).beforePersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((PersistListener)Mockito.verify((Object)persistListenerMock)).afterPersist((Iterable)Arrays.asHashSet((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).beforeInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((InsertListener)Mockito.verify((Object)insertListenerMock)).afterInsert((Iterable)Arrays.asList((Object[])new Car[]{dummyCar}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            dummyCar.setModel("Peugeot");
            abstractVehiclePersister.persist((Object)dummyCar);
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).beforeUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((UpdateListener)Mockito.verify((Object)updateListenerMock)).afterUpdate((Iterable)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
            ((SelectListener)Mockito.verify((Object)selectListenerMock, (VerificationMode)Mockito.times((int)2))).beforeSelect((Iterable)Arrays.asHashSet((Object[])new Identifier[]{dummyCar.getId()}));
            Mockito.clearInvocations((Object[])new SelectListener[]{selectListenerMock});
            AbstractVehicle loadedCar = (AbstractVehicle)abstractVehiclePersister.select(new PersistedIdentifier<Long>(1L));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).beforeSelect((Iterable)Arrays.asHashSet((Object[])new PersistedIdentifier[]{new PersistedIdentifier<Long>(1L)}));
            ((SelectListener)Mockito.verify((Object)selectListenerMock)).afterSelect((Set)Arrays.asHashSet((Object[])new AbstractVehicle[]{loadedCar}));
        }
    }
}

