/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.QueryMapper;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.result.ResultSetRowTransformer;
import org.codefilarete.stalactite.sql.result.WholeResultSetTransformer;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.trace.MutableInt;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class QueryMapperTest {
    QueryMapperTest() {
    }

    public static Object[][] queryMapperAPI_basicUsage() {
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", Long.class).primaryKey();
        Column name = totoTable.addColumn("name", String.class);
        Column active = totoTable.addColumn("active", Boolean.TYPE);
        LinkedHashSet expected = Arrays.asSet((Object[])new Toto[]{new Toto(42L, "coucou", true), new Toto(43L, "hello", false)});
        String dummySql = "never executed statement";
        return new Object[][]{{new QueryMapper(TotoWithNoArgConstructor.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).map("id", Toto::setId, Long.TYPE).map("name", Toto::setName, String.class).map("active", Toto::setActive), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("name", Toto::setName, String.class).map("active", Toto::setActive), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("id", Toto::setId).map("name", Toto::setName, String.class).map("active", Toto::setActive), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::ofId, "id", Long.TYPE).map("name", Toto::setName, String.class).map("active", Toto::setActive), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("id", Toto::setId).map(name, Toto::setName).map(active, Toto::setActive), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::new, id).map(name, Toto::setName).map(active, Toto::setActive), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::new, id, name).map(active, Toto::setActive), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::new, id, name, active), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE), Arrays.asSet((Object[])new Toto[]{new Toto(42L, null, false), new Toto(43L, null, false)})}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE, "name", String.class), Arrays.asSet((Object[])new Toto[]{new Toto(42L, "coucou", false), new Toto(43L, "hello", false)})}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE, "name", String.class, "active", Boolean.TYPE), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::ofId, "id").map("name", Toto::setName, String.class).map("active", Toto::setActive), expected}, {new QueryMapper(TotoWithNoArgConstructor.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(TotoWithNoArgConstructor::new).map("id", Toto::setId, Long.TYPE).map("name", Toto::setName, String.class).map("active", Toto::setActive), expected}, {new QueryMapper(TotoWithOneArgConstructor.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(TotoWithOneArgConstructor::new, "id").map("name", Toto::setName, String.class).map("active", Toto::setActive), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::ofIdAndName, "id", "name").map("active", Toto::setActive), expected}, {new QueryMapper(TotoWithTwoArgConstructor.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(TotoWithTwoArgConstructor::new, "id", "name").map("active", Toto::setActive), expected}, {new QueryMapper(Toto.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(Toto::ofIdAndNameAndActive, "id", "name", "active"), expected}, {new QueryMapper(TotoWithThreeArgConstructor.class, (CharSequence)dummySql, columnBinderRegistry, readOperationFactory).mapKey(TotoWithThreeArgConstructor::new, "id", "name", "active"), expected}};
    }

    @ParameterizedTest
    @MethodSource(value={"queryMapperAPI_basicUsage"})
    void queryMapperAPI_basicUsage(QueryMapper<Toto> queryMapper, Set<Toto> expected) {
        List resultSetData = Arrays.asList((Object[])new Map[]{QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"coucou").add((Object)"active", (Object)true), QueryMapperTest.newRow().add((Object)"id", (Object)43L).add((Object)"name", (Object)"hello").add((Object)"active", (Object)false)});
        Set<Toto> result = this.invokeExecuteWithData(queryMapper, resultSetData);
        ((AbstractCollectionAssert)Assertions.assertThat(result).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrderElementsOf(expected);
    }

    public static Object[][] queryMapperAPI_basicUsageWithConverter() {
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        Table toto = new Table("Toto");
        Column id = toto.addColumn("id", Long.class).primaryKey();
        Column name = toto.addColumn("name", String.class);
        return new Object[][]{{new QueryMapper(Toto.class, (CharSequence)"select id, name from Toto", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("id", Toto::setId).map("name", Toto::setName, input -> "coucou")}, {new QueryMapper(Toto.class, (CharSequence)"select id, active from Toto", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("id", Toto::setId).map("active", Toto::setName, Boolean.TYPE, input -> "coucou")}, {new QueryMapper(Toto.class, (CharSequence)"select id, name from Toto", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("id", Toto::setId).map(name, Toto::setName, input -> "coucou")}};
    }

    @ParameterizedTest
    @MethodSource(value={"queryMapperAPI_basicUsageWithConverter"})
    void queryMapperAPI_withConverter(QueryMapper<Toto> queryMapper) {
        List resultSetData = Arrays.asList((Object[])new Map[]{QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"ghoeihvoih").add((Object)"active", (Object)false), QueryMapperTest.newRow().add((Object)"id", (Object)43L).add((Object)"name", (Object)"oziuoie").add((Object)"active", (Object)false)});
        Set<Toto> result = this.invokeExecuteWithData(queryMapper, resultSetData);
        ((AbstractCollectionAssert)Assertions.assertThat(result).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(42L, "coucou", false), new Toto(43L, "coucou", false)});
    }

    @Test
    void execute_noGivenKey_oneInstancePerRowIsCreated() {
        List resultSetData = Arrays.asList((Object[])new Map[]{QueryMapperTest.newRow().add((Object)"name", (Object)"coucou").add((Object)"active", (Object)true), QueryMapperTest.newRow().add((Object)"name", (Object)"hello").add((Object)"active", (Object)false), QueryMapperTest.newRow().add((Object)"name", (Object)"hola").add((Object)"active", (Object)false), QueryMapperTest.newRow().add((Object)"name", (Object)"salut").add((Object)"active", (Object)false)});
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        Table totoTable = new Table("Toto");
        totoTable.addColumn("name", String.class);
        totoTable.addColumn("active", Boolean.TYPE);
        QueryMapper testInstance = new QueryMapper(TotoWithNoArgConstructor.class, (CharSequence)"never executed statement", columnBinderRegistry, readOperationFactory).map("name", Toto::setName, String.class).map("active", Toto::setActive);
        Set result = this.invokeExecuteWithData(testInstance, resultSetData);
        ((AbstractCollectionAssert)Assertions.assertThat(result).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(-1L, "coucou", true), new Toto(-1L, "hello", false), new Toto(-1L, "hola", false), new Toto(-1L, "salut", false)});
    }

    private <C> Set<C> invokeExecuteWithData(QueryMapper<C> queryMapper, List<? extends Map<? extends String, ? extends Object>> resultSetData) {
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        try {
            PreparedStatement statementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            Mockito.when((Object)connectionMock.prepareStatement((String)ArgumentMatchers.any())).thenReturn((Object)statementMock);
            Mockito.when((Object)statementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet(resultSetData));
        }
        catch (SQLException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
        return queryMapper.execute(() -> connectionMock);
    }

    @Test
    void execute_instanceHasParameter() throws SQLException {
        ArgumentCaptor captor;
        PreparedStatement statementMock;
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        QueryMapper queryMapper = new QueryMapper(Toto.class, (CharSequence)"select id, name from Toto where id in (:id)", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).set("id", (Iterable)Arrays.asList((Object[])new Integer[]{1, 2}), Integer.class);
        List resultSetData = Arrays.asList((Object[])new Map[]{QueryMapperTest.newRow().add((Object)"id", (Object)42L)});
        Connection mock = (Connection)Mockito.mock(Connection.class);
        try {
            statementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
            captor = ArgumentCaptor.forClass(Integer.class);
            Mockito.when((Object)mock.prepareStatement((String)ArgumentMatchers.any())).thenReturn((Object)statementMock);
            Mockito.when((Object)statementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet((Iterable)resultSetData));
        }
        catch (SQLException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
        Set result = queryMapper.execute(() -> mock);
        ((PreparedStatement)Mockito.verify((Object)statementMock, (VerificationMode)Mockito.times((int)2))).setInt(ArgumentMatchers.anyInt(), (Integer)captor.capture());
        Assertions.assertThat((List)captor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new Integer[]{1, 2}));
        Assertions.assertThat((String)((Toto)Iterables.first((Iterable)result)).toString()).isEqualTo(new Toto(42L).toString());
    }

    @Test
    void execute_instanceHasAssembler() {
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        MutableInt assemblerCounter = new MutableInt();
        QueryMapper queryMapper = new QueryMapper(Toto.class, (CharSequence)"Whatever SQL ... it is not executed", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map((rootBean, resultSet) -> rootBean.setName(resultSet.getString("name") + assemblerCounter.increment()));
        List resultSetData = Arrays.asList((Object[])new Map[]{QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"ghoeihvoih"), QueryMapperTest.newRow().add((Object)"id", (Object)43L).add((Object)"name", (Object)"oziuoie"), QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"ghoeihvoih")});
        Set result = this.invokeExecuteWithData(queryMapper, resultSetData);
        List expected = Arrays.asList((Object[])new Toto[0]);
        ((AbstractCollectionAssert)Assertions.assertThat(result).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(42L, "ghoeihvoih3", false), new Toto(43L, "oziuoie2", false)});
    }

    @Test
    void execute_instanceHasAssembler_thatRunOnce() {
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        MutableInt assemblerCounter = new MutableInt();
        QueryMapper queryMapper = new QueryMapper(Toto.class, (CharSequence)"Whatever SQL ... it is not executed", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map((rootBean, resultSet) -> rootBean.setName(resultSet.getString("name") + assemblerCounter.increment()), WholeResultSetTransformer.AssemblyPolicy.ONCE_PER_BEAN);
        List resultSetData = Arrays.asList((Object[])new Map[]{QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"ghoeihvoih"), QueryMapperTest.newRow().add((Object)"id", (Object)43L).add((Object)"name", (Object)"oziuoie"), QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"ghoeihvoih")});
        Set result = this.invokeExecuteWithData(queryMapper, resultSetData);
        ((AbstractCollectionAssert)Assertions.assertThat(result).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(42L, "ghoeihvoih1", false), new Toto(43L, "oziuoie2", false)});
    }

    @Test
    void execute_instanceHasToOneRelation() {
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        QueryMapper queryMapper = new QueryMapper(Toto.class, (CharSequence)"Whatever SQL ... it is not executed", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("name", Toto::setName).map(Toto::setTata, new ResultSetRowTransformer(Tata.class, "tataName", DefaultResultSetReaders.STRING_READER, Tata::new));
        List resultSetData = Arrays.asList((Object[])new Map[]{QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"John").add((Object)"tataName", (Object)"you"), QueryMapperTest.newRow().add((Object)"id", (Object)43L).add((Object)"name", (Object)"Bob").add((Object)"tataName", (Object)"me"), QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"John").add((Object)"tataName", (Object)"you")});
        Set result = this.invokeExecuteWithData(queryMapper, resultSetData);
        ((AbstractCollectionAssert)Assertions.assertThat(result).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(42L, "John", false).setTata(new Tata("you")), new Toto(43L, "Bob", false).setTata(new Tata("me"))});
    }

    @Test
    void execute_instanceHasToManyRelation() {
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        BeanRelationFixer titiCombiner = BeanRelationFixer.of(Tata::setTitis, Tata::getTitis, HashSet::new);
        QueryMapper queryMapper = new QueryMapper(Toto.class, (CharSequence)"Whatever SQL ... it is not executed", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("name", Toto::setName).map(Toto::setTata, new ResultSetRowTransformer(Tata.class, "tataName", DefaultResultSetReaders.STRING_READER, Tata::new).add(titiCombiner, new ResultSetRowTransformer(Titi.class, "titiName", DefaultResultSetReaders.STRING_READER, Titi::new)));
        List resultSetData = Arrays.asList((Object[])new Map[]{QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"John").add((Object)"tataName", (Object)"you").add((Object)"titiName", (Object)"titi"), QueryMapperTest.newRow().add((Object)"id", (Object)43L).add((Object)"name", (Object)"Bob").add((Object)"tataName", (Object)"me").add((Object)"titiName", null), QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"John").add((Object)"tataName", (Object)"you").add((Object)"titiName", (Object)"titi")});
        Set result = this.invokeExecuteWithData(queryMapper, resultSetData);
        ((AbstractCollectionAssert)Assertions.assertThat(result).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new Toto[]{new Toto(42L, "John", false).setTata(new Tata("you").setTitis(Arrays.asHashSet((Object[])new Titi[]{new Titi("titi")}))), new Toto(43L, "Bob", false).setTata(new Tata("me"))});
    }

    @Test
    void execute_emptyResultSet() {
        List resultSetData = Collections.EMPTY_LIST;
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
        ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        Table totoTable = new Table("Toto");
        totoTable.addColumn("name", String.class);
        totoTable.addColumn("active", Boolean.TYPE);
        QueryMapper testInstance = new QueryMapper(Toto.class, (CharSequence)"never executed statement", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("name", Toto::setName, String.class).map("active", Toto::setActive);
        Set result = this.invokeExecuteWithData(testInstance, resultSetData);
        Assertions.assertThat(result).isEmpty();
    }

    private static Maps.ChainingHashMap<String, Object> newRow() {
        return Maps.forHashMap(String.class, Object.class);
    }

    private static class Titi {
        private final String name;

        public Titi(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return Strings.footPrint((Object)this, (Function[])new Function[]{t -> "Titi", t -> t.name});
        }
    }

    private static class Tata {
        private final String name;
        private Set<Titi> titis;

        public Tata(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Set<Titi> getTitis() {
            return this.titis;
        }

        public Tata setTitis(Set<Titi> titis) {
            this.titis = titis;
            return this;
        }

        public String toString() {
            return Strings.footPrint((Object)this, (Function[])new Function[]{t -> "Tata", t -> t.name});
        }
    }

    public static class TotoWithThreeArgConstructor
    extends Toto {
        public TotoWithThreeArgConstructor(long id, String name, boolean active) {
            super(id, name, active);
        }
    }

    public static class TotoWithTwoArgConstructor
    extends Toto {
        public TotoWithTwoArgConstructor(long id, String name) {
            super(id, name);
        }
    }

    public static class TotoWithOneArgConstructor
    extends Toto {
        public TotoWithOneArgConstructor(long id) {
            super(id);
        }
    }

    public static class TotoWithNoArgConstructor
    extends Toto {
        public TotoWithNoArgConstructor() {
            super(-1L);
        }
    }

    public static class Toto {
        private long id;
        private String name;
        private boolean active;
        private Tata tata;

        public static Toto ofId(long id) {
            return new Toto(id);
        }

        public static Toto ofIdAndName(long id, String name) {
            return new Toto(id, name);
        }

        public static Toto ofIdAndNameAndActive(long id, String name, boolean active) {
            return new Toto(id, name, active);
        }

        public Toto(long id) {
            this.id = id;
        }

        public Toto(long id, String name) {
            this.id = id;
            this.name = name;
        }

        public Toto(long id, String name, boolean active) {
            this.id = id;
            this.name = name;
            this.active = active;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Toto setTata(Tata tata) {
            this.tata = tata;
            return this;
        }

        public Tata getTata() {
            return this.tata;
        }

        public String toString() {
            return Strings.footPrint((Object)this, (Function[])new Function[]{t -> t.id, t -> t.name, t -> t.active, t -> (String)Nullable.nullable((Object)t.tata).map(Tata::getName).get(), t -> (Set)Nullable.nullable((Object)t.tata).map(Tata::getTitis).get()});
        }
    }

    @Nested
    class WithAccumulator {
        WithAccumulator() {
        }

        @Test
        void execute_first_retrievedFirstBean() {
            ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
            ReadOperationFactory readOperationFactory = new ReadOperationFactory();
            QueryMapper queryMapper = new QueryMapper(Toto.class, (CharSequence)"Whatever SQL ... it is not executed", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map((rootBean, resultSet) -> rootBean.setName(Objects.preventNull((String)rootBean.getName()) + resultSet.getString("name")));
            List resultSetData = Arrays.asList((Object[])new Map[]{QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)"Hello"), QueryMapperTest.newRow().add((Object)"id", (Object)42L).add((Object)"name", (Object)" world !"), QueryMapperTest.newRow().add((Object)"id", (Object)43L).add((Object)"name", (Object)"Bonjour"), QueryMapperTest.newRow().add((Object)"id", (Object)43L).add((Object)"name", (Object)" le monde !")});
            Toto result = (Toto)this.invokeExecuteFirstWithData(queryMapper, resultSetData);
            Toto expected = new Toto(42L, "Hello world !", false);
            Assertions.assertThat((String)result.toString()).isEqualTo(expected.toString());
        }

        @Test
        void execute_emptyResultSet_returnsNull() {
            List resultSetData = Collections.EMPTY_LIST;
            ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry();
            ReadOperationFactory readOperationFactory = new ReadOperationFactory();
            Table totoTable = new Table("Toto");
            totoTable.addColumn("name", String.class);
            totoTable.addColumn("active", Boolean.TYPE);
            QueryMapper testInstance = new QueryMapper(Toto.class, (CharSequence)"never executed statement", columnBinderRegistry, readOperationFactory).mapKey(Toto::new, "id", Long.TYPE).map("name", Toto::setName, String.class);
            Toto result = (Toto)this.invokeExecuteFirstWithData(testInstance, resultSetData);
            Assertions.assertThat((Object)result).isNull();
        }

        private <C> C invokeExecuteFirstWithData(QueryMapper<C> queryMapper, List<? extends Map<? extends String, ? extends Object>> resultSetData) {
            Connection connectionMock = (Connection)Mockito.mock(Connection.class);
            try {
                PreparedStatement statementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
                Mockito.when((Object)connectionMock.prepareStatement((String)ArgumentMatchers.any())).thenReturn((Object)statementMock);
                Mockito.when((Object)statementMock.executeQuery()).thenReturn((Object)new InMemoryResultSet(resultSetData));
            }
            catch (SQLException e) {
                throw Exceptions.asRuntimeException((Throwable)e);
            }
            return (C)queryMapper.execute(() -> connectionMock, Accumulators.getFirst());
        }
    }
}

