/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.PersisterWrapper;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Iterables;

public class EntityIsManagedByPersisterAsserter<C, I>
extends PersisterWrapper<C, I> {
    private final Consumer<C> asserter;

    public EntityIsManagedByPersisterAsserter(ConfiguredRelationalPersister<C, I> delegate) {
        super(delegate);
        if (this.getDeepestDelegate() instanceof PolymorphicPersister) {
            Set supportedEntityTypes = ((PolymorphicPersister)((Object)this.getDeepestDelegate())).getSupportedEntityTypes();
            this.asserter = entity -> {
                if (!supportedEntityTypes.contains(entity.getClass())) {
                    throw this.newAssertException(entity);
                }
            };
        } else {
            this.asserter = entity -> {
                if (!this.getClassToPersist().equals(entity.getClass())) {
                    throw this.newAssertException(entity);
                }
            };
        }
    }

    private UnsupportedOperationException newAssertException(C entity) {
        return new UnsupportedOperationException("Persister of " + Reflections.toString(this.getClassToPersist()) + " is not configured to persist " + Reflections.toString(entity.getClass()));
    }

    @VisibleForTesting
    void assertPersisterManagesEntities(Iterable<? extends C> entity) {
        entity.forEach(this::assertPersisterManagesEntity);
    }

    @VisibleForTesting
    void assertPersisterManagesEntity(C entity) {
        this.asserter.accept(entity);
    }

    @Override
    public void persist(Iterable<? extends C> entities) {
        this.assertPersisterManagesEntities(entities);
        super.persist(entities);
    }

    @Override
    public void insert(Iterable<? extends C> entities) {
        this.assertPersisterManagesEntities(entities);
        super.insert(entities);
    }

    @Override
    public void update(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        List nonNullEntities = Iterables.stream(differencesIterable).map(Duo::getLeft).filter(Objects::nonNull).collect(Collectors.toList());
        this.assertPersisterManagesEntities(nonNullEntities);
        super.update(differencesIterable, allColumnsStatement);
    }

    @Override
    public void updateById(Iterable<? extends C> entities) {
        this.assertPersisterManagesEntities(entities);
        super.updateById(entities);
    }

    @Override
    public void delete(Iterable<? extends C> entities) {
        List nonNullEntities = Iterables.stream(entities).filter(Objects::nonNull).collect(Collectors.toList());
        this.assertPersisterManagesEntities(nonNullEntities);
        super.delete(nonNullEntities);
    }

    @Override
    public void deleteById(Iterable<? extends C> entities) {
        this.assertPersisterManagesEntities(entities);
        super.deleteById(entities);
    }
}

