/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.HashSet;
import java.util.Set;
import org.codefilarete.stalactite.engine.DeleteExecutor;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.PersisterListener;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.ThrowingRunnable;

public abstract class PersisterListenerWrapper<C, I>
implements PersistExecutor<C>,
InsertExecutor<C>,
UpdateExecutor<C>,
SelectExecutor<C, I>,
DeleteExecutor<C, I>,
PersisterListener<C, I> {
    private final PersisterListenerCollection<C, I> persisterListener = new PersisterListenerCollection();

    @Override
    public void addPersistListener(PersistListener<? extends C> persistListener) {
        this.persisterListener.addPersistListener(persistListener);
    }

    @Override
    public void addInsertListener(InsertListener<? extends C> insertListener) {
        this.persisterListener.addInsertListener(insertListener);
    }

    @Override
    public void addUpdateListener(UpdateListener<? extends C> updateListener) {
        this.persisterListener.addUpdateListener(updateListener);
    }

    @Override
    public void addUpdateByIdListener(UpdateByIdListener<? extends C> updateByIdListener) {
        this.persisterListener.addUpdateByIdListener(updateByIdListener);
    }

    @Override
    public void addSelectListener(SelectListener<? extends C, I> selectListener) {
        this.persisterListener.addSelectListener(selectListener);
    }

    @Override
    public void addDeleteListener(DeleteListener<? extends C> deleteListener) {
        this.persisterListener.addDeleteListener(deleteListener);
    }

    @Override
    public void addDeleteByIdListener(DeleteByIdListener<? extends C> deleteListener) {
        this.persisterListener.addDeleteByIdListener(deleteListener);
    }

    public PersisterListenerCollection<C, I> getPersisterListener() {
        return this.persisterListener;
    }

    @Override
    public void delete(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.persisterListener.doWithDeleteListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doDelete(entities)));
        }
    }

    protected abstract void doDelete(Iterable<? extends C> var1);

    @Override
    public void deleteById(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.persisterListener.doWithDeleteByIdListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doDeleteById(entities)));
        }
    }

    protected abstract void doDeleteById(Iterable<? extends C> var1);

    @Override
    public void insert(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.persisterListener.doWithInsertListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doInsert(entities)));
        }
    }

    protected abstract void doInsert(Iterable<? extends C> var1);

    @Override
    public void persist(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.persisterListener.doWithPersistListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doPersist(entities)));
        }
    }

    protected abstract void doPersist(Iterable<? extends C> var1);

    @Override
    public Set<C> select(Iterable<I> ids) {
        if (Iterables.isEmpty(ids)) {
            return new HashSet();
        }
        return this.persisterListener.doWithSelectListener(ids, () -> this.doSelect(ids));
    }

    protected abstract Set<C> doSelect(Iterable<I> var1);

    @Override
    public void updateById(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.persisterListener.doWithUpdateByIdListener(entities, (ThrowingRunnable<RuntimeException>)((ThrowingRunnable)() -> this.doUpdateById(entities)));
        }
    }

    protected abstract void doUpdateById(Iterable<? extends C> var1);

    @Override
    public void update(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        if (!Iterables.isEmpty(differencesIterable)) {
            this.persisterListener.doWithUpdateListener(differencesIterable, allColumnsStatement, this::doUpdate);
        }
    }

    protected abstract void doUpdate(Iterable<? extends Duo<C, C>> var1, boolean var2);
}

