/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import javax.sql.DataSource;
import org.codefilarete.stalactite.engine.ConnectionSettings;
import org.codefilarete.stalactite.engine.CurrentThreadTransactionalConnectionProvider;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.DialectBuilder;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.DialectOptions;

public class PersistenceContextConfigurationBuilder {
    protected final DatabaseVendorSettings vendorSettings;
    protected final ConnectionSettings connectionSettings;
    protected final DataSource dataSource;

    public PersistenceContextConfigurationBuilder(DatabaseVendorSettings vendorSettings, ConnectionSettings connectionSettings, DataSource dataSource) {
        this.vendorSettings = vendorSettings;
        this.connectionSettings = connectionSettings;
        this.dataSource = dataSource;
    }

    public PersistenceContextConfiguration build() {
        return this.build(DialectOptions.noOptions());
    }

    public PersistenceContextConfiguration build(DialectOptions dialectOptions) {
        Dialect dialect = new DialectBuilder(this.vendorSettings, dialectOptions).build();
        ConnectionConfiguration connectionConfiguration = this.buildConnectionConfiguration();
        return new PersistenceContextConfiguration(connectionConfiguration, dialect);
    }

    protected ConnectionConfiguration buildConnectionConfiguration() {
        return new ConnectionConfiguration.ConnectionConfigurationSupport(new CurrentThreadTransactionalConnectionProvider(this.dataSource), this.connectionSettings.getBatchSize());
    }

    public static class PersistenceContextConfiguration {
        private final ConnectionConfiguration connectionConfiguration;
        private final Dialect dialect;

        public PersistenceContextConfiguration(ConnectionConfiguration connectionConfiguration, Dialect dialect) {
            this.connectionConfiguration = connectionConfiguration;
            this.dialect = dialect;
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public ConnectionConfiguration getConnectionConfiguration() {
            return this.connectionConfiguration;
        }
    }
}

