/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class GeneratedKeysReaderTest {
    GeneratedKeysReaderTest() {
    }

    @Test
    void convert() {
        GeneratedKeysReader testInstance = new GeneratedKeysReader("key", ResultSet::getLong);
        List readValues = testInstance.convert((ResultSet)new InMemoryResultSet((Iterable)Arrays.asList((Object[])new Maps.ChainingMap[]{Maps.asMap((Object)"key", (Object)13L), Maps.asMap((Object)"key", (Object)17L), Maps.asMap((Object)"key", (Object)19L)})));
        Assertions.assertThat((List)readValues).containsExactly((Object[])new Long[]{13L, 17L, 19L});
    }

    @Test
    void read_writeOperation() throws SQLException {
        GeneratedKeysReader<Long> testInstance = new GeneratedKeysReader<Long>("key", ResultSet::getLong){

            public List<Long> convert(ResultSet generatedKeys) {
                return Collections.emptyList();
            }
        };
        WriteOperation dummySQL = new WriteOperation((SQLStatement)new StringParamedSQL("dummySQL", new HashMap()), (ConnectionProvider)Mockito.mock(ConnectionProvider.class), writeCount -> {});
        dummySQL.preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        testInstance.convert(dummySQL);
        ((PreparedStatement)Mockito.verify((Object)dummySQL.preparedStatement)).getGeneratedKeys();
    }
}

